/*
 * Decompiled with CFR 0.152.
 */
import fr.ens.transcriptome.corsen.Globals;
import fr.ens.transcriptome.corsen.imagej.CorsenImageJUtil;
import fr.ens.transcriptome.corsen.imagej.Segmentation2DRunner;
import fr.ens.transcriptome.corsen.imagej.Segmentation3DRunner;
import fr.ens.transcriptome.corsen.model.ListPoint2DFactory;
import fr.ens.transcriptome.corsen.model.ListPoint3DFactory;
import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.model.Particles3D;
import fr.ens.transcriptome.corsen.util.Util;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class CorsenImageJPlugin
implements PlugInFilter {
    public static final int SHOW_RESULTS = 1;
    public static final int EXCLUDE_EDGE_PARTICLES = 2;
    public static final int CHANGE_OUTPUT_FILENAME = 4;
    public static final int NO_CONFIRM_SAVE_DIALOG = 8;
    public static final int SHOW_PARTICLES_3D = 16;
    public static final int PACK_PARTICLES_DATA = 32;
    private static final int IMAGEJ_PLUGIN_BASE_FLAGS = 2437;
    private static final int IMAGEJ_MINIMAL_VERSION = 39;
    private static final String OPTIONS = "Corsen.options";
    private static int staticOptions = Prefs.getInt((String)"Corsen.options", (int)0);
    private ImagePlus imp;
    private int options;
    private boolean cancel;
    private int slice;
    private int nSlices;
    private int width;
    private int height;
    private ResultsTable rt = new ResultsTable();
    private boolean ImageJVersionOk;
    private Segmentation2DRunner seg2DRunner;
    private Segmentation3DRunner seg3DRunner = new Segmentation3DRunner();
    private List<Particle3D> particles3DToSave;

    public int setup(String arg, ImagePlus imp) {
        if (arg.equals("about")) {
            this.showAbout();
            return 4096;
        }
        IJ.register(CorsenImageJPlugin.class);
        if (imp == null) {
            IJ.noImage();
            return 4096;
        }
        this.imp = imp;
        this.nSlices = imp.getNSlices();
        if (!this.showDialog()) {
            return 4096;
        }
        int flags = IJ.setupDialog((ImagePlus)imp, (int)2437);
        this.slice = 0;
        this.seg3DRunner.clear();
        this.cancel = false;
        return flags;
    }

    public void run(ImageProcessor ip) {
        if (!this.ImageJVersionOk) {
            this.ImageJVersionOk = this.testImageJVersion();
        }
        if (this.cancel || !this.ImageJVersionOk || !this.testThreshold(ip)) {
            return;
        }
        ++this.slice;
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        if (this.slice == 1) {
            this.initForANewStack();
        }
        this.seg3DRunner.addParticles2DForSegmentation3D(this.seg2DRunner.getParticles2D(ip), this.slice, this.imp.getCalibration().pixelDepth, this.imp.getTitle());
        IJ.showProgress((double)((double)this.slice / (double)this.nSlices));
        if (this.slice == this.nSlices) {
            this.afterSegmentation();
            this.seg2DRunner = null;
            this.seg3DRunner.clear();
            this.particles3DToSave.clear();
        }
    }

    private void initForANewStack() {
        IJ.showProgress((double)0.0);
        boolean packedMode = (this.options & 0x20) != 0;
        ListPoint2DFactory.setPackedMode(packedMode);
        ListPoint3DFactory.setPackedMode(packedMode);
        Calibration cal = this.imp.getCalibration();
        this.seg2DRunner = new Segmentation2DRunner(cal.pixelWidth, cal.pixelHeight);
    }

    private void afterSegmentation() {
        try {
            this.particles3DToSave = this.seg3DRunner.getParticlesToSave((this.options & 2) != 0);
            if ((this.options & 1) != 0) {
                this.showSummary();
            }
            if ((this.options & 0x10) != 0) {
                this.showParticles3D(this.imp);
            }
            this.particles3DResultsProcessor(this.imp);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog((Component)this.imp.getWindow(), e.getMessage());
        }
    }

    private String getImageJVersion() {
        String result = null;
        try {
            Class<?> imagej = Class.forName("ij.ImageJ");
            Field version = imagej.getDeclaredField("VERSION");
            result = (String)version.get(ImageJ.class);
        }
        catch (ClassNotFoundException e) {
        }
        catch (SecurityException e) {
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return result;
    }

    private boolean testImageJVersion() {
        String msg;
        String version = this.getImageJVersion();
        if (version == null) {
            return true;
        }
        Pattern versionPattern = Pattern.compile("^(\\d+)\\.(\\d+)(.*)");
        Matcher m = versionPattern.matcher(version);
        if (!m.matches()) {
            msg = "Invalid ImageJ version.\n";
        } else {
            int major = Integer.parseInt(m.group(1));
            int minor = Integer.parseInt(m.group(2));
            msg = major != 1 ? "Corsen plugin work only with ImageJ 1.x.\n" : (minor == 41 ? "The 1.41 version of ImageJ is buggy.\nPlease upgrade your imageJ version (Help > Update ImageJ) \nor reinstall the last version from ImageJ website.\n" : (minor < 39 ? "Corsen plugin need a version of Image >= 1.39.\nPlease upgrade your imageJ version (Help > Update ImageJ) \nor reinstall the last version from ImageJ website.\n" : null));
        }
        if (msg != null) {
            this.cancel = true;
            IJ.error((String)"Corsen plugin", (String)msg);
            return false;
        }
        return true;
    }

    private boolean testThreshold(ImageProcessor ip) {
        double t1 = ip.getMinThreshold();
        if (t1 == -808080.0) {
            this.cancel = true;
            IJ.error((String)"Corsen plugin", (String)"A thresholded image is required.\nThreshold levels can be set using\nthe Image->Adjust->Threshold tool.");
            return false;
        }
        return true;
    }

    public boolean showDialog() {
        GenericDialog gd = new GenericDialog(Globals.getWindowsTitle());
        this.options = staticOptions;
        String[] labels = new String[6];
        boolean[] states = new boolean[6];
        labels[0] = "Display Results";
        states[0] = (this.options & 1) != 0;
        labels[1] = "Exclude on Edges";
        states[1] = (this.options & 2) != 0;
        labels[2] = "Change output file name";
        states[2] = (this.options & 4) != 0;
        labels[3] = "No confirm save dialog";
        states[3] = (this.options & 8) != 0;
        labels[4] = "Show Particles 3D";
        states[4] = (this.options & 0x10) != 0;
        labels[5] = "Pack Particle data";
        states[5] = (this.options & 0x20) != 0;
        gd.addCheckboxGroup(3, 2, labels, states);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.options = gd.getNextBoolean() ? (this.options |= 1) : (this.options &= 0xFFFFFFFE);
        this.options = gd.getNextBoolean() ? (this.options |= 2) : (this.options &= 0xFFFFFFFD);
        this.options = gd.getNextBoolean() ? (this.options |= 4) : (this.options &= 0xFFFFFFFB);
        this.options = gd.getNextBoolean() ? (this.options |= 8) : (this.options &= 0xFFFFFFF7);
        this.options = gd.getNextBoolean() ? (this.options |= 0x10) : (this.options &= 0xFFFFFFEF);
        this.options = gd.getNextBoolean() ? (this.options |= 0x20) : (this.options &= 0xFFFFFFDF);
        staticOptions = this.options;
        return true;
    }

    private void showParticles3D(ImagePlus imp) {
        ImageStack stack = new ImageStack(imp.getWidth(), imp.getHeight());
        int nSlices = imp.getNSlices();
        for (int i = 0; i < nSlices; ++i) {
            ColorProcessor drawIP = new ColorProcessor(this.width, this.height);
            drawIP.setColor(Color.white);
            drawIP.fill();
            stack.addSlice(null, (ImageProcessor)drawIP);
        }
        int r = 0;
        int g = 125;
        int b = 255;
        for (Particle3D p : this.particles3DToSave) {
            boolean optionExcludeOnEdge;
            boolean bl = optionExcludeOnEdge = (this.options & 2) != 0;
            if (optionExcludeOnEdge && p.isEdgeParticle()) continue;
            CorsenImageJUtil.addParticle3DtoStack(stack, p, new Color(r, g, b));
            g += 10;
            b += 15;
            if ((r += 5) > 255) {
                r -= 255;
            }
            if (g > 255) {
                g -= 255;
            }
            if (b <= 255) continue;
            b -= 255;
        }
        new ImagePlus("Particles 3D found by Corsen", stack).show();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void particles3DResultsProcessor(ImagePlus imp) throws IOException {
        File file = null;
        if ((this.options & 4) != 0) {
            file = this.chooseResultFile(imp);
            if (file == null) {
                return;
            }
        } else {
            boolean writeFile = false;
            if ((this.options & 8) == 0) {
                int response = JOptionPane.showConfirmDialog((Component)imp.getWindow(), new String[]{"Save results ?"}, "Save results ?", 0, 2);
                if (response != 0) return;
                writeFile = true;
            } else {
                writeFile = true;
            }
            if (writeFile) {
                FileInfo fi = imp.getOriginalFileInfo();
                if (fi == null) {
                    int response = JOptionPane.showConfirmDialog((Component)imp.getWindow(), new String[]{"No location is associated to the current image.", "You select the result filename"}, "Warning", 0, 2);
                    if (response == 1) {
                        return;
                    }
                    file = this.chooseResultFile(imp);
                } else {
                    int index = fi.fileName.lastIndexOf(".");
                    String newName = index == -1 ? fi.fileName : fi.fileName.substring(0, index);
                    file = new File(fi.directory, newName + ".par");
                }
            }
        }
        if (file == null) return;
        this.saveParticles3DFile(file, imp.getOriginalFileInfo());
    }

    private File chooseResultFile(ImagePlus imp) {
        JFileChooser chooser = new JFileChooser();
        FileFilter ff = new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = Util.getExtension(f);
                return extension != null && extension.equals(".par");
            }

            public String getDescription() {
                return "Particle file (*.par)";
            }
        };
        chooser.setFileFilter(ff);
        int result = chooser.showSaveDialog((Component)imp.getWindow());
        if (result == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    private void saveParticles3DFile(File outputFile, FileInfo fi) throws IOException {
        FileOutputStream fos = new FileOutputStream(outputFile);
        Particles3D particles = new Particles3D();
        File f = fi == null ? null : new File(fi.directory, fi.fileName);
        particles.setImageFilename(f != null ? f.getAbsolutePath() : null);
        particles.setImageFilenameDate(f != null ? new Date(f.lastModified()) : null);
        ImageProcessor ip = this.imp.getProcessor();
        Calibration cal = this.imp.getCalibration();
        particles.setWidth(this.imp.getWidth());
        particles.setHeight(this.imp.getHeight());
        particles.setZSlices(this.imp.getNSlices());
        particles.setPixelWidth((float)cal.pixelWidth);
        particles.setPixelHeight((float)cal.pixelHeight);
        particles.setPixelDepth((float)cal.pixelDepth);
        particles.setUnitOfLength(cal.getUnit());
        particles.setMinThreshold(ip.getMinThreshold());
        particles.setMaxThreshold(ip.getMaxThreshold());
        particles.setParticles(this.particles3DToSave);
        particles.saveParticles(fos);
    }

    private void showSummary() {
        this.rt.setHeading(0, "Internal id");
        this.rt.setHeading(1, "Area");
        this.rt.setHeading(2, "Volume");
        this.rt.setHeading(3, "Sphericity");
        this.rt.setHeading(4, "Intensity");
        this.rt.setHeading(5, "Density");
        this.rt.setHeading(6, "Median circularity");
        int count = 0;
        for (Particle3D p : this.particles3DToSave) {
            this.rt.incrementCounter();
            this.rt.setValue(0, count, (double)p.getId());
            this.rt.setValue(1, count, p.getArea());
            this.rt.setValue(2, count, p.getVolume());
            this.rt.setValue(3, count, p.getSphericity());
            this.rt.setValue(4, count, (double)p.getIntensity());
            this.rt.setValue(5, count, p.getDensity());
            this.rt.setValue(6, count, p.getMedianCircularity());
            ++count;
        }
        this.rt.show("Summary of Particles 3D found by Corsen");
    }

    public static void savePreferencesl(Properties prefs) {
        prefs.put(OPTIONS, Integer.toString(staticOptions));
    }

    public void savePreferences() {
        Prefs.set((String)OPTIONS, (String)Integer.toString(staticOptions));
    }

    private void showAbout() {
        IJ.showMessage((String)"Corsen", (String)Globals.ABOUT_TXT);
    }
}

