/*
 * Decompiled with CFR 0.152.
 */
import fr.ens.transcriptome.corsen.imagej.Segmentation2DRunner;
import fr.ens.transcriptome.corsen.imagej.Segmentation3DRunner;
import fr.ens.transcriptome.corsen.model.Particles3D;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public final class ImageJImageCreate {
    private static final int LEN = 50;
    private static final int INTENSITY = 100;
    private static final int MIN_THRESHOLD = 1;
    private static final int MAX_THRESHOLD = 2000;

    private static ImagePlus createHoriPoints(int step) {
        ImageStack is = new ImageStack(50, 50);
        for (int k = 0; k < 50 / step + 1; ++k) {
            ShortProcessor ip = new ShortProcessor(50, 50);
            if (k == 25 / step) {
                for (int i = 1; i < 50; i += step) {
                    if ((i - 1) % (6 / step) != 0) continue;
                    ip.set(i, 25, 100);
                }
            }
            is.addSlice("" + k / step, (ImageProcessor)ip);
        }
        ImagePlus ipl = new ImagePlus("hori", is);
        return ipl;
    }

    private static ImagePlus createVertPoints(int step) {
        ImageStack is = new ImageStack(50, 50);
        for (int k = 0; k < 51 / step + 1; ++k) {
            ShortProcessor ip = new ShortProcessor(50, 50);
            if ((k - 1) % (6 / step) == 0) {
                ip.set(25, 25, 100);
            }
            is.addSlice("" + k, (ImageProcessor)ip);
        }
        ImagePlus ipl = new ImagePlus("vert", is);
        return ipl;
    }

    private static ImagePlus create0ptImage(int step) {
        ImageStack is = new ImageStack(50, 50);
        for (int k = 0; k < 50 / step; ++k) {
            ShortProcessor ip = new ShortProcessor(50, 50);
            is.addSlice("" + k, (ImageProcessor)ip);
        }
        ImagePlus ipl = new ImagePlus("0pt", is);
        return ipl;
    }

    private static ImagePlus create1ptImage(int step) {
        ImageStack is = new ImageStack(50, 50);
        for (int k = 0; k < 50 / step; ++k) {
            ShortProcessor ip = new ShortProcessor(50, 50);
            if (k == 24) {
                ip.set(12, 12, 100);
            }
            is.addSlice("" + k, (ImageProcessor)ip);
        }
        ImagePlus ipl = new ImagePlus("1pt", is);
        return ipl;
    }

    private static ImagePlus createCubeImage(int step) {
        ImageStack is = new ImageStack(50, 50);
        int count = 0;
        for (int k = 0; k < 50 / step; ++k) {
            ShortProcessor ip = new ShortProcessor(50, 50);
            if (k > 12 / step && k <= 36 / step + 1) {
                for (int i = 13; i < 38; ++i) {
                    for (int j = 13; j < 38; ++j) {
                        ip.set(i, j, 100);
                        ++count;
                    }
                }
            }
            is.addSlice("" + k, (ImageProcessor)ip);
        }
        System.out.println("create a cube with " + count + " blocks.");
        ImagePlus ipl = new ImagePlus("cube", is);
        return ipl;
    }

    private static ImagePlus createPyramidImage(int step) {
        ImageStack is = new ImageStack(50, 50);
        int count = 0;
        for (int k = 0; k < 50 / step; ++k) {
            ShortProcessor ip = new ShortProcessor(50, 50);
            for (int i = 0; i < k; ++i) {
                for (int j = 0; j < k; ++j) {
                    ip.set(i, j, 100);
                    ++count;
                }
            }
            is.addSlice("" + k, (ImageProcessor)ip);
        }
        System.out.println("create a pyramid with " + count + " blocks.");
        ImagePlus ipl = new ImagePlus("pyramid", is);
        return ipl;
    }

    private static ImagePlus createSolidImage(int step) {
        ImageStack is = new ImageStack(50, 50);
        int count = 0;
        int max = 50 / step / 2;
        for (int k = 0; k < 50 / step; ++k) {
            ShortProcessor ip = new ShortProcessor(50, 50);
            for (int i = 0; i < max - k; ++i) {
                for (int j = 0; j < max + k; ++j) {
                    ip.set(i, j, 100);
                    ++count;
                }
            }
            is.addSlice("" + k, (ImageProcessor)ip);
        }
        System.out.println("create a solid with " + count + " blocks.");
        ImagePlus ipl = new ImagePlus("solid", is);
        return ipl;
    }

    private static Particles3D convertToParticles(ImagePlus ip, float pixelWidth, float pixelHeight, float pixelDepth) {
        if (ip == null) {
            return null;
        }
        Segmentation2DRunner s2Dr = new Segmentation2DRunner(pixelWidth, pixelHeight);
        Segmentation3DRunner seg3DRunner = new Segmentation3DRunner();
        int nSlices = ip.getNSlices();
        ImageStack is = ip.getStack();
        for (int i = 0; i < nSlices; ++i) {
            ImageProcessor ipr = is.getProcessor(i + 1);
            ipr.setThreshold(1.0, 2000.0, 2);
            seg3DRunner.addParticles2DForSegmentation3D(s2Dr.getParticles2D(ipr), i, pixelDepth, ip.getTitle());
        }
        Particles3D pars = new Particles3D();
        pars.setParticles(seg3DRunner.getParticlesToSave());
        return pars;
    }

    private static void createFile(ImagePlus ip, int step, String prefix) throws FileNotFoundException, IOException {
        ip.getProcessor().setThreshold(1.0, 2000.0, 2);
        Particles3D particles = ImageJImageCreate.convertToParticles(ip, 1.0f, 1.0f, 1.0f);
        particles.saveParticles(new FileOutputStream(new File(prefix + step + ".par")));
    }

    private static void createFiles(int step) throws FileNotFoundException, IOException {
        ImageJImageCreate.createFile(ImageJImageCreate.createCubeImage(step), step, "cube");
        ImageJImageCreate.createFile(ImageJImageCreate.createHoriPoints(step), step, "hori");
        ImageJImageCreate.createFile(ImageJImageCreate.createVertPoints(step), step, "vert");
        ImageJImageCreate.createFile(ImageJImageCreate.createPyramidImage(step), step, "pyramid");
        ImageJImageCreate.createFile(ImageJImageCreate.createSolidImage(step), step, "solid");
        ImageJImageCreate.createFile(ImageJImageCreate.create0ptImage(step), step, "0pt");
        ImageJImageCreate.createFile(ImageJImageCreate.create1ptImage(step), step, "1pt");
    }

    private ImageJImageCreate() {
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        ImageJImageCreate.createFiles(1);
        ImageJImageCreate.createFiles(2);
    }
}

