/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.jnl.ApplicationDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.jnlp.JNLPClassLoader;
import fr.ens.transcriptome.corsen.BootStrap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class BootStrapJDK6 {
    private static final String JAVA_PATH_MACOS = "/System/Library/Frameworks/JavaVM.framework/Versions/CurrentJDK/Commands/java";
    private static final String DEBUG_FILE = "javacmd.txt";
    private List<String> classpath = new ArrayList<String>();
    private String mainClass;
    private String[] args;
    private Map<String, String> properties = new HashMap<String, String>();
    private String vmArgs;
    private long maxHeap;
    private long minHeap;

    private static void save(File f, String s) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(f));
            writer.write(s);
            ((Writer)writer).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void collectInfos(JNLPClassLoader cl) {
        LaunchDesc ld = cl.getLaunchDesc();
        this.collectClasspath(ld);
        this.collectMainClass(ld);
        this.collectProperties(ld);
        this.collectJVM(ld.getResources().getSelectedJRE());
    }

    private void collectClasspath(LaunchDesc ld) {
        ArrayList<JARDesc> jarDescs = new ArrayList<JARDesc>();
        ResourcesDesc rd = ld.getResources();
        if (rd != null) {
            JARDesc[] jars = rd.getEagerOrAllJarDescs(true);
            for (int i = 0; i < jars.length; ++i) {
                if (!jars[i].isJavaFile() && !jars[i].isNativeLib()) continue;
                jarDescs.add(jars[i]);
            }
        }
        for (JARDesc jd : jarDescs) {
            URL location = jd.getLocation();
            String version = jd.getVersion();
            CacheEntry ce = Cache.getCacheEntry((URL)location, null, (String)version);
            this.classpath.add(ce.getDataFile().getAbsolutePath());
        }
    }

    private void collectMainClass(LaunchDesc ld) {
        if (ld.isApplet()) {
            System.exit(0);
        }
        ApplicationDesc ad = ld.getApplicationDescriptor();
        this.mainClass = ad.getMainClass();
        this.args = ad.getArguments();
    }

    private void collectJVM(JREDesc jreDesc) {
        this.maxHeap = JnlpxArgs.getMaxHeapSize();
        this.minHeap = JnlpxArgs.getInitialHeapSize();
        this.vmArgs = jreDesc.getVmArgs();
    }

    private void collectProperties(LaunchDesc ld) {
        ResourcesDesc rd = ld.getResources();
        Properties ps = rd.getResourceProperties();
        for (String string : ps.keySet()) {
            this.properties.put(string, ps.getProperty(string));
        }
    }

    public static void bootstrap() {
        ClassLoader cl = BootStrap.class.getClassLoader();
        if (cl == null) {
            return;
        }
        if (cl instanceof JNLPClassLoader) {
            BootStrapJDK6 b = new BootStrapJDK6();
            b.collectInfos((JNLPClassLoader)cl);
            String cmd = b.createCommandLine();
            BootStrapJDK6.exec(cmd);
            System.exit(0);
        }
    }

    private String createCommandLine() {
        StringBuffer sb = new StringBuffer();
        sb.append(JAVA_PATH_MACOS);
        sb.append(" -d32 -client");
        sb.append(" -cp ");
        boolean first = true;
        for (String path : this.classpath) {
            if (first) {
                first = false;
            } else {
                sb.append(":");
            }
            sb.append(path);
        }
        for (String key : this.properties.keySet()) {
            String value = this.properties.get(key);
            sb.append(" -D");
            sb.append(key);
            sb.append("=");
            sb.append(value);
        }
        if (this.vmArgs != null) {
            sb.append(" ");
            sb.append(this.vmArgs);
        }
        if (this.minHeap != -1L) {
            sb.append(" -Xms");
            sb.append(this.minHeap);
        }
        if (this.maxHeap != -1L) {
            sb.append(" -Xmx");
            sb.append(this.maxHeap);
        }
        sb.append(" ");
        sb.append(this.mainClass);
        for (int i = 0; i < this.args.length; ++i) {
            sb.append(" ");
            sb.append(this.args[i]);
        }
        return sb.toString();
    }

    private static void exec(String cmd) {
        Runtime rt = Runtime.getRuntime();
        try {
            rt.exec(cmd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private BootStrapJDK6() {
    }
}

