/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen;

import fr.ens.transcriptome.corsen.BootStrap;
import fr.ens.transcriptome.corsen.BootStrapJDK6;
import fr.ens.transcriptome.corsen.Globals;
import fr.ens.transcriptome.corsen.Settings;
import fr.ens.transcriptome.corsen.calc.ParticleType;
import fr.ens.transcriptome.corsen.gui.CLIGui;
import fr.ens.transcriptome.corsen.gui.CorsenFakeGui;
import fr.ens.transcriptome.corsen.gui.qt.CorsenQt;
import fr.ens.transcriptome.corsen.gui.swing.CorsenSwing;
import fr.ens.transcriptome.corsen.util.SystemUtil;
import fr.ens.transcriptome.corsen.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;

public final class Corsen {
    private static Logger logger = Logger.getLogger("Corsen");
    private static Settings settings;
    private static boolean batchMode;
    private static String batchFile;
    private static String[] mainArgs;
    private static boolean confFile;

    public static Settings getSettings() {
        return settings;
    }

    public static boolean isBatchMode() {
        return batchMode;
    }

    private static void bootstrap() {
        if (!System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
            return;
        }
        try {
            Corsen.class.getClassLoader().loadClass("com.sun.jnlp.JNLPClassLoader");
            if (SystemUtil.getJREMajorVersion() >= 6) {
                BootStrapJDK6.bootstrap();
            } else {
                BootStrap.bootstrap();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws IOException {
        Corsen.bootstrap();
        logger.setLevel(Globals.LOG_LEVEL);
        Corsen.parseCommandLine(args);
        if (batchFile != null) {
            if (!confFile) {
                Corsen.loadSettings(null);
            }
            batchMode = true;
            Corsen.executeBatchFile();
            return;
        }
        if (mainArgs != null && mainArgs.length == 3) {
            CLIGui.main(mainArgs);
            return;
        }
        switch (Globals.DEFAULT_GUI) {
            case FAKE: {
                CorsenFakeGui.main(args);
                return;
            }
            case SWING: {
                if (!confFile) {
                    Corsen.loadSettings(null);
                }
                CorsenSwing.main(args);
                return;
            }
            case QT: {
                if (!confFile) {
                    Corsen.loadSettings(null);
                }
                CorsenQt.main(args);
                return;
            }
        }
        System.err.println("No GUI defined.");
        System.exit(1);
    }

    private static void loadSettings(String confFilename) {
        Settings s = new Settings();
        try {
            s.loadSettings(confFilename);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        s.addSettings(settings);
        settings = s;
    }

    private static void about() {
        System.out.println(Globals.ABOUT_TXT);
        System.exit(0);
    }

    private static void licence() {
        System.out.println("This program is developed under the GNU General Public Licence version 2 or later and CeCILL.");
        System.exit(0);
    }

    private static void help(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Corsen particleA_file particleB_file output_prefix", options);
        System.exit(0);
    }

    private static Options makeOptions() {
        Option help = new Option("help", "show this message");
        Option about = new Option("about", "show information this software");
        Option licence = new Option("licence", "show information about the licence of this software");
        OptionBuilder.withArgName((String)"batchfile");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"batch file");
        Option batchFile = OptionBuilder.create((String)"batchFile");
        Option batch = new Option("batch", "batch mode");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"configuration file");
        Option conf = OptionBuilder.create((String)"conf");
        OptionBuilder.withArgName((String)"typea");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"particle A type");
        Option typea = OptionBuilder.create((String)"typea");
        OptionBuilder.withArgName((String)"typeb");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"particle B type");
        Option typeb = OptionBuilder.create((String)"typeb");
        OptionBuilder.withArgName((String)"unit");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"unit");
        Option unit = OptionBuilder.create((String)"unit");
        OptionBuilder.withArgName((String)"zfactor");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"z factor");
        Option zfactor = OptionBuilder.create((String)"zfactor");
        OptionBuilder.withArgName((String)"factor");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"coordinates factor");
        Option factor = OptionBuilder.create((String)"factor");
        OptionBuilder.withArgName((String)"number");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"number of threads");
        Option threads = OptionBuilder.create((String)"threads");
        Option od = new Option("od", "create output data files");
        Option oiv = new Option("oiv", "create output iv files");
        Option or = new Option("or", "create output results files");
        Option ova = new Option("ova", "create output particle A R visualisation files");
        Option ovac = new Option("ovac", "create output particle A cuboids R visualisation files");
        Option ovb = new Option("ovb", "create output particle B R visualisation files");
        Option ovbc = new Option("ovbc", "create output particle B cuboids R visualisation files");
        Option ovd = new Option("ovd", "create output distances R visualisation files");
        Options options = new Options();
        options.addOption(help);
        options.addOption(about);
        options.addOption(licence);
        options.addOption(conf);
        options.addOption(batchFile);
        options.addOption(batch);
        options.addOption(threads);
        options.addOption(typea);
        options.addOption(typeb);
        options.addOption(unit);
        options.addOption(zfactor);
        options.addOption(factor);
        options.addOption(od);
        options.addOption(oiv);
        options.addOption(or);
        options.addOption(ova);
        options.addOption(ovac);
        options.addOption(ovb);
        options.addOption(ovbc);
        options.addOption(ovd);
        return options;
    }

    private static void parseCommandLine(String[] args) {
        Options options = Corsen.makeOptions();
        Settings s = new Settings();
        try {
            String val;
            GnuParser parser = new GnuParser();
            int argsOptions = 0;
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("help")) {
                Corsen.help(options);
            }
            if (line.hasOption("about")) {
                Corsen.about();
            }
            if (line.hasOption("licence")) {
                Corsen.licence();
            }
            if (line.hasOption("conf")) {
                Corsen.loadSettings(line.getOptionValue("file"));
                s = settings;
                ++argsOptions;
            }
            if (line.hasOption("typea")) {
                s.setParticlesAType(ParticleType.getParticleType(line.getOptionValue("type")));
                ++argsOptions;
            }
            if (line.hasOption("typeb")) {
                s.setParticlesBType(ParticleType.getParticleType(line.getOptionValue("type")));
                ++argsOptions;
            }
            if (line.hasOption("factor")) {
                s.setFactor(line.getOptionValue("factor"));
                ++argsOptions;
            }
            if (line.hasOption("zfactor")) {
                s.setZFactor(line.getOptionValue("zfactor"));
                ++argsOptions;
            }
            if (line.hasOption("od")) {
                s.setSaveDataFile(true);
            }
            if (line.hasOption("oiv")) {
                s.setSaveIVFile(true);
            }
            if (line.hasOption("or")) {
                s.setSaveResultFile(true);
            }
            if (line.hasOption("ova")) {
                s.setSaveVisualizationFiles(true);
                s.setSaveParticlesA3dFile(true);
            }
            if (line.hasOption("ovac")) {
                s.setSaveVisualizationFiles(true);
                s.setSaveParticlesACuboids3dFile(true);
            }
            if (line.hasOption("ovb")) {
                s.setSaveVisualizationFiles(true);
                s.setSaveParticlesB3dFile(true);
            }
            if (line.hasOption("ovbc")) {
                s.setSaveVisualizationFiles(true);
                s.setSaveParticlesBCuboids3dFile(true);
            }
            if (line.hasOption("ovd")) {
                s.setSaveVisualizationFiles(true);
                s.setSaveDistances3dFile(true);
            }
            if (line.hasOption("threads") && (val = line.getOptionValue("threads")) != null) {
                try {
                    s.setThreadNumber(Integer.parseInt(val.trim()));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                ++argsOptions;
            }
            if (line.hasOption("batch")) {
                batchMode = true;
            }
            if (line.hasOption("batchFile")) {
                batchFile = line.getOptionValue("batchFile");
            }
            if ((mainArgs = line.getArgs()).length > 0 && mainArgs.length != 3) {
                Corsen.help(options);
            }
        }
        catch (UnrecognizedOptionException exp) {
            System.err.println(exp.getMessage());
            System.exit(1);
        }
        catch (MissingArgumentException exp) {
            System.err.println(exp.getMessage());
            System.exit(1);
        }
        catch (ParseException exp) {
            System.err.println("Error analysing command line. ");
            System.exit(1);
        }
        settings = s;
    }

    public static void executeBatchFile() {
        long startTime = System.currentTimeMillis();
        ArrayList<String[]> dirs = new ArrayList<String[]>();
        boolean error = false;
        try {
            FileReader fr = new FileReader(batchFile);
            BufferedReader br = new BufferedReader(fr);
            String line = null;
            boolean first = true;
            while ((line = br.readLine()) != null) {
                if (first) {
                    first = false;
                    continue;
                }
                String[] fields = line.split("\t");
                File dir = new File(fields[0]);
                final String prefixA = fields[1];
                final String prefixB = fields[2];
                if (!dir.exists()) {
                    error = true;
                    System.err.println("Directory not found : " + dir.getAbsolutePath());
                } else {
                    File[] filesA = dir.listFiles(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name.startsWith(prefixA);
                        }
                    });
                    File[] filesB = dir.listFiles(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name.startsWith(prefixB);
                        }
                    });
                    if (filesA == null || filesA.length == 0) {
                        System.err.println("Prefix a: " + prefixA + " in directory " + dir.getAbsolutePath());
                        error = true;
                    }
                    if (filesB == null || filesB.length == 0) {
                        System.err.println("Prefix b: " + prefixB + " in directory " + dir.getAbsolutePath());
                        error = true;
                    }
                }
                dirs.add(new String[]{fields[0], fields[1], fields[2]});
            }
            br.close();
        }
        catch (IOException e) {
            System.err.println("Error while reading batch file: " + batchFile);
        }
        if (!error) {
            for (String[] fields : dirs) {
                CLIGui.main(new String[]{fields[1], fields[2], fields[0]});
            }
        }
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        System.out.println("Process all data in " + Util.toTimeHumanReadable(totalTime) + " (" + totalTime + "ms).");
    }

    private Corsen() {
    }
}

