/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen;

import fr.ens.transcriptome.corsen.CorsenResultWriter;
import fr.ens.transcriptome.corsen.ProgressEvent;
import fr.ens.transcriptome.corsen.RGL;
import fr.ens.transcriptome.corsen.Settings;
import fr.ens.transcriptome.corsen.UpdateStatus;
import fr.ens.transcriptome.corsen.calc.CorsenResult;
import fr.ens.transcriptome.corsen.calc.DistancesCalculator;
import fr.ens.transcriptome.corsen.model.JavascriptParticles3DFilter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorsenCore
implements Runnable {
    private static Logger logger = Logger.getLogger("Corsen");
    private UpdateStatus updateStatus;
    private Settings settings = new Settings();
    private File dirFiles;
    private File particlesBFile;
    private File particlesAFile;
    private File resultFile;
    private boolean multipleFiles;

    public final UpdateStatus getUpdateStatus() {
        return this.updateStatus;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public File getDirFiles() {
        return this.dirFiles;
    }

    public File getParticlesBFile() {
        return this.particlesBFile;
    }

    public File getResultFile() {
        return this.resultFile;
    }

    public File getParticlesAFile() {
        return this.particlesAFile;
    }

    public boolean isMultipleFiles() {
        return this.multipleFiles;
    }

    public final void setUpdateStatus(UpdateStatus updateStatus) {
        this.updateStatus = updateStatus;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void setDirFiles(File dirFiles) {
        this.dirFiles = dirFiles;
    }

    public void setParticlesBFile(File particlesBFile) {
        this.particlesBFile = particlesBFile;
    }

    public void setResultFile(File resultFile) {
        this.resultFile = resultFile;
    }

    public void setParticlesAFile(File particlesAFile) {
        this.particlesAFile = particlesAFile;
    }

    public void setMultipleFiles(boolean multipleFiles) {
        this.multipleFiles = multipleFiles;
    }

    private void processACell(File rnaFile, File mitoFile, File resultFile) throws IOException {
        this.sendEvent(ProgressEvent.ProgressEventType.START_CELLS_EVENT, ProgressEvent.countPhase(this.settings));
        this.doACell(rnaFile, mitoFile, resultFile, 1, 1);
        this.sendEvent(ProgressEvent.ProgressEventType.END_CELLS_SUCCESSFULL_EVENT, 1, 1);
    }

    private void doACell(File particlesAFile, File particlesBFile, File resultFile, int currentCell, int cellCount) throws IOException {
        Settings s = this.getSettings();
        logger.info("File A: " + particlesAFile);
        logger.info("File B: " + particlesBFile);
        this.sendEvent(ProgressEvent.ProgressEventType.START_CELL_EVENT, currentCell, cellCount, particlesAFile.getAbsolutePath(), particlesBFile.getAbsolutePath(), resultFile.getAbsolutePath());
        CorsenResult result = new CorsenResult(particlesAFile, particlesBFile, resultFile, s, this.getUpdateStatus());
        result.setParticlesAFilter(JavascriptParticles3DFilter.createFilter(this.settings.getParticlesAFilterExpression()));
        result.setParticlesBFilter(JavascriptParticles3DFilter.createFilter(this.settings.getParticlesBFilterExpression()));
        CorsenResultWriter writer = new CorsenResultWriter(result);
        DistancesCalculator dc = new DistancesCalculator(result);
        dc.setCoordinatesFactor(this.settings.getFactor());
        dc.setZCoordinatesFactor(this.settings.getZFactor());
        dc.loadParticles();
        result.getParticlesA().setType(this.settings.getParticlesAType());
        result.getParticlesB().setType(this.settings.getParticlesBType());
        dc.calc();
        if (s.isSaveDataFile()) {
            this.sendEvent(ProgressEvent.ProgressEventType.START_WRITE_DATA_EVENT);
            writer.writeDataFile(resultFile, ".data");
        }
        if (s.isSaveIVFile()) {
            this.sendEvent(ProgressEvent.ProgressEventType.START_WRITE_IV_PARTICLES_A_EVENT);
            writer.writeMessengersIntensityVolume(resultFile, "_" + this.settings.getParticlesAName().toLowerCase() + ".iv");
            this.sendEvent(ProgressEvent.ProgressEventType.START_WRITE_IV_PARTICLES_A_CUBOIDS_EVENT);
            writer.writeCuboidsMessengersIntensityVolume(resultFile, "_" + this.settings.getParticlesAName().toLowerCase() + "_cuboid" + ".iv");
            this.sendEvent(ProgressEvent.ProgressEventType.START_WRITE_IV_PARTICLES_B_EVENT);
            writer.writeMitosIntensityVolume(resultFile, "_" + this.settings.getParticlesBName().toLowerCase() + ".iv");
        }
        if (s.isSaveResultsFile()) {
            this.sendEvent(ProgressEvent.ProgressEventType.START_WRITE_RESULT_EVENT);
            writer.writeResult(resultFile, ".result");
        }
        if (s.isSaveFullResultsFile()) {
            this.sendEvent(ProgressEvent.ProgressEventType.START_WRITE_FULLRESULT_EVENT);
            writer.writeFullResult(resultFile, ".fullresult");
        }
        if (s.isSaveVisualizationFiles()) {
            if (s.isSaveParticleA3dFile()) {
                this.sendEvent(ProgressEvent.ProgressEventType.START_WRITE_RPLOT_PARTICLES_A_EVENT);
                new RGL(resultFile, "_" + this.settings.getParticlesAName().toLowerCase() + ".R").writeRPlots(result.getParticlesA(), "green", true);
            }
            if (s.isSaveParticleB3dFile()) {
                this.sendEvent(ProgressEvent.ProgressEventType.START_WRITE_RPLOT_PARTICLES_B_EVENT);
                new RGL(resultFile, "_" + this.settings.getParticlesBName().toLowerCase() + ".R").writeRPlots(result.getParticlesB(), "red", false);
            }
            if (s.isSaveParticlesACuboids3dFile()) {
                this.sendEvent(ProgressEvent.ProgressEventType.START_WRITE_RPLOT_PARTICLES_A_CUBOIDS_EVENT);
                new RGL(null, resultFile, "_" + this.settings.getParticlesAName().toLowerCase() + "_cuboid" + ".R").writeRPlots(result.getCuboidsParticlesA(), "green", true);
            }
            if (s.isSaveParticlesBCuboids3dFile()) {
                this.sendEvent(ProgressEvent.ProgressEventType.START_WRITE_RPLOT_PARTICLES_B_CUBOIDS_EVENT);
                new RGL(null, resultFile, "_" + this.settings.getParticlesBName().toLowerCase() + "_cuboid" + ".R").writeRPlots(result.getCuboidsParticlesB(), "red", false);
            }
            if (s.isSaveDistances3dFile()) {
                this.sendEvent(ProgressEvent.ProgressEventType.START_WRITE_RPLOT_DISTANCES_EVENT);
                new RGL(null, resultFile, "_distances.R").writeDistances(result.getMinDistances(), "cyan");
            }
        }
        this.endProcess(result);
        this.sendEvent(ProgressEvent.ProgressEventType.END_CELL_EVENT);
    }

    private static InputFiles getInputFile(Map<String, InputFiles> map, String filename, String prefix, String suffix) {
        if (filename.startsWith(prefix) && filename.endsWith(suffix)) {
            InputFiles iFile;
            String between = filename.substring(prefix.length(), filename.length() - suffix.length());
            if (map.containsKey(between)) {
                iFile = map.get(between);
            } else {
                iFile = new InputFiles();
                iFile.prefix = between;
                map.put(between, iFile);
            }
            return iFile;
        }
        return null;
    }

    private boolean processMultipleCells(File directory) throws IOException {
        if (directory == null || !directory.exists()) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        String prefixA = this.settings.getParticlesABatchPrefix();
        String prefixB = this.settings.getParticlesBBatchPrefix();
        HashMap<String, InputFiles> map = new HashMap<String, InputFiles>();
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String filename = files[i].getName();
            InputFiles iFile = CorsenCore.getInputFile(map, filename, prefixA, ".par");
            if (iFile != null) {
                iFile.inputParticlesAFile = files[i];
            }
            if ((iFile = CorsenCore.getInputFile(map, filename, prefixB, ".par")) == null) continue;
            iFile.inputParticlesBFile = files[i];
        }
        for (String key : new HashSet(map.keySet())) {
            InputFiles iFiles = (InputFiles)map.get(key);
            if (iFiles.inputParticlesBFile != null && iFiles.inputParticlesAFile != null) continue;
            map.remove(key);
        }
        int n = 0;
        int count = map.size();
        if (count == 0) {
            return false;
        }
        this.sendEvent(ProgressEvent.ProgressEventType.START_CELLS_EVENT, ProgressEvent.countPhase(this.settings));
        ArrayList sortedKeys = new ArrayList(map.keySet());
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            ++n;
            InputFiles iFiles = (InputFiles)map.get(key);
            if (iFiles.inputParticlesBFile == null || iFiles.inputParticlesAFile == null) continue;
            File parent = iFiles.inputParticlesBFile.getParentFile();
            this.doACell(iFiles.inputParticlesAFile, iFiles.inputParticlesBFile, new File(parent, iFiles.prefix), n, count);
        }
        long endTime = System.currentTimeMillis();
        logger.info("Calc " + n + " cells in " + (endTime - startTime) + " ms.");
        this.sendEvent(ProgressEvent.ProgressEventType.END_CELLS_SUCCESSFULL_EVENT, 1, 1);
        return true;
    }

    private void sendEvent(ProgressEvent.ProgressEventType type) {
        UpdateStatus us = this.getUpdateStatus();
        if (us == null) {
            return;
        }
        us.updateStatus(new ProgressEvent(type));
    }

    private void sendEvent(ProgressEvent.ProgressEventType type, int value1) {
        UpdateStatus us = this.getUpdateStatus();
        if (us == null) {
            return;
        }
        us.updateStatus(new ProgressEvent(type, value1));
    }

    private void sendEvent(ProgressEvent.ProgressEventType type, int value1, int value2) {
        UpdateStatus us = this.getUpdateStatus();
        if (us == null) {
            return;
        }
        us.updateStatus(new ProgressEvent(type, value1, value2));
    }

    private void sendEvent(ProgressEvent.ProgressEventType type, int value1, int value2, String value3, String value4, String value5) {
        UpdateStatus us = this.getUpdateStatus();
        if (us == null) {
            return;
        }
        us.updateStatus(new ProgressEvent(type, value1, value2, value3, value4, value5));
    }

    private void endProcess(CorsenResult result) {
        UpdateStatus us = this.getUpdateStatus();
        if (us == null) {
            return;
        }
        us.endProcess(result);
    }

    private void showMessage(String message) {
        UpdateStatus us = this.getUpdateStatus();
        if (us == null) {
            return;
        }
        us.showMessage(message);
    }

    private void showError(String message) {
        UpdateStatus us = this.getUpdateStatus();
        if (us == null) {
            return;
        }
        us.showError(message);
    }

    @Override
    public void run() {
        try {
            if (this.isMultipleFiles()) {
                if (this.processMultipleCells(this.getDirFiles())) {
                    this.showMessage("Particles distances computations successful.");
                } else {
                    this.showError("Directory not exists or no files to process");
                }
            } else {
                this.processACell(this.getParticlesAFile(), this.getParticlesBFile(), this.getResultFile());
                this.showMessage("Particles distances computations successful.");
            }
        }
        catch (IOException e) {
            this.showError(e.getMessage());
        }
        logger.info("End of the thread");
    }

    private static class InputFiles {
        File inputParticlesAFile;
        File inputParticlesBFile;
        String prefix;

        private InputFiles() {
        }
    }
}

