/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen;

import fr.ens.transcriptome.corsen.UpdateStatus;
import fr.ens.transcriptome.corsen.calc.CorsenHistoryResults;
import fr.ens.transcriptome.corsen.calc.CorsenResult;
import fr.ens.transcriptome.corsen.calc.Distance;
import fr.ens.transcriptome.corsen.calc.DistanceAnalyser;
import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.model.Particles3D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;

public class CorsenResultWriter {
    private CorsenResult result;
    private UpdateStatus updateStatus;

    public CorsenResult getResult() {
        return this.result;
    }

    public UpdateStatus getUpdateStatus() {
        return this.updateStatus;
    }

    public void setUpdateStatus(UpdateStatus updateStatus) {
        this.updateStatus = updateStatus;
    }

    public void writeDataFile(File file, String suffix) throws IOException {
        this.writeDataFile(CorsenResultWriter.createFileWithSuffix(file, suffix));
    }

    public void writeDataFile(File file) throws IOException {
        this.writeDataFile(new FileOutputStream(file));
    }

    public void writeDataFile(OutputStream os) throws IOException {
        CorsenResult r = this.getResult();
        OutputStreamWriter out = new OutputStreamWriter(os);
        out.write("#Internal id\tIntensity\tMin distance\tMax distance\tComment\n");
        Map<Particle3D, Distance> mins = r.getMinDistances();
        Map<Particle3D, Distance> maxs = r.getMaxDistances();
        for (Map.Entry<Particle3D, Distance> e : mins.entrySet()) {
            Particle3D p = e.getKey();
            Distance d = e.getValue();
            out.write(Integer.toString(p.getId()));
            out.write("\t");
            out.write(Long.toString(p.getIntensity()));
            out.write("\t");
            out.write(Float.toString(d.getDistance()));
            out.write("\t");
            out.write(Float.toString(maxs.get(p).getDistance()));
            out.write("\t");
            out.write(p.getComment());
            out.write("\n");
        }
        ((Writer)out).close();
    }

    public void writeCuboidsMessengersIntensityVolume(File file, String suffix) throws IOException {
        this.writeCuboidsMessengersIntensityVolume(CorsenResultWriter.createFileWithSuffix(file, suffix));
    }

    public void writeCuboidsMessengersIntensityVolume(File file) throws IOException {
        this.writeCuboidsMessengersIntensityVolume(new FileOutputStream(file));
    }

    public void writeCuboidsMessengersIntensityVolume(OutputStream os) throws IOException {
        CorsenResultWriter.writeIntensityVolume(os, this.getResult().getCuboidsParticlesA());
    }

    public void writeMitosIntensityVolume(File file, String suffix) throws IOException {
        this.writeMitosIntensityVolume(CorsenResultWriter.createFileWithSuffix(file, suffix));
    }

    public void writeMitosIntensityVolume(File file) throws IOException {
        this.writeMitosIntensityVolume(new FileOutputStream(file));
    }

    public void writeMitosIntensityVolume(OutputStream os) throws IOException {
        CorsenResultWriter.writeIntensityVolume(os, this.getResult().getParticlesB());
    }

    public void writeCuboidsMitosIntensityVolume(File file, String suffix) throws IOException {
        this.writeCuboidsMitosIntensityVolume(CorsenResultWriter.createFileWithSuffix(file, suffix));
    }

    public void writeCuboidsMitosIntensityVolume(File file) throws IOException {
        this.writeCuboidsMitosIntensityVolume(new FileOutputStream(file));
    }

    public void writeCuboidsMitosIntensityVolume(OutputStream os) throws IOException {
        CorsenResultWriter.writeIntensityVolume(os, this.getResult().getCuboidsParticlesB());
    }

    public void writeMessengersIntensityVolume(File file, String suffix) throws IOException {
        this.writeMessengersIntensityVolume(CorsenResultWriter.createFileWithSuffix(file, suffix));
    }

    public void writeMessengersIntensityVolume(File file) throws IOException {
        this.writeMessengersIntensityVolume(new FileOutputStream(file));
    }

    public void writeMessengersIntensityVolume(OutputStream os) throws IOException {
        CorsenResultWriter.writeIntensityVolume(os, this.getResult().getParticlesA());
    }

    public static void writeIntensityVolume(OutputStream os, Particles3D particles) throws IOException {
        if (particles == null || os == null) {
            return;
        }
        OutputStreamWriter out = new OutputStreamWriter(os);
        out.write("#Internal id\tArea\tVolume\tSphericity\tIntensity\tDensity\tMedian Circularity\n");
        for (Particle3D par : particles.getParticles()) {
            out.write(Integer.toString(par.getId()));
            out.write("\t");
            out.write(Double.toString(par.getArea()));
            out.write("\t");
            out.write(Double.toString(par.getVolume()));
            out.write("\t");
            out.write(Double.toString(par.getSphericity()));
            out.write("\t");
            out.write(Long.toString(par.getIntensity()));
            out.write("\t");
            out.write(Double.toString(par.getDensity()));
            out.write("\t");
            out.write(Double.toString(par.getMedianCircularity()));
            out.write("\n");
        }
        ((Writer)out).close();
    }

    public void writeFullResult(File file, String suffix) throws IOException {
        this.writeFullResult(CorsenResultWriter.createFileWithSuffix(file, suffix));
    }

    public void writeFullResult(File file) throws IOException {
        this.writeFullResult(new FileOutputStream(file));
    }

    public void writeFullResult(OutputStream os) throws IOException {
        this.writeFullResultFile(this.getResult().getParticlesA(), this.getResult().getParticlesA(), os);
    }

    private void writeFullResultFile(Particles3D messengersParticles, Particles3D mitosParticles, OutputStream os) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(os);
        out.write("messager");
        out.write("\t");
        out.write("volume");
        out.write("\t");
        out.write("intensity");
        out.write("\t");
        for (Particle3D mito : mitosParticles.getParticles()) {
            out.write("d(s,s)[");
            out.write(mito.getName());
            out.write("]");
            out.write("\t");
            out.write("d(c,s)[");
            out.write(mito.getName());
            out.write("]");
            out.write("\t");
            out.write("include[");
            out.write(mito.getName());
            out.write("]");
            out.write("\t");
        }
        out.write("min(s,s)\tmin(c,s)\n");
        for (Particle3D messenger : messengersParticles.getParticles()) {
            out.write(messenger.getName());
            out.write("\t");
            out.write("" + messenger.getVolume());
            out.write("\t");
            out.write("" + messenger.getIntensity());
            out.write("\t");
            double minss = Double.MAX_VALUE;
            double mincs = Double.MAX_VALUE;
            for (Particle3D mito : mitosParticles.getParticles()) {
                double dss = messenger.getSurfaceToSurfaceDistance(mito);
                double dcs = messenger.getBarycenterToSurfaceDistance(mito);
                if (dss < minss) {
                    minss = dss;
                }
                if (dcs < mincs) {
                    mincs = dcs;
                }
                out.write("" + dss);
                out.write("\t");
                out.write("" + dcs);
                out.write("\t");
                boolean include = messenger.intersect(mito);
                if (include) {
                    out.write("1");
                } else {
                    out.write("0");
                }
                out.write("\t");
            }
            out.write("" + minss);
            out.write("\t");
            out.write("" + mincs);
            out.write("\n");
        }
        ((Writer)out).close();
    }

    public void writeSummaryResultFile(OutputStream os) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(os);
        out.write("\tMinimum\t1st Quartile\tMedian\tMean\t3rd Quartile\tMaximum\n");
        DistanceAnalyser da = this.result.getMinAnalyser();
        out.write("Min distances");
        out.write(Double.toString(da.getMin()));
        out.write("\t");
        out.write(Double.toString(da.getFirstQuartile()));
        out.write("\t");
        out.write(Double.toString(da.getMedian()));
        out.write("\t");
        out.write(Double.toString(da.getMean()));
        out.write("\t");
        out.write(Double.toString(da.getThirdQuartile()));
        out.write("\t");
        out.write(Double.toString(da.getMax()));
        out.write("\n");
        da = this.result.getMaxAnalyser();
        out.write("Max distances");
        out.write(Double.toString(da.getMin()));
        out.write("\t");
        out.write(Double.toString(da.getFirstQuartile()));
        out.write("\t");
        out.write(Double.toString(da.getMedian()));
        out.write("\t");
        out.write(Double.toString(da.getMean()));
        out.write("\t");
        out.write(Double.toString(da.getThirdQuartile()));
        out.write("\t");
        out.write(Double.toString(da.getMax()));
        out.write("\n");
        ((Writer)out).close();
    }

    public void writeResult(File file, String suffix) throws IOException {
        this.writeResult(CorsenResultWriter.createFileWithSuffix(file, suffix));
    }

    public void writeResult(File file) throws IOException {
        this.writeResult(new FileOutputStream(file));
    }

    public void writeResult(FileOutputStream os) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(os);
        CorsenResult cr = this.getResult();
        if (cr == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("#Particle A\tParticle B\t");
        sb.append("Mins min\tMins first quartile\tMins median\tMins mean\tMins median\tMins third quartile\tMins max\t");
        sb.append("Mins min\tMaxs first quartile\tMaxs median\tMaxs mean\tMaxs median\tMaxs third quartile\tMaxs max\n");
        out.write(cr.getMessengersFile().getAbsolutePath());
        sb.append("\t");
        out.write(cr.getMitosFile().getAbsolutePath());
        sb.append("\t");
        DistanceAnalyser min = cr.getMinAnalyser();
        sb.append(min.getMin());
        sb.append("\t");
        sb.append(min.getFirstQuartile());
        sb.append("\t");
        sb.append(min.getMedian());
        sb.append("\t");
        sb.append(min.getMean());
        sb.append("\t");
        sb.append(min.getThirdQuartile());
        sb.append("\t");
        sb.append(min.getMax());
        sb.append("\t");
        DistanceAnalyser max = cr.getMinAnalyser();
        sb.append(max.getMin());
        sb.append("\t");
        sb.append(max.getFirstQuartile());
        sb.append("\t");
        sb.append(max.getMedian());
        sb.append("\t");
        sb.append(max.getMean());
        sb.append("\t");
        sb.append(max.getThirdQuartile());
        sb.append("\t");
        sb.append(max.getMax());
        sb.append("\n");
        out.write(sb.toString());
        ((Writer)out).close();
    }

    public static void writeHistoryResults(File file) throws IOException {
        CorsenResultWriter.writeHistoryResults(new FileOutputStream(file));
    }

    public static void writeHistoryResults(OutputStream os) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(os);
        out.write("#File A\tFile B\tMin distance\n");
        CorsenHistoryResults history = CorsenHistoryResults.getCorsenHistoryResults();
        int size = history.size();
        for (int i = 0; i < size; ++i) {
            CorsenHistoryResults.Entry e = history.get(i);
            out.write(e.getFileA().getAbsolutePath());
            out.write("\t");
            out.write(e.getFileB().getAbsolutePath());
            out.write("\t");
            out.write(Double.toString(e.getMedianMinDistance()));
            out.write("\n");
        }
        ((Writer)out).close();
    }

    public static File createFileWithSuffix(File file, String suffix) {
        if (file == null) {
            return null;
        }
        if (suffix == null) {
            return file;
        }
        return new File(file.getAbsolutePath() + suffix);
    }

    public CorsenResultWriter(CorsenResult result) {
        this.result = result;
    }
}

