/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen;

import fr.ens.transcriptome.corsen.calc.ParticleType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;

public final class Globals {
    private static Properties manifestProperties;
    private static final String MANIFEST_PROPERTIES_FILE = "/manifest.txt";
    public static final String APP_NAME = "Corsen";
    public static final String APP_NAME_LOWER_CASE;
    public static final String APP_VERSION;
    public static final String APP_BUILD_NUMBER;
    public static final String APP_BUILD_DATE;
    public static final Level LOG_LEVEL;
    public static final int THREAD_NUMBER_DEFAULT = -1;
    public static final boolean IS_JAR;
    public static final boolean DEBUG = false;
    public static final boolean DEBUG_HOME_DIR;
    public static final boolean SHOW_BUILT = false;
    public static final float Z_COEF_DEFAULT = 2.96f;
    public static final float CUBOID_SIZE_FACTOR = 2.1f;
    public static final float PIXEL_SIZE_DEFAULT = 1.0f;
    public static final boolean LIST_POINT_PACKED_MODE = false;
    private static final String WEBSITE_URL_DEFAULT = "http://transcriptome.ens.fr/corsen";
    public static final String WEBSITE_URL;
    public static final String HANDBOOK_URL;
    public static final String REPORT_BUG_URL = "http://code.google.com/p/corsen/issues/list";
    public static final GUI DEFAULT_GUI;
    public static final String EXTENSION_PARTICLES_FILE = ".par";
    public static final String EXTENSION_IV_FILE = ".iv";
    public static final String EXTENSION_RGL_FILE = ".R";
    public static final String EXTENSION_DISTANCES_FILE = "_distances.R";
    public static final String EXTENSION_DATA_FILE = ".data";
    public static final String EXTENSION_RESULT_FILE = ".result";
    public static final String EXTENSION_FULL_RESULT_FILE = ".fullresult";
    public static final String EXTENSION_POPULATION_FILE = ".pop";
    public static final String PARTICLES_A_DEFAULT_NAME = "Messengers";
    public static final ParticleType PARTICLES_A_DEFAULT_TYPE;
    public static final String PARTICLES_A_DEFAULT_BATCH_PREFIX = "messengers_";
    public static final String PARTICLES_B_DEFAULT_NAME = "Mitochondria";
    public static final ParticleType PARTICLES_B_DEFAULT_TYPE;
    public static final String PARTICLES_B_DEFAULT_BATCH_PREFIX = "mitos_";
    public static final String LICENCE_TXT = "This program is developed under the GNU General Public Licence version 2 or later and CeCILL.";
    private static final String COPYRIGHT_DATE = "2006-2010";
    public static final String ABOUT_TXT;
    public static final String ABOUT_HTML;

    private static String getVersion() {
        String s = Globals.getManifestProperty("Specification-Version");
        return s != null ? s : "UNKNOWN VERSION";
    }

    private static String getBuiltNumber() {
        String s = Globals.getManifestProperty("Implementation-Version");
        return s != null ? s : "UNKNOWN BUILT";
    }

    private static String getBuiltDate() {
        String unknown = "UNKNOWN DATE";
        String s = Globals.getManifestProperty("Built-Date");
        return s != null ? s : "UNKNOWN DATE";
    }

    private static String getWebSiteURL() {
        String s = Globals.getManifestProperty("url");
        return s != null ? s : WEBSITE_URL_DEFAULT;
    }

    private static String getManifestProperty(String propertyKey) {
        if (propertyKey == null) {
            return null;
        }
        Globals.readManifest();
        return manifestProperties.getProperty(propertyKey);
    }

    private static boolean isJar() {
        return manifestProperties.size() != 0;
    }

    public static String getWindowsTitle() {
        StringBuffer sb = new StringBuffer();
        sb.append(APP_NAME);
        sb.append(" ");
        sb.append(APP_VERSION);
        return sb.toString();
    }

    private static void readManifest() {
        if (manifestProperties != null) {
            return;
        }
        try {
            manifestProperties = new Properties();
            InputStream is = Globals.class.getResourceAsStream(MANIFEST_PROPERTIES_FILE);
            if (is == null) {
                return;
            }
            manifestProperties.load(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Globals() {
    }

    static {
        APP_NAME_LOWER_CASE = APP_NAME.toLowerCase();
        APP_VERSION = Globals.getVersion();
        APP_BUILD_NUMBER = Globals.getBuiltNumber();
        APP_BUILD_DATE = Globals.getBuiltDate();
        LOG_LEVEL = Level.INFO;
        IS_JAR = Globals.isJar();
        DEBUG_HOME_DIR = !IS_JAR;
        WEBSITE_URL = Globals.getWebSiteURL();
        HANDBOOK_URL = WEBSITE_URL + "/handbook.html";
        DEFAULT_GUI = GUI.QT;
        PARTICLES_A_DEFAULT_TYPE = ParticleType.DECOMPOSITION;
        PARTICLES_B_DEFAULT_TYPE = ParticleType.SURFACE;
        ABOUT_TXT = "Corsen version " + APP_VERSION + " (" + APP_BUILD_NUMBER + ")" + " is a tool dedicated to 3D distances measurements developed to access the" + " minimal distance between cellular objects.\n" + "\nThis version has been built on " + APP_BUILD_DATE + ".\n\n" + "Authors:\n" + "  Laurent Jourdren(*) <jourdren@biologie.ens.fr> Main developer, maintener.\n" + "  Mathilde Garcia(**) <magarcia@biologie.ens.fr> Project leader," + " R programming, ImageJ scripting, testing.\n\n" + "(*)  Plate-forme transcriptome, \u00c9cole Normale Sup\u00e9rieure\n" + "(**) Laboratoire de G\u00e9n\u00e9tique Mol\u00e9culaire, \u00c9cole Normale Sup\u00e9rieure\n\n" + "Copyright " + COPYRIGHT_DATE + " \u00c9cole Normale Sup\u00e9rieure.\n" + LICENCE_TXT + "\n";
        ABOUT_HTML = "<p><b>Corsen version " + APP_VERSION + " (" + APP_BUILD_NUMBER + ")" + "</b> is a tool dedicated to 3D distances measurements developed to access" + " the minimal distance between cellular objects.</p><br/>" + "<br/>This version has been built on " + APP_BUILD_DATE + ".<br/><br/>" + "<b>Authors</b>:" + "<ul><li><a href=\"mailto:jourdren@biologie.ens.fr?" + "subject=Corsen\">Laurent Jourdren</a><br/>" + "<a href=\"http://transcriptome.ens.fr\">" + "Microarray platform, \u00c9cole Normale Sup\u00e9rieure</a>" + "<br/>Main developer, maintener.</li><br/>" + "<li><a href=\"mailto:magarcia@biologie.ens.fr?" + "subject=Corsen\">Mathilde Garcia</a><br/>" + "<a href=\"http://www.biologie.ens.fr/lgmgml\">" + "Laboratoire de G\u00e9n\u00e9tique Mol\u00e9culaire, " + "\u00c9cole Normale Sup\u00e9rieure</a>" + "<br/>Project leader, R programming, ImageJ scripting, testing.</li></ul>" + "<p>Copyright " + COPYRIGHT_DATE + " \u00c9cole Normale Sup\u00e9rieure.<br/>" + LICENCE_TXT + "</p>";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GUI {
        CLI,
        SWING,
        QT,
        FAKE;

    }
}

