/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen;

import fr.ens.transcriptome.corsen.Settings;

public class ProgressEvent {
    public static final int PHASE_COUNT = ProgressEventType.START_WRITE_RPLOT_DISTANCES_EVENT.ordinal();
    public static final int INDEX_IN_PHASE_MAX = 1000;
    private ProgressEventType type;
    private int intValue1;
    private int intValue2;
    private String stringValue1;
    private String stringValue2;
    private String stringValue3;

    public ProgressEventType getType() {
        return this.type;
    }

    public int getIntValue1() {
        return this.intValue1;
    }

    public int getIntValue2() {
        return this.intValue2;
    }

    public String getStringValue1() {
        return this.stringValue1;
    }

    public String getStringValue2() {
        return this.stringValue2;
    }

    public String getStringValue3() {
        return this.stringValue3;
    }

    public static int countPhase(Settings settings) {
        if (settings == null) {
            return 0;
        }
        int count = PHASE_COUNT;
        if (!settings.isSaveVisualizationFiles()) {
            count -= 5;
        } else {
            if (!settings.isSaveParticleB3dFile()) {
                --count;
            }
            if (!settings.isSaveParticleA3dFile()) {
                --count;
            }
            if (!settings.isSaveParticlesACuboids3dFile()) {
                --count;
            }
            if (!settings.isSaveParticlesBCuboids3dFile()) {
                --count;
            }
            if (!settings.isSaveDistances3dFile()) {
                --count;
            }
        }
        if (!settings.isSaveDataFile()) {
            --count;
        }
        if (!settings.isSaveIVFile()) {
            count -= 3;
        }
        if (!settings.isSaveFullResultsFile()) {
            --count;
        }
        return count;
    }

    public ProgressEvent(ProgressEventType type) {
        this.type = type;
    }

    public ProgressEvent(ProgressEventType type, int intValue1) {
        this(type);
        this.intValue1 = intValue1;
    }

    public ProgressEvent(ProgressEventType type, int intValue1, int intValue2) {
        this(type, intValue1);
        this.intValue2 = intValue2;
    }

    public ProgressEvent(ProgressEventType type, int intValue1, int intValue2, String stringValue1, String stringValue2, String stringValue3) {
        this(type, intValue1, intValue2);
        this.stringValue1 = stringValue1;
        this.stringValue2 = stringValue2;
        this.stringValue3 = stringValue3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProgressEventType {
        START_READ_PARTICLES_A_FILE_EVENT("Read particles A PAR file"),
        START_READ_PARTICLES_B_FILE_EVENT("Read particles B PAR file"),
        START_CHANGE_PARTICLES_A_COORDINATES_EVENT("Transform particles A coordinates"),
        START_CHANGE_PARTICLES_B_COORDINATES_EVENT("Transform particles B coordinates"),
        START_FILTER_PARTICLES_A_EVENT("Filter particles A"),
        START_FILTER_PARTICLES_B_EVENT("Filter particles B"),
        START_CALC_PARTICLES_A_CUBOIDS_EVENT("Calc particles A cuboids"),
        START_CALC_PARTICLES_B_CUBOIDS_EVENT("Calc particles B cuboids"),
        START_CALC_MIN_DISTANCES_EVENT("Calc distances"),
        START_DISTANCES_ANALYSIS("Distances analysis"),
        START_WRITE_DATA_EVENT("Write results data file for R"),
        START_WRITE_IV_PARTICLES_A_EVENT("Write particles A intensities and volumes"),
        START_WRITE_IV_PARTICLES_B_EVENT("Write particles B intensities and volumes"),
        START_WRITE_IV_PARTICLES_A_CUBOIDS_EVENT("Write particles A cuboids intensities and volumes"),
        START_WRITE_RESULT_EVENT("Write results"),
        START_WRITE_FULLRESULT_EVENT("Write full results"),
        START_WRITE_RPLOT_PARTICLES_A_EVENT("Write particles B R plot file"),
        START_WRITE_RPLOT_PARTICLES_B_EVENT("Write particles A R plot file"),
        START_WRITE_RPLOT_PARTICLES_A_CUBOIDS_EVENT("Write particles A cuboids R plot file"),
        START_WRITE_RPLOT_PARTICLES_B_CUBOIDS_EVENT("Write particles B cuboids R plot file"),
        START_WRITE_RPLOT_DISTANCES_EVENT("Write distances R plot file"),
        PROGRESS_CALC_PARTICLES_A_CUBOIDS_EVENT(""),
        PROGRESS_CALC_PARTICLES_B_CUBOIDS_EVENT(""),
        PROGRESS_CALC_DISTANCES_EVENT(""),
        START_CELLS_EVENT(""),
        START_CELL_EVENT(""),
        END_CELLS_SUCCESSFULL_EVENT(""),
        END_CELL_EVENT(""),
        END_ERROR_EVENT("");

        private String description;

        public String toString() {
            return this.description;
        }

        private ProgressEventType(String description) {
            this.description = description;
        }
    }
}

