/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen;

import fr.ens.transcriptome.corsen.CorsenResultWriter;
import fr.ens.transcriptome.corsen.Globals;
import fr.ens.transcriptome.corsen.calc.Distance;
import fr.ens.transcriptome.corsen.model.Particle2D;
import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.model.Particles3D;
import fr.ens.transcriptome.corsen.model.Point2D;
import fr.ens.transcriptome.corsen.model.Point3D;
import fr.ens.transcriptome.corsen.model.SimplePoint3DImpl;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RGL {
    private Writer out;
    private String unit = "pixel";
    private static final String COLOR_CYAN = "cyan";
    private static final String COLOR_GREEN = "green";
    private static final String COLOR_RED = "red";
    private static final String COLOR_WHITE = "white";
    private static final String COLOR_BLACK = "black";

    public Writer getWriter() {
        return this.out;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setWriter(Writer writer) {
        this.out = writer;
    }

    public void setFile(File file) throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(file);
        this.setWriter(new OutputStreamWriter(fos));
    }

    public void setFile(String file) throws FileNotFoundException {
        this.setFile(new File(file));
    }

    public void setUnit(String unit) {
        if (unit != null) {
            this.unit = unit;
        }
    }

    private void writeHeader() throws IOException {
        Writer out = this.out;
        if (out == null) {
            throw new IOException("The Writer is null");
        }
        out.write("# Generated by ");
        out.write("Corsen");
        out.write(" version ");
        out.write(Globals.APP_VERSION);
        out.write("\n\n# Load rgl\n");
        out.write("if (length( grep(\"package:rgl\",search()) )==0) { library(rgl) }\n\n");
        out.write("rgl.bg(color=c(\"black\"), fogtype=\"linear\" )\n");
        this.writeLegend(this.getUnit());
    }

    public void writeLegend(String unit) throws IOException {
        SimplePoint3DImpl o = new SimplePoint3DImpl(0.0f, 0.0f, 0.0f);
        SimplePoint3DImpl x = new SimplePoint3DImpl(10.0f, 0.0f, 0.0f);
        SimplePoint3DImpl y = new SimplePoint3DImpl(0.0f, 10.0f, 0.0f);
        SimplePoint3DImpl z = new SimplePoint3DImpl(0.0f, 0.0f, 10.0f);
        this.writeLine(o, x, COLOR_WHITE);
        this.writeLine(o, y, COLOR_WHITE);
        this.writeLine(o, z, COLOR_WHITE);
        String text = "10 " + unit;
        this.out.write("text3d(x=-1,y=-1,z=-1,text=\"" + text + "\",color=\"" + COLOR_WHITE + "\")\n");
    }

    public void writeDistances(Map<Particle3D, Distance> distances, String color) throws IOException {
        if (distances != null) {
            Iterator<Particle3D> it = distances.keySet().iterator();
            while (it.hasNext()) {
                Distance d = distances.get(it.next());
                this.writeLine(d.getPointA(), d.getPointB(), color);
            }
        }
        this.close();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void writeRPlots(Particles3D particles, String color, boolean plotCenter) throws IOException {
        this.writeRPlots(particles.getParticles(), color, plotCenter, particles.getPixelWidth());
        this.close();
    }

    public void writeRPlots(List<Particle3D> particles, String color, boolean plotCenter, float minDistanceBetweenTwoPoints) throws IOException {
        if (particles == null) {
            return;
        }
        Writer out = this.out;
        Random random = new Random(System.currentTimeMillis());
        for (Particle3D par : particles) {
            out.write("#\n# Particle #");
            out.write("" + par.getId());
            out.write(" (");
            out.write(par.getName());
            out.write(")\n#\n\n");
            this.innerPointstoRData(par);
            float size = (float)((double)minDistanceBetweenTwoPoints * 1.0);
            out.write("\nplotColor <- \"");
            out.write(color);
            out.write("\"\n");
            out.write("\nif (exists(\"corsen.unicolor\") && corsen.unicolor==F ) {\nplotColor <- \"#");
            Color c = new Color(random.nextInt(255), random.nextInt(255), random.nextInt(255));
            out.write(Integer.toHexString(c.getRGB()));
            out.write("\"\n}\n");
            out.write("\nif ( exists(\"corsen.shift\") && corsen.shift>0 ) {\n");
            out.write("print(x)\n");
            out.write("x <- x + corsen.shift\n");
            out.write("y <- y + corsen.shift\n");
            out.write("z <- z + corsen.shift\n");
            out.write("}\n");
            out.write("\nif (!exists(\"corsen.sizepoints\")) {\n corsen.sizepoints <- ");
            out.write("" + size);
            out.write("\n}\n");
            out.write("\nif (!exists(\"corsen.points3d\") || ( exists(\"corsen.points3d\") && corsen.points3d==T )) {\n");
            String plotColor = "plotColor";
            this.innerPointstoRPlot(false, "corsen.sizepoints", plotColor, true);
            out.write("} else {\n");
            this.innerPointstoRPlot(true, "corsen.sizepoints", plotColor, true);
            out.write("}\n");
            out.write("\nif (!exists(\"corsen.surfaces3d\") || ( exists(\"corsen.surfaces3d\") && corsen.surfaces3d==T )) {\n");
            this.surfacePointstoR(par, 1.0f, plotColor, true);
            out.write("}\n\n");
            if (plotCenter) {
                out.write("if (exists(\"corsen.centers\") && corsen.centers==T) {\n");
                this.writePoint(par.getSurfacePoints().getCenter(), 5.0f, "darkblue");
                out.write("}\n\n");
                out.write("if (!exists(\"corsen.barycenters\") || (exists(\"corsen.barycenters\") && corsen.barycenters==T)) {\n");
                this.writePoint(par.getInnerPoints().getBarycenter(), 5.0f, "blue");
                out.write("}\n");
            }
            out.write("\n");
        }
    }

    public void innerPointstoRPlot(boolean sphere, String size, String colorName, boolean colorNameVariable) throws IOException {
        Writer out = this.out;
        if (sphere) {
            out.write("rgl.spheres(x, y, z, r=" + size);
        } else {
            out.write("points3d(x, y, z, size=" + size);
        }
        if (colorName != null) {
            out.write(",color=");
            if (!colorNameVariable) {
                out.write("\"");
            }
            out.write(colorName);
            if (!colorNameVariable) {
                out.write("\"");
            }
        }
        out.write(")\n");
    }

    public String surfacePointLinestoR(Particle3D par, float size, String colorName) {
        Point3D p;
        int i;
        int n = par.surfacePointsCount();
        if (n == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("x <- c(");
        for (i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            p = par.getSurfacePoint(i);
            sb.append(p.getX());
        }
        sb.append(")\ny <- c(");
        for (i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            p = par.getSurfacePoint(i);
            sb.append(p.getY());
        }
        sb.append(")\nz <- c(");
        for (i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            p = par.getSurfacePoint(i);
            sb.append(p.getZ());
        }
        sb.append(")\n");
        sb.append("points3d(x, y, z, size=");
        sb.append(size);
        if (colorName != null) {
            sb.append(",color=\"");
            sb.append(colorName);
            sb.append("\"");
        }
        sb.append(")\n");
        return sb.toString();
    }

    public void surfacePointstoR(Particle3D par, float size, String colorName, boolean colorNameVariable) throws IOException {
        Writer out = this.out;
        if (par.surfacePointsCount() == 0) {
            return;
        }
        Map<Float, Particle2D> slices = Particle3D.getSurfacePointSlices(par);
        Object[] keys = slices.keySet().toArray();
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            Point2D p;
            int j;
            Float zF = (Float)keys[i];
            Particle2D par2d = slices.get(zF);
            int n = par2d.surfacePointsCount();
            if (par2d.surfacePointsCount() == 0) continue;
            out.write("x <- c(");
            for (j = 0; j < n; ++j) {
                if (j > 0) {
                    out.write(",");
                }
                p = par2d.getSurfacePoint(j);
                out.write("" + p.getX());
            }
            out.write(")\ny <- c(");
            for (j = 0; j < n; ++j) {
                if (j > 0) {
                    out.write(",");
                }
                p = par2d.getSurfacePoint(j);
                out.write("" + p.getY());
            }
            out.write(")\nz <- c(");
            for (j = 0; j < n + 1; ++j) {
                if (j > 0) {
                    out.write(",");
                }
                out.write(zF.toString());
            }
            out.write(")\n");
            out.write("lines3d(x, y, z, size=" + size);
            if (colorName != null) {
                out.write(",color=");
                if (!colorNameVariable) {
                    out.write(",color=");
                }
                out.write(colorName);
                if (!colorNameVariable) {
                    out.write("\"");
                }
            }
            out.write(")\n");
        }
    }

    public void innerPointstoRData(Particle3D par) throws IOException {
        Point3D p;
        int i;
        if (this.out == null) {
            return;
        }
        int n = par.innerPointsCount();
        if (n == 0) {
            return;
        }
        this.out.write("x <- c(");
        for (i = 0; i < n; ++i) {
            if (i > 0) {
                this.out.write(",");
            }
            p = par.getInnerPoint(i);
            this.out.write("" + p.getX());
        }
        this.out.write(")\ny <- c(");
        for (i = 0; i < n; ++i) {
            if (i > 0) {
                this.out.write(",");
            }
            p = par.getInnerPoint(i);
            this.out.write("" + p.getY());
        }
        this.out.write(")\nz <- c(");
        for (i = 0; i < n; ++i) {
            if (i > 0) {
                this.out.write(",");
            }
            p = par.getInnerPoint(i);
            this.out.write("" + p.getZ());
        }
        this.out.write(")\n");
    }

    public void writeLine(Point3D p1, Point3D p2, String color) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("x <- c(");
        sb.append(p1.getX());
        sb.append(",");
        sb.append(p2.getX());
        sb.append(")\n");
        sb.append("y <- c(");
        sb.append(p1.getY());
        sb.append(",");
        sb.append(p2.getY());
        sb.append(")\n");
        sb.append("z <- c(");
        sb.append(p1.getZ());
        sb.append(",");
        sb.append(p2.getZ());
        sb.append(")\n");
        sb.append("lines3d(x, y, z, size=3.0,color=\"");
        sb.append(color);
        sb.append("\")\n");
        this.out.write(sb.toString());
    }

    public void writePoint(Point3D p, float size, String colorName) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("x <- c(");
        sb.append(p.getX());
        sb.append(")\ny <- c(");
        sb.append(p.getY());
        sb.append(")\nz <- c(");
        sb.append(p.getZ());
        sb.append(")\n");
        sb.append("points3d(x, y, z, size=");
        sb.append(size);
        if (colorName != null) {
            sb.append(",color=\"");
            sb.append(colorName);
            sb.append("\"");
        }
        sb.append(")\n");
        this.out.write(sb.toString());
    }

    public RGL(String unit, File file) throws IOException {
        this.setFile(file);
        this.setUnit(unit);
        this.writeHeader();
    }

    public RGL(File file, String suffix) throws IOException {
        this(null, CorsenResultWriter.createFileWithSuffix(file, suffix));
    }

    public RGL(String unit, File file, String suffix) throws IOException {
        this(unit, CorsenResultWriter.createFileWithSuffix(file, suffix));
    }
}

