/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen;

import fr.ens.transcriptome.corsen.Globals;
import fr.ens.transcriptome.corsen.calc.CorsenHistoryResults;
import fr.ens.transcriptome.corsen.calc.JavascriptDistancesFilter;
import fr.ens.transcriptome.corsen.calc.ParticleType;
import fr.ens.transcriptome.corsen.model.JavascriptParticles3DFilter;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;

public final class Settings {
    private static Logger logger = Logger.getLogger("Corsen");
    private static final String ZFACTOR_KEY = "main.zFactor";
    private static final String FACTOR_KEY = "main.factor";
    private static final String UNIT_KEY = "main.unit";
    private static final String AUTO_CUBOID_SIZE_KEY = "main.autoCuboidSize";
    private static final String CUBOID_SIZE_KEY = "main.cuboidSize";
    private static final String PARTICLES_A_NAME_KEY = "particles.a.name";
    private static final String PARTICLES_A_TYPE_KEY = "particles.a.type";
    private static final String PARTICLES_A_BATCH_PREFIX_KEY = "particles.a.batch.prefix";
    private static final String PARTICLES_A_PROPERTIES_KEY = "particles.a.properties";
    private static final String PARTICLES_A_FILTER_KEY = "particles.a.filter";
    private static final String PARTICLES_B_NAME_KEY = "particles.b.name";
    private static final String PARTICLES_B_TYPE_KEY = "particles.b.type";
    private static final String PARTICLES_B_BATCH_PREFIX_KEY = "particles.b.batch.prefix";
    private static final String PARTICLES_B_PROPERTIES_KEY = "particles.b.properties";
    private static final String PARTICLES_B_FILTER_KEY = "particles.b.filter";
    private static final String THREAD_NUMBER_KEY = "threads.number";
    private static final String SAVE_DATA_FILE_KEY = "save.dataFile";
    private static final String SAVE_IV_FILE_SAVED_KEY = "save.IVFile";
    private static final String SAVE_3DFILES_KEY = "save.3dFiles";
    private static final String SAVE_PARTICLES_A_3DFILES_KEY = "save.3dFiles.particles.a";
    private static final String SAVE_PARTICLES_A_CUBOIDS_3DFILES_KEY = "save.3dFiles.particles.a";
    private static final String SAVE_PARTICLES_B_3DFILES_KEY = "save.3dFiles.particles.b";
    private static final String SAVE_PARTICLES_B_CUBOIDS_3DFILES_KEY = "save.3dFiles.particles.b";
    private static final String SAVE_DISTANCES_3DFILES_KEY = "save.3dFiles.distances";
    private static final String SAVE_RESULTS_KEY = "save.results";
    private static final String SAVE_FULL_RESULTS_KEY = "save.fullResults";
    private static final String VISUALIZATION_PARTICLES_A_TRANSPARENCY_KEY = "visualization.particlesATransparency";
    private static final String VISUALIZATION_PARTICLES_B_TRANSPARENCY_KEY = "visualization.particlesBTransparency";
    private static final String VISUALIZATION_SHOW_NEGATIVE_DISTANCES_KEY = "visualization.showNegativeDistances";
    private static final String VISUALIZATION_SHOW_PARTICLES_A_DIFFERENT_COLORS_KEY = "visualization.showParticleADifferentColors";
    private static final String VISUALIZATION_SHOW_PARTICLES_B_DIFFERENT_COLORS_KEY = "visualization.showParticleBDifferentColors";
    private static final String VISUALIZATION_COLOR_PARTICLE_A_KEY = "visualization.color.particle.a";
    private static final String VISUALIZATION_COLOR_PARTICLE_B_KEY = "visualization.color.particle.b";
    private static final String VISUALIZATION_COLOR_BARYCENTERS_KEY = "visualization.color.barycenters";
    private static final String VISUALIZATION_COLOR_DISTANCES_KEY = "visualization.color.distances";
    private static final String VISUALIZATION_COLOR_BACKGROUND_KEY = "visualization.color.background";
    private static final String VISUALIZATION_COLOR_LEGEND_KEY = "visualization.color.legend";
    private static final String VISUALIZATION_FILTER_PARTICLES_A_ENABLE_KEY = "visualization.filter.a.enable";
    private static final String VISUALIZATION_FILTER_PARTICLES_A_EXPRESSION_KEY = "visualization.filter.a.expression";
    private static final String VISUALIZATION_FILTER_PARTICLES_B_ENABLE_KEY = "visualization.filter.b.enable";
    private static final String VISUALIZATION_FILTER_PARTICLES_B_EXPRESSION_KEY = "visualization.filter.b.expression";
    private static final String VISUALIZATION_FILTER_DISTANCES_ENABLE_KEY = "visualization.filter.distances.enable";
    private static final String VISUALIZATION_FILTER_DISTANCES_EXPRESSION_KEY = "visualization.filter.distances.expression";
    private static final String VISUALIZATION_FILTER_SHOW_DISTANCES_SHOWED_PARTICLES_KEY = "visualization.filter.show.distances";
    private static final String HISTOGRAM_RESULTS_NB_CLASSES_KEY = "histogram.results.classes";
    private static final String HISTOGRAM_HISTORY_NB_CLASSES_KEY = "histogram.history.classes";
    private static final String CUSTOM_HISTORY_EXPRESSION_KEY = "history.custom.expression";
    private static final String CLEAR_HISTORY_WHEN_NEW_CALC_KEY = "main.clear.history.new.calc";
    private Properties properties = new Properties();

    public boolean isSaveIVFile() {
        String value = this.properties.getProperty(SAVE_IV_FILE_SAVED_KEY, "true");
        return Boolean.valueOf(value.trim());
    }

    public boolean isSaveResultsFile() {
        String value = this.properties.getProperty(SAVE_RESULTS_KEY, "false");
        return Boolean.valueOf(value.trim());
    }

    public boolean isSaveFullResultsFile() {
        String value = this.properties.getProperty(SAVE_FULL_RESULTS_KEY, "false");
        return Boolean.valueOf(value.trim());
    }

    public boolean isAutoCuboidSize() {
        String value = this.properties.getProperty(AUTO_CUBOID_SIZE_KEY, "true");
        return Boolean.valueOf(value.trim());
    }

    public boolean isSaveDataFile() {
        String value = this.properties.getProperty(SAVE_DATA_FILE_KEY, "true");
        return Boolean.valueOf(value.trim());
    }

    public boolean isSaveDistances3dFile() {
        String value = this.properties.getProperty(SAVE_DISTANCES_3DFILES_KEY, "true");
        return Boolean.valueOf(value.trim());
    }

    public float getFactor() {
        String value = this.properties.getProperty(FACTOR_KEY, "1.0");
        return Float.parseFloat(value.trim());
    }

    public boolean isSaveParticleA3dFile() {
        String value = this.properties.getProperty("save.3dFiles.particles.a", "true");
        return Boolean.valueOf(value);
    }

    public boolean isSaveParticlesACuboids3dFile() {
        String value = this.properties.getProperty("save.3dFiles.particles.a", "false");
        return Boolean.valueOf(value.trim());
    }

    public boolean isSaveParticleB3dFile() {
        String value = this.properties.getProperty("save.3dFiles.particles.b", "true");
        return Boolean.valueOf(value.trim());
    }

    public boolean isSaveParticlesBCuboids3dFile() {
        String value = this.properties.getProperty("save.3dFiles.particles.b", "false");
        return Boolean.valueOf(value.trim());
    }

    public String getUnit() {
        return this.properties.getProperty(UNIT_KEY);
    }

    public boolean isSaveVisualizationFiles() {
        String value = this.properties.getProperty(SAVE_3DFILES_KEY, "false");
        return Boolean.valueOf(value.trim());
    }

    public float getZFactor() {
        String value = this.properties.getProperty(ZFACTOR_KEY, "1.0");
        return Float.parseFloat(value.trim());
    }

    public float getCuboidSize() {
        String value = this.properties.getProperty(CUBOID_SIZE_KEY, "1.0");
        return Float.parseFloat(value.trim());
    }

    public int getParticlesATransparency() {
        String value = this.properties.getProperty(VISUALIZATION_PARTICLES_A_TRANSPARENCY_KEY, "0");
        return Integer.parseInt(value);
    }

    public int getParticlesBTransparency() {
        String value = this.properties.getProperty(VISUALIZATION_PARTICLES_B_TRANSPARENCY_KEY, "0");
        return Integer.parseInt(value);
    }

    public boolean isVisualizationShowNegativeDistances() {
        String value = this.properties.getProperty(VISUALIZATION_SHOW_NEGATIVE_DISTANCES_KEY, "false");
        return Boolean.valueOf(value.trim());
    }

    public Color getColorParticlesA() {
        String value = this.properties.getProperty(VISUALIZATION_COLOR_PARTICLE_A_KEY, this.colorToString(Color.GREEN));
        return this.colorFromString(value);
    }

    public Color getColorParticlesB() {
        String value = this.properties.getProperty(VISUALIZATION_COLOR_PARTICLE_B_KEY, this.colorToString(Color.RED));
        return this.colorFromString(value);
    }

    public Color getColorBaryCenters() {
        String value = this.properties.getProperty(VISUALIZATION_COLOR_BARYCENTERS_KEY, this.colorToString(Color.BLUE));
        return this.colorFromString(value);
    }

    public Color getColorDistances() {
        String value = this.properties.getProperty(VISUALIZATION_COLOR_DISTANCES_KEY, this.colorToString(Color.YELLOW));
        return this.colorFromString(value);
    }

    public Color getColorBackground() {
        String value = this.properties.getProperty(VISUALIZATION_COLOR_BACKGROUND_KEY, this.colorToString(Color.BLACK));
        return this.colorFromString(value);
    }

    public Color getColorLegend() {
        String value = this.properties.getProperty(VISUALIZATION_COLOR_LEGEND_KEY, this.colorToString(Color.WHITE));
        return this.colorFromString(value);
    }

    public String getParticlesAName() {
        return this.properties.getProperty(PARTICLES_A_NAME_KEY, "Messengers");
    }

    public ParticleType getParticlesAType() {
        String val = this.properties.getProperty(PARTICLES_A_TYPE_KEY, ParticleType.DECOMPOSITION.toString());
        return ParticleType.getParticleType(val);
    }

    public String getParticlesABatchPrefix() {
        return this.properties.getProperty(PARTICLES_A_BATCH_PREFIX_KEY, "messengers_");
    }

    public String getParticlesAFilterExpression() {
        return this.properties.getProperty(PARTICLES_A_FILTER_KEY, "");
    }

    public Properties getParticlesAProperties() {
        Properties result = new Properties();
        for (String string : this.properties.keySet()) {
            if (!string.startsWith(PARTICLES_A_PROPERTIES_KEY)) continue;
            result.setProperty(string.substring(PARTICLES_A_PROPERTIES_KEY.length(), string.length()), this.properties.getProperty(string));
        }
        return result;
    }

    public String getParticlesBName() {
        return this.properties.getProperty(PARTICLES_B_NAME_KEY, "Mitochondria");
    }

    public ParticleType getParticlesBType() {
        return ParticleType.getParticleType(this.properties.getProperty(PARTICLES_B_TYPE_KEY, ParticleType.SURFACE.toString()));
    }

    public String getParticlesBBatchPrefix() {
        return this.properties.getProperty(PARTICLES_B_BATCH_PREFIX_KEY, "mitos_");
    }

    public String getParticlesBFilterExpression() {
        return this.properties.getProperty(PARTICLES_B_FILTER_KEY, "");
    }

    public Properties getParticlesBProperties() {
        Properties result = new Properties();
        for (String string : this.properties.keySet()) {
            if (!string.startsWith(PARTICLES_B_PROPERTIES_KEY)) continue;
            result.setProperty(string.substring(PARTICLES_B_PROPERTIES_KEY.length(), string.length()), this.properties.getProperty(string));
        }
        return result;
    }

    public int getThreadNumber() {
        String value = this.properties.getProperty(THREAD_NUMBER_KEY, "-1");
        return Integer.parseInt(value.trim());
    }

    public boolean isVisualisationParticlesAInDifferentsColor() {
        String value = this.properties.getProperty(VISUALIZATION_SHOW_PARTICLES_A_DIFFERENT_COLORS_KEY, "false");
        return Boolean.valueOf(value.trim());
    }

    public boolean isVisualisationParticlesBInDifferentsColor() {
        String value = this.properties.getProperty(VISUALIZATION_SHOW_PARTICLES_B_DIFFERENT_COLORS_KEY, "false");
        return Boolean.valueOf(value.trim());
    }

    public int getHistogramResultsNumberClasses() {
        String value = this.properties.getProperty(HISTOGRAM_RESULTS_NB_CLASSES_KEY, "25");
        return Integer.valueOf(value.trim());
    }

    public int getHistogramHistoryNumberClasses() {
        String value = this.properties.getProperty(HISTOGRAM_HISTORY_NB_CLASSES_KEY, "25");
        return Integer.valueOf(value.trim());
    }

    public String getCustomHistoryExpression() {
        return this.properties.getProperty(CUSTOM_HISTORY_EXPRESSION_KEY, "");
    }

    public boolean isClearHistoryWhenLaunchingNewCalc() {
        String value = this.properties.getProperty(CLEAR_HISTORY_WHEN_NEW_CALC_KEY, "false");
        return Boolean.valueOf(value);
    }

    public boolean isParticlesAViewFilterEnabled() {
        String value = this.properties.getProperty(VISUALIZATION_FILTER_PARTICLES_A_ENABLE_KEY, "false");
        return Boolean.valueOf(value);
    }

    public String getParticlesAViewFilterExpression() {
        return this.properties.getProperty(VISUALIZATION_FILTER_PARTICLES_A_EXPRESSION_KEY, "");
    }

    public boolean isParticlesBViewFilterEnabled() {
        String value = this.properties.getProperty(VISUALIZATION_FILTER_PARTICLES_B_ENABLE_KEY, "false");
        return Boolean.valueOf(value);
    }

    public String getParticlesBViewFilterExpression() {
        return this.properties.getProperty(VISUALIZATION_FILTER_PARTICLES_B_EXPRESSION_KEY, "");
    }

    public boolean isDistancesViewFilterEnabled() {
        String value = this.properties.getProperty(VISUALIZATION_FILTER_DISTANCES_ENABLE_KEY, "false");
        return Boolean.valueOf(value);
    }

    public String getDistancesViewFilterExpression() {
        return this.properties.getProperty(VISUALIZATION_FILTER_DISTANCES_EXPRESSION_KEY, "");
    }

    public boolean isFilterShowDistanceShowedParticles() {
        String value = this.properties.getProperty(VISUALIZATION_FILTER_SHOW_DISTANCES_SHOWED_PARTICLES_KEY, "false");
        return Boolean.valueOf(value);
    }

    public void setSaveIVFile(boolean saveIVFile) {
        this.properties.setProperty(SAVE_IV_FILE_SAVED_KEY, Boolean.toString(saveIVFile));
    }

    public void setAutoCuboidSize(boolean autoCuboidSize) {
        this.properties.setProperty(AUTO_CUBOID_SIZE_KEY, Boolean.toString(autoCuboidSize));
    }

    public void setSaveDataFile(boolean dataFile) {
        this.properties.setProperty(SAVE_DATA_FILE_KEY, Boolean.toString(dataFile));
    }

    public void setSaveDistances3dFile(boolean distances3dFile) {
        this.properties.setProperty(SAVE_DISTANCES_3DFILES_KEY, Boolean.toString(distances3dFile));
    }

    public void setFactor(String factor) {
        if (factor == null) {
            return;
        }
        try {
            this.setFactor(Float.parseFloat(factor.trim()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setFactor(float factor) {
        this.properties.setProperty(FACTOR_KEY, Float.toString(factor));
    }

    public void setSaveParticlesA3dFile(boolean particlesA3dFile) {
        this.properties.setProperty("save.3dFiles.particles.a", Boolean.toString(particlesA3dFile));
    }

    public void setSaveParticlesACuboids3dFile(boolean particlesACuboids3dFile) {
        this.properties.setProperty("save.3dFiles.particles.a", Boolean.toString(particlesACuboids3dFile));
    }

    public void setSaveParticlesB3dFile(boolean partcilesB3dFile) {
        this.properties.setProperty("save.3dFiles.particles.b", Boolean.toString(partcilesB3dFile));
    }

    public void setSaveParticlesBCuboids3dFile(boolean partcilesBCuboids3dFile) {
        this.properties.setProperty("save.3dFiles.particles.b", Boolean.toString(partcilesBCuboids3dFile));
    }

    public void setUnit(String unit) {
        this.properties.setProperty(UNIT_KEY, unit);
    }

    public void setSaveVisualizationFiles(boolean visualizationFiles) {
        this.properties.setProperty(SAVE_3DFILES_KEY, Boolean.toString(visualizationFiles));
    }

    public void setZFactor(String zFactor) {
        if (zFactor == null) {
            return;
        }
        try {
            this.setZFactor(Float.parseFloat(zFactor.trim()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setZFactor(float zFactor) {
        this.properties.setProperty(ZFACTOR_KEY, Float.toString(zFactor));
    }

    public void setCuboidSize(float cuboidSize) {
        this.properties.setProperty(CUBOID_SIZE_KEY, Float.toString(cuboidSize));
    }

    public void setSaveResultFile(boolean saveResultFile) {
        this.properties.setProperty(SAVE_RESULTS_KEY, Boolean.toString(saveResultFile));
    }

    public void setSaveFullResultFile(boolean saveFullResultFile) {
        this.properties.setProperty(SAVE_FULL_RESULTS_KEY, Boolean.toString(saveFullResultFile));
    }

    public void setParticlesATransparency(int transparency) {
        this.properties.setProperty(VISUALIZATION_PARTICLES_A_TRANSPARENCY_KEY, Integer.toString(transparency));
    }

    public void setParticlesBTransparency(int transparency) {
        this.properties.setProperty(VISUALIZATION_PARTICLES_B_TRANSPARENCY_KEY, Integer.toString(transparency));
    }

    public void setVisualizationShowNegativeDistances(boolean value) {
        this.properties.setProperty(VISUALIZATION_SHOW_NEGATIVE_DISTANCES_KEY, Boolean.toString(value));
    }

    public void setColorParticlesA(Color color) {
        this.properties.setProperty(VISUALIZATION_COLOR_PARTICLE_A_KEY, this.colorToString(color));
    }

    public void setColorParticlesB(Color color) {
        this.properties.setProperty(VISUALIZATION_COLOR_PARTICLE_B_KEY, this.colorToString(color));
    }

    public void setColorBaryCenters(Color color) {
        this.properties.setProperty(VISUALIZATION_COLOR_BARYCENTERS_KEY, this.colorToString(color));
    }

    public void setColorDistances(Color color) {
        this.properties.setProperty(VISUALIZATION_COLOR_DISTANCES_KEY, this.colorToString(color));
    }

    public void setColorBackground(Color color) {
        this.properties.setProperty(VISUALIZATION_COLOR_BACKGROUND_KEY, this.colorToString(color));
    }

    public void setColorLegend(Color color) {
        this.properties.setProperty(VISUALIZATION_COLOR_LEGEND_KEY, this.colorToString(color));
    }

    public void setParticlesAName(String name) {
        this.properties.setProperty(PARTICLES_A_NAME_KEY, name);
    }

    public void setParticlesAType(ParticleType type) {
        this.properties.setProperty(PARTICLES_A_TYPE_KEY, type.toString());
    }

    public void setParticlesABatchPrefix(String prefix) {
        this.properties.setProperty(PARTICLES_A_BATCH_PREFIX_KEY, prefix);
    }

    public void setParticlesAFilterExpression(String expression) {
        this.properties.setProperty(PARTICLES_A_FILTER_KEY, expression);
    }

    public void setParticlesAProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        for (String string : properties.keySet()) {
            this.properties.setProperty(PARTICLES_A_PROPERTIES_KEY + string, properties.getProperty(string));
        }
    }

    public void setParticlesBName(String name) {
        this.properties.setProperty(PARTICLES_B_NAME_KEY, name);
    }

    public void setParticlesBType(ParticleType type) {
        this.properties.setProperty(PARTICLES_B_TYPE_KEY, type.toString());
    }

    public void setParticlesBBatchPrefix(String prefix) {
        this.properties.setProperty(PARTICLES_B_BATCH_PREFIX_KEY, prefix);
    }

    public void setParticlesBFilterExpression(String expression) {
        this.properties.setProperty(PARTICLES_B_FILTER_KEY, expression);
    }

    public void setParticlesBProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        for (String string : properties.keySet()) {
            this.properties.setProperty(PARTICLES_B_PROPERTIES_KEY + string, properties.getProperty(string));
        }
    }

    public void setThreadNumber(int threadNumber) {
        this.properties.setProperty(THREAD_NUMBER_KEY, "" + threadNumber);
    }

    public void setVisualisationParticlesAInDifferentsColors(boolean differentColors) {
        this.properties.setProperty(VISUALIZATION_SHOW_PARTICLES_A_DIFFERENT_COLORS_KEY, Boolean.toString(differentColors));
    }

    public void setVisualisationParticlesBInDifferentsColors(boolean differentColors) {
        this.properties.setProperty(VISUALIZATION_SHOW_PARTICLES_B_DIFFERENT_COLORS_KEY, Boolean.toString(differentColors));
    }

    public void setHistogramResultsNumberClasses(int classes) {
        this.properties.setProperty(HISTOGRAM_RESULTS_NB_CLASSES_KEY, Integer.toString(classes));
    }

    public void setHistogramHistoryNumberClasses(int classes) {
        this.properties.setProperty(HISTOGRAM_HISTORY_NB_CLASSES_KEY, Integer.toString(classes));
    }

    public void setCustomHistoryExpression(String expression) {
        this.properties.setProperty(CUSTOM_HISTORY_EXPRESSION_KEY, expression);
    }

    public void setClearHistoryWhenLaunchNewCalc(boolean value) {
        this.properties.setProperty(CLEAR_HISTORY_WHEN_NEW_CALC_KEY, Boolean.toString(value));
    }

    public void setEnableParticlesAViewerFilter(boolean value) {
        this.properties.setProperty(VISUALIZATION_FILTER_PARTICLES_A_ENABLE_KEY, Boolean.toString(value));
    }

    public void setExpressionParticlesAViewerFilter(String expression) {
        this.properties.setProperty(VISUALIZATION_FILTER_PARTICLES_A_EXPRESSION_KEY, expression);
    }

    public void setEnableParticlesBViewerFilter(boolean value) {
        this.properties.setProperty(VISUALIZATION_FILTER_PARTICLES_B_ENABLE_KEY, Boolean.toString(value));
    }

    public void setExpressionParticlesBViewerFilter(String expression) {
        this.properties.setProperty(VISUALIZATION_FILTER_PARTICLES_B_EXPRESSION_KEY, expression);
    }

    public void setEnableDistancesViewerFilter(boolean value) {
        this.properties.setProperty(VISUALIZATION_FILTER_DISTANCES_ENABLE_KEY, Boolean.toString(value));
    }

    public void setExpressionDistancesViewerFilter(String expression) {
        this.properties.setProperty(VISUALIZATION_FILTER_DISTANCES_EXPRESSION_KEY, expression);
    }

    public void setFilterShowDistanceShowedParticles(boolean value) {
        this.properties.setProperty(VISUALIZATION_FILTER_SHOW_DISTANCES_SHOWED_PARTICLES_KEY, Boolean.toString(value));
    }

    public Color colorFromString(String s) {
        if (s == null) {
            return null;
        }
        String[] words = s.split("\\,");
        if (words.length < 3) {
            return null;
        }
        int r = Integer.parseInt(words[0].trim());
        int g = Integer.parseInt(words[1].trim());
        int b = Integer.parseInt(words[2].trim());
        if (words.length > 3) {
            int a = Integer.parseInt(words[3].trim());
            return new Color(r, g, b, a);
        }
        return new Color(r, g, b);
    }

    public String colorToString(Color c) {
        if (c == null) {
            return null;
        }
        return c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "," + c.getAlpha();
    }

    public static String getConfigurationFilePath() {
        String os = System.getProperty("os.name");
        String home = System.getProperty("user.home");
        if (os.toLowerCase().startsWith("windows")) {
            return home + File.separator + "Application Data" + File.separator + Globals.APP_NAME_LOWER_CASE + ".conf";
        }
        return home + File.separator + "." + Globals.APP_NAME_LOWER_CASE;
    }

    public void saveSettings() throws IOException {
        this.saveSettings(new File(Settings.getConfigurationFilePath()));
    }

    public void saveSettings(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        this.properties.store(fos, " Corsen version " + Globals.APP_VERSION + " configuration file");
        fos.close();
    }

    public void loadSettings() throws IOException {
        this.loadSettings(new File(Settings.getConfigurationFilePath()));
    }

    public void loadSettings(String filename) throws IOException {
        if (filename == null) {
            this.loadSettings();
        } else {
            this.loadSettings(new File(filename));
        }
    }

    public void loadSettings(File file) throws IOException {
        logger.info("Load configuration file: " + file.getAbsolutePath());
        FileInputStream fis = new FileInputStream(file);
        this.properties.load(fis);
        fis.close();
        if (!CorsenHistoryResults.getCorsenHistoryResults().setCustomExpression(this.getCustomHistoryExpression())) {
            this.setCustomHistoryExpression("");
        }
        if (JavascriptDistancesFilter.createFilter(this.getDistancesViewFilterExpression()) == null) {
            this.setExpressionDistancesViewerFilter("");
        }
        if (JavascriptParticles3DFilter.createFilter(this.getParticlesAFilterExpression()) == null) {
            this.setParticlesAFilterExpression("");
        }
        if (JavascriptParticles3DFilter.createFilter(this.getParticlesBFilterExpression()) == null) {
            this.setParticlesBFilterExpression("");
        }
    }

    public void addSettings(Settings s) {
        if (s == null) {
            return;
        }
        Properties p = s.properties;
        Enumeration<Object> keys = p.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.properties.setProperty(key, p.getProperty(key));
        }
    }
}

