/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.calc;

import fr.ens.transcriptome.corsen.ProgressEvent;
import fr.ens.transcriptome.corsen.calc.Distance;
import fr.ens.transcriptome.corsen.calc.DistanceProcessor;
import fr.ens.transcriptome.corsen.model.AbstractListPoint3D;
import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.model.Particle3DBuilder;
import fr.ens.transcriptome.corsen.model.Particle3DUtil;
import fr.ens.transcriptome.corsen.model.Particles3D;
import fr.ens.transcriptome.corsen.model.Point3D;
import fr.ens.transcriptome.corsen.model.SingletonListPoint3D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarycenterParticles3DType
extends DistanceProcessor {
    private static String TYPE = "Barycenter";

    @Override
    public String getPreProcessorType() {
        return TYPE;
    }

    @Override
    public Map<Particle3D, List<Particle3D>> computePreprocessedParticles(ProgressEvent.ProgressEventType eventType) {
        Particles3D pars = this.getSourceParticles();
        if (pars == null) {
            return null;
        }
        HashMap<Particle3D, List<Particle3D>> result = new HashMap<Particle3D, List<Particle3D>>();
        int count = 0;
        int countMax = pars.getParticles().size();
        Particle3DBuilder p3b = null;
        for (Particle3D par : pars.getParticles()) {
            if (p3b == null) {
                p3b = new Particle3DBuilder(par);
            }
            result.put(par, Collections.singletonList(Particle3DUtil.createBarycentreParticle3D(par, p3b)));
            double p = (double)(++count) / (double)countMax * 1000.0;
            this.sendEvent(eventType, (int)p);
        }
        return result;
    }

    @Override
    List<Distance> calcDistance(Particle3D particle, Point3D point, Particle3D particleOfPoint, List<Distance> result) {
        if (particle == null) {
            throw new NullPointerException("Particle to test is null");
        }
        if (point == null) {
            throw new NullPointerException("Point to test is null");
        }
        if (result == null) {
            result = new ArrayList<Distance>();
        } else {
            result.clear();
        }
        for (Point3D p : particle.getInnerPoints()) {
            result.add(new Distance(p, point, particleOfPoint, particle, p.distance(point)));
        }
        return result;
    }

    @Override
    AbstractListPoint3D getPresentationPointsA(AbstractListPoint3D pointsA) {
        return new SingletonListPoint3D(pointsA.getBarycenter());
    }

    @Override
    protected void setProperties(Properties properties) {
    }
}

