/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.calc;

import fr.ens.transcriptome.corsen.calc.CorsenResult;
import fr.ens.transcriptome.corsen.calc.Distance;
import fr.ens.transcriptome.corsen.calc.DistanceAnalyser;
import fr.ens.transcriptome.corsen.model.Particle3D;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.math.stat.descriptive.moment.Mean;
import org.apache.commons.math.stat.descriptive.rank.Median;

public final class CorsenHistoryResults {
    private static CorsenHistoryResults singleton = new CorsenHistoryResults();
    private Map<String, Entry> entries = new LinkedHashMap<String, Entry>();
    private List<String> keys = new ArrayList<String>();
    private static int count = 0;
    private Map<StatType, double[]> data = new HashMap<StatType, double[]>();
    private StatType statType = StatType.values()[0];
    private CompiledScript script;

    public StatType getStatType() {
        return this.statType;
    }

    public void setStatType(StatType statType) {
        this.statType = statType;
    }

    public void addResult(CorsenResult cr) {
        if (cr == null) {
            return;
        }
        File fileA = cr.getMessengersFile();
        File fileB = cr.getMitosFile();
        String key = fileA.getAbsolutePath() + "-" + fileB.getAbsolutePath();
        if (this.entries.containsKey(key)) {
            this.keys.remove(key);
        }
        Entry e = new Entry(fileA, fileB, cr);
        e.setCustom(this.calcCustomValue(cr));
        this.entries.put(key, e);
        this.keys.add(key);
        this.data.clear();
    }

    public void clear() {
        this.entries.clear();
        this.keys.clear();
        this.data.clear();
    }

    public int size() {
        return this.entries.size();
    }

    public void remove(int index) {
        String key = this.keys.get(index);
        this.entries.remove(key);
        this.keys.remove(index);
        this.data.clear();
    }

    public Entry get(int index) {
        String key = this.keys.get(index);
        return this.entries.get(key);
    }

    public double[] getDistances() {
        if (this.data.containsKey((Object)this.statType)) {
            return this.data.get((Object)this.statType);
        }
        double[] data = new double[this.size()];
        int count = 0;
        for (Map.Entry<String, Entry> e : this.entries.entrySet()) {
            double value;
            switch (this.statType) {
                case MEAN: {
                    value = e.getValue().getMeanMinDistance();
                    break;
                }
                case MIN: {
                    value = e.getValue().getMinMinDistance();
                    break;
                }
                case MAX: {
                    value = e.getValue().getMaxMinDistance();
                    break;
                }
                case CUSTOM: {
                    value = e.getValue().getCustomMinDistance();
                    break;
                }
                default: {
                    value = e.getValue().getMedianMinDistance();
                }
            }
            data[count++] = value;
        }
        this.data.put(this.statType, data);
        return data;
    }

    public double getMedianOfMedianMinDistances() {
        return new Median().evaluate(this.getDistances());
    }

    public double getMeanOfMedianMinDistances() {
        return new Mean().evaluate(this.getDistances());
    }

    public boolean setCustomExpression(String expression) {
        this.script = null;
        if (expression == null || "".equals(expression.trim())) {
            return true;
        }
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("js");
        Compilable compilable = (Compilable)((Object)engine);
        try {
            CompiledScript script;
            this.script = script = compilable.compile(expression);
        }
        catch (ScriptException e) {
            return false;
        }
        return true;
    }

    private double calcCustomValue(CorsenResult cr) {
        if (this.script == null) {
            return Double.NaN;
        }
        Map<Particle3D, Distance> in = cr.getMinDistances();
        long inCount = 0L;
        long outCount = 0L;
        for (Map.Entry<Particle3D, Distance> e : in.entrySet()) {
            Particle3D particle = e.getKey();
            long intensity = particle.getIntensity();
            Distance distance = e.getValue();
            inCount += intensity;
            Bindings b = this.script.getEngine().getBindings(100);
            b.put("i", (Object)intensity);
            b.put("d", (Object)Float.valueOf(distance.getDistance()));
            try {
                Object o = this.script.eval();
                if (!(o instanceof Boolean) || !((Boolean)o).booleanValue()) continue;
                outCount += intensity;
            }
            catch (ScriptException e1) {}
        }
        return (double)outCount / (double)inCount;
    }

    public static CorsenHistoryResults getCorsenHistoryResults() {
        return singleton;
    }

    private CorsenHistoryResults() {
    }

    static /* synthetic */ int access$008() {
        return count++;
    }

    public static final class Entry {
        private int id = CorsenHistoryResults.access$008();
        private File fileA;
        private File fileB;
        private File resultsPath;
        private double medianMinDistance;
        private double meanMinDistance;
        private double minMinDistance;
        private double maxMinDistance;
        private double customMinDistance;

        public int getId() {
            return this.id;
        }

        public File getFileA() {
            return this.fileA;
        }

        public File getFileB() {
            return this.fileB;
        }

        public File getResultsPath() {
            return this.resultsPath;
        }

        public double getMedianMinDistance() {
            return this.medianMinDistance;
        }

        public double getMeanMinDistance() {
            return this.meanMinDistance;
        }

        public double getMinMinDistance() {
            return this.minMinDistance;
        }

        public double getMaxMinDistance() {
            return this.maxMinDistance;
        }

        public double getCustomMinDistance() {
            return this.customMinDistance;
        }

        private void setCustom(double customValue) {
            this.customMinDistance = customValue;
        }

        private Entry(File fileA, File fileB, CorsenResult cr) {
            DistanceAnalyser da = cr.getMinAnalyser();
            this.fileA = fileA;
            this.fileB = fileB;
            this.resultsPath = cr.getResultsPath();
            this.medianMinDistance = da.getMedian();
            this.meanMinDistance = da.getMean();
            this.minMinDistance = da.getMin();
            this.maxMinDistance = da.getMax();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatType {
        MEDIAN("median"),
        MEAN("mean"),
        MIN("min"),
        MAX("max"),
        CUSTOM("custom");

        private String description;

        public String toString() {
            return this.description;
        }

        public static StatType getTypeFromDescription(String description) {
            if (description == null) {
                return null;
            }
            StatType[] types = StatType.values();
            for (int i = 0; i < types.length; ++i) {
                if (!description.equals(types[i].toString())) continue;
                return types[i];
            }
            return null;
        }

        private StatType(String description) {
            this.description = description;
        }
    }
}

