/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.calc;

import fr.ens.transcriptome.corsen.Settings;
import fr.ens.transcriptome.corsen.UpdateStatus;
import fr.ens.transcriptome.corsen.calc.Distance;
import fr.ens.transcriptome.corsen.calc.DistanceAnalyser;
import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.model.Particles3D;
import fr.ens.transcriptome.corsen.model.Particles3DFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorsenResult {
    private UpdateStatus updateStatus;
    private Settings settings;
    private File particlesAFile;
    private File particlesBFile;
    private File resultPath;
    private InputStream particlesAStream;
    private InputStream particlesBStream;
    private Particles3D particlesA;
    private Particles3D particlesB;
    private Particles3D particlesACuboids;
    private Particles3D particlesBCuboids;
    private Map<Particle3D, Distance> minDistances;
    private Map<Particle3D, Distance> maxDistances;
    private DistanceAnalyser minAnalyser;
    private DistanceAnalyser maxAnalyser;
    private Particles3DFilter particlesAFilter;
    private Particles3DFilter particlesBFilter;

    public Particles3D getCuboidsParticlesA() {
        return this.particlesACuboids;
    }

    public Particles3D getCuboidsParticlesB() {
        return this.particlesBCuboids;
    }

    public Map<Particle3D, Distance> getMaxDistances() {
        return this.maxDistances;
    }

    public Particles3D getParticlesA() {
        return this.particlesA;
    }

    public Map<Particle3D, Distance> getMinDistances() {
        return this.minDistances;
    }

    public Particles3D getParticlesB() {
        return this.particlesB;
    }

    UpdateStatus getUpdateStatus() {
        return this.updateStatus;
    }

    public File getMessengersFile() {
        return this.particlesAFile;
    }

    public File getMitosFile() {
        return this.particlesBFile;
    }

    public File getResultsPath() {
        return this.resultPath;
    }

    InputStream getMessengersStream() {
        return this.particlesAStream;
    }

    InputStream getMitosStream() {
        return this.particlesBStream;
    }

    Settings getSettings() {
        return this.settings;
    }

    public DistanceAnalyser getMaxAnalyser() {
        return this.maxAnalyser;
    }

    public DistanceAnalyser getMinAnalyser() {
        return this.minAnalyser;
    }

    public Particles3DFilter getParticlesAFilter() {
        return this.particlesAFilter;
    }

    public Particles3DFilter getParticlesBFilter() {
        return this.particlesBFilter;
    }

    public void setMaxAnalyser(DistanceAnalyser maxAnalyser) {
        this.maxAnalyser = maxAnalyser;
    }

    public void setMinAnalyser(DistanceAnalyser minAnalyser) {
        this.minAnalyser = minAnalyser;
    }

    void setParticlesA(Particles3D particlesA) {
        this.particlesA = particlesA;
    }

    void setParticlesB(Particles3D particlesB) {
        this.particlesB = particlesB;
    }

    public void setUpdateStatus(UpdateStatus updateStatus) {
        this.updateStatus = updateStatus;
    }

    void setCuboidsParticlesB(Particles3D particles) {
        this.particlesBCuboids = particles;
    }

    void setCuboidsParticlesA(Particles3D particles) {
        this.particlesACuboids = particles;
    }

    void setMaxDistances(Map<Particle3D, Distance> maxDistances) {
        this.maxDistances = maxDistances;
    }

    void setMinDistances(Map<Particle3D, Distance> minDistances) {
        this.minDistances = minDistances;
    }

    public void setParticlesAFilter(Particles3DFilter particlesAFilter) {
        this.particlesAFilter = particlesAFilter;
    }

    public void setParticlesBFilter(Particles3DFilter particlesBFilter) {
        this.particlesBFilter = particlesBFilter;
    }

    public CorsenResult(File particlesAFile, File particlesBFile, File resultsPath, Settings settings, UpdateStatus updateStatus) throws FileNotFoundException {
        this(particlesAFile, particlesBFile, new FileInputStream(particlesAFile), new FileInputStream(particlesBFile), resultsPath, settings, updateStatus);
    }

    public CorsenResult(File particlesAFile, File particlesBFile, InputStream particlesAStream, InputStream particlesBStream, File resultsPath, Settings settings, UpdateStatus updateStatus) {
        if (particlesBStream == null) {
            throw new RuntimeException("Unable to find particles A file");
        }
        if (particlesAStream == null) {
            throw new RuntimeException("Unable to find particles B file");
        }
        this.particlesBFile = particlesBFile;
        this.particlesAFile = particlesAFile;
        this.particlesBStream = particlesBStream;
        this.particlesAStream = particlesAStream;
        this.resultPath = resultsPath;
        this.settings = settings;
        this.setUpdateStatus(updateStatus);
    }
}

