/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.calc;

import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.model.Particle3DUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CuboidUtil {
    CuboidUtil() {
    }

    public static final int[] keyParser(String s) {
        String[] values = s.split("\\,");
        int[] result = new int[]{Integer.parseInt(values[0]), Integer.parseInt(values[1]), Integer.parseInt(values[2])};
        return result;
    }

    public static final String createKey(int x, int y, int z) {
        return "" + x + "," + y + "," + z;
    }

    public static final boolean isFullCuboid(Map cuboids, int x, int y, int z) {
        String key = CuboidUtil.createKey(x, y, z);
        if (!cuboids.containsKey(key)) {
            return false;
        }
        Particle3D p = (Particle3D)cuboids.get(key);
        return p.innerPointsCount() == 8;
    }

    public static final List<Particle3D> defineCuboids(Particle3D particle, float xlen, float ylen, float zlen) {
        if (particle == null) {
            throw new NullPointerException("Particle is null");
        }
        Map<String, Particle3D> cuboids = Particle3DUtil.createCuboidToMap(particle, xlen * 2.0f, ylen * 2.0f, zlen * 2.0f);
        HashSet<Particle3D> toRemove = new HashSet<Particle3D>();
        for (Map.Entry<String, Particle3D> e : cuboids.entrySet()) {
            int z;
            int y;
            int[] coords;
            int x;
            String key = e.getKey();
            Particle3D p = e.getValue();
            int count = p.innerPointsCount();
            if (count == 0) {
                toRemove.add(p);
                continue;
            }
            if (count != 8 || !CuboidUtil.isFullCuboid(cuboids, (x = (coords = CuboidUtil.keyParser(key))[0]) - 1, y = coords[1], z = coords[2]) || !CuboidUtil.isFullCuboid(cuboids, x, y + 1, z) || !CuboidUtil.isFullCuboid(cuboids, x, y - 1, z) || !CuboidUtil.isFullCuboid(cuboids, x + 1, y, z) || !CuboidUtil.isFullCuboid(cuboids, x, y, z + 1) || !CuboidUtil.isFullCuboid(cuboids, x, y, z - 1)) continue;
            toRemove.add(p);
        }
        Iterator it = toRemove.iterator();
        while (it.hasNext()) {
            cuboids.remove(it.next());
        }
        return new ArrayList<Particle3D>(cuboids.values());
    }
}

