/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.calc;

import fr.ens.transcriptome.corsen.ProgressEvent;
import fr.ens.transcriptome.corsen.calc.Distance;
import fr.ens.transcriptome.corsen.calc.DistanceProcessor;
import fr.ens.transcriptome.corsen.model.AbstractListPoint3D;
import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.model.Particle3DUtil;
import fr.ens.transcriptome.corsen.model.Particles3D;
import fr.ens.transcriptome.corsen.model.Point3D;
import fr.ens.transcriptome.corsen.model.SingletonListPoint3D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecompostionParticles3DType
extends DistanceProcessor {
    private static String TYPE = "Decomposition";

    @Override
    public String getPreProcessorType() {
        return TYPE;
    }

    @Override
    public Map<Particle3D, List<Particle3D>> computePreprocessedParticles(ProgressEvent.ProgressEventType eventType) {
        Particles3D particles = this.getSourceParticles();
        if (particles == null) {
            return null;
        }
        HashMap<Particle3D, List<Particle3D>> mapCuboids = new HashMap<Particle3D, List<Particle3D>>();
        int countMax = Particle3DUtil.countInnerPointsInParticles(particles.getParticles());
        int count = 0;
        for (Particle3D par : particles.getParticles()) {
            float len = particles.getPixelDepth();
            if (particles.getPixelWidth() > len) {
                len = particles.getPixelWidth();
            }
            if (particles.getPixelHeight() > len) {
                len = particles.getPixelHeight();
            }
            List<Particle3D> cuboids = Particle3DUtil.createCuboidToArrayList(par, len *= 2.1f, len, len);
            mapCuboids.put(par, cuboids);
            double p = (double)(count += par.innerPointsCount()) / (double)countMax * 1000.0;
            this.sendEvent(eventType, (int)p);
        }
        return mapCuboids;
    }

    @Override
    List<Distance> calcDistance(Particle3D particle, Point3D point, Particle3D particleOfPoint, List<Distance> result) {
        if (particle == null) {
            throw new NullPointerException("Particle to test is null");
        }
        if (point == null) {
            throw new NullPointerException("Point to test is null");
        }
        AbstractListPoint3D list = particle.getInnerPoints();
        if (result == null) {
            result = new ArrayList<Distance>(list.size());
        } else {
            result.clear();
        }
        for (Point3D p : list) {
            result.add(new Distance(p, point, particleOfPoint, particle, p.distance(point)));
        }
        return result;
    }

    @Override
    AbstractListPoint3D getPresentationPointsA(AbstractListPoint3D pointsA) {
        if (pointsA == null) {
            return null;
        }
        return new SingletonListPoint3D(pointsA.getBarycenter());
    }

    @Override
    protected void setProperties(Properties properties) {
    }
}

