/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.calc;

import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.model.Point3D;
import fr.ens.transcriptome.corsen.util.HashCodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Distance
implements Comparable<Distance> {
    private Particle3D particleA;
    private Particle3D particleB;
    private Point3D pointA;
    private Point3D pointB;
    private float distance;
    private boolean comparatorAbsoluteMode = true;

    public float getDistance() {
        return this.distance;
    }

    public Particle3D getParticleA() {
        return this.particleA;
    }

    public Particle3D getParticleB() {
        return this.particleB;
    }

    public Point3D getPointA() {
        return this.pointA;
    }

    public Point3D getPointB() {
        return this.pointB;
    }

    public boolean isComparatorAbsoluteMode() {
        return this.comparatorAbsoluteMode;
    }

    void setParticleA(Particle3D particleA) {
        this.particleA = particleA;
    }

    void setParticleB(Particle3D particleB) {
        this.particleB = particleB;
    }

    public void setComparatorAbsoluteMode(boolean comparatorAbsoluteMode) {
        this.comparatorAbsoluteMode = comparatorAbsoluteMode;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Distance)) {
            return false;
        }
        return ((Distance)o).distance == this.distance;
    }

    @Override
    public final int compareTo(Distance distance) {
        float f = !this.comparatorAbsoluteMode ? this.distance - distance.distance : Math.abs(this.distance) - Math.abs(distance.distance);
        if (f < 0.0f) {
            return -1;
        }
        if (f > 0.0f) {
            return 1;
        }
        return 0;
    }

    public final int hashCode() {
        int result = 23;
        result = HashCodeUtil.hash(result, this.particleA);
        result = HashCodeUtil.hash(result, this.particleB);
        result = HashCodeUtil.hash(result, this.pointA);
        result = HashCodeUtil.hash(result, this.pointB);
        result = HashCodeUtil.hash(result, this.distance);
        return result;
    }

    public Distance(Point3D pointA, Point3D pointB, float distance) {
        this.pointA = pointA;
        this.pointB = pointB;
        this.distance = distance;
    }

    public Distance(Point3D pointA, Point3D pointB, Particle3D particleA, Particle3D particleB, float distance) {
        this(pointA, pointB, distance);
        this.setParticleA(particleA);
        this.setParticleB(particleB);
    }
}

