/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.calc;

import fr.ens.transcriptome.corsen.calc.Distance;
import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.util.Stats;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistanceAnalyser {
    private double min = Double.NaN;
    private double firstQuartile = Double.NaN;
    private double median = Double.NaN;
    private double mean = Double.NaN;
    private double thirdQuartile = Double.NaN;
    private double max = Double.NaN;
    private double minRegularValue = Double.NaN;
    private double maxRegularValue = Double.NaN;
    private double minOutlier = Double.NaN;
    private double maxOutlier = Double.NaN;
    private List<Double> listOutliers;
    private boolean minCalcDone;
    private boolean firstQuartileCalcDone;
    private boolean medianCalcDone;
    private boolean meanCalcDone;
    private boolean thirdQuartileCalcDone;
    private boolean maxCalcDone;
    private boolean outliersCalcDone;
    private List<Stats.DataDouble> data;

    private void setDistances(Map<Particle3D, Distance> mapDistances) {
        this.data = new ArrayList<Stats.DataDouble>();
        for (Map.Entry<Particle3D, Distance> e : mapDistances.entrySet()) {
            Distance d = e.getValue();
            Particle3D par = e.getKey();
            this.data.add(new Stats.DataDouble(d.getDistance(), par.getIntensity()));
        }
    }

    public int count() {
        return this.data.size();
    }

    public double getMin() {
        if (!this.minCalcDone) {
            this.min = Stats.min(this.data);
            this.minCalcDone = true;
        }
        return this.min;
    }

    public double getFirstQuartile() {
        if (!this.firstQuartileCalcDone) {
            this.firstQuartile = Stats.firstQuartile(this.data);
            this.firstQuartileCalcDone = true;
        }
        return this.firstQuartile;
    }

    public double getMedian() {
        if (!this.medianCalcDone) {
            this.median = Stats.median(this.data);
            this.medianCalcDone = true;
        }
        return this.median;
    }

    public double getMean() {
        if (!this.meanCalcDone) {
            this.mean = Stats.mean(this.data);
            this.meanCalcDone = true;
        }
        return this.mean;
    }

    public double getThirdQuartile() {
        if (!this.thirdQuartileCalcDone) {
            this.thirdQuartile = Stats.thirdQuartile(this.data);
            this.thirdQuartileCalcDone = true;
        }
        return this.thirdQuartile;
    }

    public double getMax() {
        if (!this.maxCalcDone) {
            this.max = Stats.max(this.data);
            this.maxCalcDone = true;
        }
        return this.max;
    }

    public double getMinRegularValue() {
        if (!this.outliersCalcDone) {
            this.calcOutliers();
        }
        return this.minRegularValue;
    }

    public double getMaxRegularValue() {
        if (!this.outliersCalcDone) {
            this.calcOutliers();
        }
        return this.maxRegularValue;
    }

    public double getMinOutlier() {
        if (!this.outliersCalcDone) {
            this.calcOutliers();
        }
        return this.minOutlier;
    }

    public double getMaxOutlier() {
        if (!this.outliersCalcDone) {
            this.calcOutliers();
        }
        return this.maxOutlier;
    }

    public List<Double> getOutliers() {
        if (!this.outliersCalcDone) {
            this.calcOutliers();
        }
        return this.listOutliers;
    }

    private void load(File file) throws IOException {
        String line;
        FileInputStream is = new FileInputStream(file);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        this.data = new ArrayList<Stats.DataDouble>();
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] values = line.split("\t");
            this.data.add(new Stats.DataDouble(Float.parseFloat(values[1]), Long.parseLong(values[0])));
        }
        reader.close();
    }

    private void calcOutliers() {
        double q1 = this.getFirstQuartile();
        double q3 = this.getThirdQuartile();
        double interQuartileRange = q3 - q1;
        double upperOutlierThreshold = q3 + interQuartileRange * 1.5;
        double lowerOutlierThreshold = q1 - interQuartileRange * 1.5;
        double upperFaroutThreshold = q3 + interQuartileRange * 2.0;
        double lowerFaroutThreshold = q1 - interQuartileRange * 2.0;
        double minRegularValue = Double.POSITIVE_INFINITY;
        double maxRegularValue = Double.NEGATIVE_INFINITY;
        double minOutlier = Double.POSITIVE_INFINITY;
        double maxOutlier = Double.NEGATIVE_INFINITY;
        ArrayList<Double> outliers = new ArrayList<Double>();
        for (Stats.DataDouble d : this.data) {
            double value = d.value;
            if (value > upperOutlierThreshold) {
                outliers.add(value);
                if (value > maxOutlier && value <= upperFaroutThreshold) {
                    maxOutlier = value;
                }
            } else if (value < lowerOutlierThreshold) {
                outliers.add(value);
                if (value < minOutlier && value >= lowerFaroutThreshold) {
                    minOutlier = value;
                }
            } else {
                minRegularValue = Math.min(minRegularValue, value);
                maxRegularValue = Math.max(maxRegularValue, value);
            }
            minOutlier = Math.min(minOutlier, minRegularValue);
            maxOutlier = Math.max(maxOutlier, maxRegularValue);
        }
        this.minRegularValue = minRegularValue;
        this.maxRegularValue = maxRegularValue;
        this.minOutlier = minOutlier;
        this.maxOutlier = maxOutlier;
        this.listOutliers = outliers;
        this.outliersCalcDone = true;
    }

    public void calcAll() {
        this.min = Stats.min(this.data);
        this.minCalcDone = true;
        this.firstQuartile = Stats.firstQuartile(this.data);
        this.firstQuartileCalcDone = true;
        this.median = Stats.median(this.data);
        this.medianCalcDone = true;
        this.mean = Stats.mean(this.data);
        this.meanCalcDone = true;
        this.thirdQuartile = Stats.thirdQuartile(this.data);
        this.thirdQuartileCalcDone = true;
        this.max = Stats.max(this.data);
        this.maxCalcDone = true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Min.\t1st Qu.\tMedian\tMean\t3rd Qu.\tMax.\n");
        sb.append(String.format("%2.3f\t%2.3f\t%2.3f\t%2.3f\t%2.3f\t%2.3f", this.getMin(), this.getFirstQuartile(), this.getMedian(), this.getMean(), this.getThirdQuartile(), this.getMax()));
        return sb.toString();
    }

    public DistanceAnalyser(Map<Particle3D, Distance> mapDistances) {
        this.setDistances(mapDistances);
    }

    public DistanceAnalyser(File file) throws IOException {
        this.load(file);
    }
}

