/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.calc;

import fr.ens.transcriptome.corsen.ProgressEvent;
import fr.ens.transcriptome.corsen.UpdateStatus;
import fr.ens.transcriptome.corsen.calc.Distance;
import fr.ens.transcriptome.corsen.model.AbstractListPoint3D;
import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.model.Particles3D;
import fr.ens.transcriptome.corsen.model.Point3D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DistanceProcessor {
    private Particles3D sourceParticles;
    private List<Particle3D> destParticles;
    private UpdateStatus updateStatus;

    public Particles3D getSourceParticles() {
        return this.sourceParticles;
    }

    public List<Particle3D> getPreprocessedParticles() {
        return this.destParticles;
    }

    public void setSourceParticles(Particles3D particles) {
        this.sourceParticles = particles;
    }

    private void setPreprocessedParticles(Map<Particle3D, List<Particle3D>> destParticles) {
        this.destParticles = new ArrayList<Particle3D>();
        for (Map.Entry<Particle3D, List<Particle3D>> e : destParticles.entrySet()) {
            this.destParticles.addAll((Collection<Particle3D>)e.getValue());
        }
    }

    public void setUpdateStatus(UpdateStatus updateStatus) {
        this.updateStatus = updateStatus;
    }

    public UpdateStatus getUpdateStatus() {
        return this.updateStatus;
    }

    protected void sendEvent(ProgressEvent.ProgressEventType type, int value1) {
        if (this.updateStatus == null) {
            return;
        }
        this.updateStatus.updateStatus(new ProgressEvent(type, value1));
    }

    List<Distance> calcDistance(Particle3D particle, AbstractListPoint3D points, Particle3D particleOfPoints) {
        if (particle == null || points == null) {
            return null;
        }
        ArrayList<Distance> result = new ArrayList<Distance>();
        List<Distance> resultForOnePoint = null;
        for (Point3D point : points) {
            resultForOnePoint = this.calcDistance(particle, point, particleOfPoints, resultForOnePoint);
            result.addAll(resultForOnePoint);
        }
        return result;
    }

    final void preprocess(ProgressEvent.ProgressEventType eventType) {
        this.setPreprocessedParticles(this.computePreprocessedParticles(eventType));
    }

    protected abstract Map<Particle3D, List<Particle3D>> computePreprocessedParticles(ProgressEvent.ProgressEventType var1);

    public abstract String getPreProcessorType();

    abstract List<Distance> calcDistance(Particle3D var1, Point3D var2, Particle3D var3, List<Distance> var4);

    abstract AbstractListPoint3D getPresentationPointsA(AbstractListPoint3D var1);

    abstract void setProperties(Properties var1);
}

