/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.calc;

import fr.ens.transcriptome.corsen.ProgressEvent;
import fr.ens.transcriptome.corsen.UpdateStatus;
import fr.ens.transcriptome.corsen.calc.CorsenHistoryResults;
import fr.ens.transcriptome.corsen.calc.CorsenResult;
import fr.ens.transcriptome.corsen.calc.Distance;
import fr.ens.transcriptome.corsen.calc.DistanceAnalyser;
import fr.ens.transcriptome.corsen.calc.DistanceProcessor;
import fr.ens.transcriptome.corsen.model.AbstractListPoint3D;
import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.model.Particles3D;
import fr.ens.transcriptome.corsen.util.GuidedLoopHandler;
import fr.ens.transcriptome.corsen.util.MinMaxList;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistancesCalculator {
    private Logger logger = Logger.getLogger("Corsen");
    private DistanceProcessor processorA;
    private DistanceProcessor processorB;
    private float zCoordinatesFactor = 1.0f;
    private float coordinatesFactor = 1.0f;
    private UpdateStatus updateStatus;
    private Thread.UncaughtExceptionHandler uceh;
    private CorsenResult result;

    public float getZCoordinatesFactor() {
        return this.zCoordinatesFactor;
    }

    public float getCoordinatesFactor() {
        return this.coordinatesFactor;
    }

    public void setZCoordinatesFactor(float factor) {
        this.zCoordinatesFactor = factor;
    }

    public void setCoordinatesFactor(float factor) {
        this.coordinatesFactor = factor;
    }

    private Thread.UncaughtExceptionHandler getUncaughtExceptionHandler(final UpdateStatus updateStatus) {
        if (this.uceh == null) {
            this.uceh = new Thread.UncaughtExceptionHandler(){

                public void uncaughtException(Thread t, Throwable e) {
                    System.err.println(t.getName() + " Exception: " + e.toString());
                    e.printStackTrace();
                    if (updateStatus == null) {
                        return;
                    }
                    updateStatus.showError(t.getName() + " Exception: " + e.toString());
                }
            };
        }
        return this.uceh;
    }

    private DistanceProcessor getProcessor(Particles3D particles) {
        if (particles == null) {
            return null;
        }
        DistanceProcessor result = particles.getType().getDistanceProcessor();
        result.setSourceParticles(particles);
        return result;
    }

    private void changeFactors(Particles3D particles) {
        if (particles == null) {
            return;
        }
        particles.changeZCoord(this.zCoordinatesFactor);
        particles.changeAllCoord(this.coordinatesFactor);
    }

    public void loadParticles() throws IOException {
        CorsenResult result = this.result;
        String unit = result.getSettings().getUnit();
        this.sendEvent(ProgressEvent.ProgressEventType.START_READ_PARTICLES_A_FILE_EVENT);
        Particles3D particlesA = new Particles3D(result.getMessengersStream());
        particlesA.setName(result.getSettings().getParticlesAName());
        this.logger.info("ParticlesA: " + particlesA.getInnerPointCount() + " inner points, " + particlesA.getSurfacePointCount() + " sufrace points.");
        this.sendEvent(ProgressEvent.ProgressEventType.START_CHANGE_PARTICLES_A_COORDINATES_EVENT);
        this.changeFactors(particlesA);
        this.sendEvent(ProgressEvent.ProgressEventType.START_READ_PARTICLES_B_FILE_EVENT);
        Particles3D particlesB = new Particles3D(result.getMitosStream());
        particlesB.setName(result.getSettings().getParticlesBName());
        this.logger.info("ParticlesB: " + particlesB.getInnerPointCount() + " inner points, " + particlesB.getSurfacePointCount() + " sufrace points.");
        this.sendEvent(ProgressEvent.ProgressEventType.START_CHANGE_PARTICLES_B_COORDINATES_EVENT);
        this.changeFactors(particlesB);
        if (unit != null && !"".equals(unit)) {
            particlesA.setUnitOfLength(unit);
            particlesB.setUnitOfLength(unit);
        }
        this.sendEvent(ProgressEvent.ProgressEventType.START_FILTER_PARTICLES_A_EVENT);
        result.setParticlesA(particlesA.filter(result.getParticlesAFilter()));
        this.sendEvent(ProgressEvent.ProgressEventType.START_FILTER_PARTICLES_B_EVENT);
        result.setParticlesB(particlesB.filter(result.getParticlesBFilter()));
    }

    private Thread preprocessExecution(final DistanceProcessor processor, boolean useThreads, final ProgressEvent.ProgressEventType event, final String threadName) {
        final long start = System.currentTimeMillis();
        if (!useThreads) {
            processor.preprocess(event);
            this.logger.info("End " + threadName + " (process in " + (System.currentTimeMillis() - start) + " ms).");
            return null;
        }
        Thread result = new Thread(new Runnable(){

            public void run() {
                processor.preprocess(event);
                DistancesCalculator.this.logger.info("End " + threadName + " thread (process in " + (System.currentTimeMillis() - start) + " ms).");
            }
        });
        processor.getUpdateStatus().moveToThread(result);
        result.setName(threadName + " thread");
        result.setUncaughtExceptionHandler(this.getUncaughtExceptionHandler(processor.getUpdateStatus()));
        result.start();
        return result;
    }

    private boolean preprocess(boolean useThreads) throws IOException {
        if (this.result == null) {
            return false;
        }
        long start = System.currentTimeMillis();
        Particles3D particlesA = this.result.getParticlesA();
        Particles3D particlesB = this.result.getParticlesB();
        if (particlesA == null || particlesB == null) {
            return false;
        }
        this.processorA = this.getProcessor(particlesA);
        this.processorA.setUpdateStatus(this.updateStatus.chain());
        this.logger.info("Particle A processor: " + particlesA.getType().name());
        this.sendEvent(ProgressEvent.ProgressEventType.START_CALC_PARTICLES_A_CUBOIDS_EVENT);
        Thread tpA = this.preprocessExecution(this.processorA, useThreads, ProgressEvent.ProgressEventType.PROGRESS_CALC_PARTICLES_A_CUBOIDS_EVENT, "preprocess Particle A");
        this.processorB = this.getProcessor(particlesB);
        this.processorB.setUpdateStatus(this.updateStatus.chain());
        this.logger.info("Particle B processor: " + particlesB.getType().name());
        this.sendEvent(ProgressEvent.ProgressEventType.START_CALC_PARTICLES_B_CUBOIDS_EVENT);
        Thread tpB = this.preprocessExecution(this.processorB, useThreads, ProgressEvent.ProgressEventType.PROGRESS_CALC_PARTICLES_B_CUBOIDS_EVENT, "preprocess Particle B");
        if (tpA != null) {
            try {
                tpA.join();
            }
            catch (InterruptedException e) {
                this.logger.severe("Error while waiting the end of the preprocessing.");
            }
        }
        if (tpB != null) {
            try {
                tpB.join();
            }
            catch (InterruptedException e) {
                this.logger.severe("Error while waiting the end of the preprocessing.");
            }
        }
        this.result.setCuboidsParticlesA(new Particles3D(particlesA, this.processorA.getPreprocessedParticles()));
        this.result.setCuboidsParticlesB(new Particles3D(particlesB, this.processorB.getPreprocessedParticles()));
        this.logger.info("Preprocessing in " + (System.currentTimeMillis() - start) + " ms.");
        return true;
    }

    private int getThreadNumber() {
        int threadNumber = this.result.getSettings().getThreadNumber();
        if (threadNumber == 0) {
            threadNumber = Runtime.getRuntime().availableProcessors();
        }
        return threadNumber;
    }

    public void calc() throws IOException {
        int threadNumber = this.getThreadNumber();
        if (!this.preprocess(threadNumber > 1)) {
            return;
        }
        this.sendEvent(ProgressEvent.ProgressEventType.START_CALC_MIN_DISTANCES_EVENT);
        List<Particle3D> listA = this.processorA.getPreprocessedParticles();
        List<Particle3D> listB = this.processorB.getPreprocessedParticles();
        HashMap<Particle3D, Distance> mins = new HashMap<Particle3D, Distance>();
        HashMap<Particle3D, Distance> maxs = new HashMap<Particle3D, Distance>();
        if (threadNumber > 1) {
            this.calcMultiThreads(listA, listB, mins, maxs, threadNumber);
        } else {
            this.calcOneThread(listA, listB, mins, maxs);
        }
        this.result.setMinDistances(mins);
        this.result.setMaxDistances(maxs);
        this.sendEvent(ProgressEvent.ProgressEventType.START_DISTANCES_ANALYSIS);
        DistanceAnalyser daMins = new DistanceAnalyser(mins);
        daMins.calcAll();
        DistanceAnalyser daMaxs = new DistanceAnalyser(maxs);
        daMaxs.calcAll();
        this.result.setMinAnalyser(daMins);
        this.result.setMaxAnalyser(daMaxs);
        CorsenHistoryResults.getCorsenHistoryResults().addResult(this.result);
    }

    private void calcOneThread(List<Particle3D> listA, List<Particle3D> listB, Map<Particle3D, Distance> mins, Map<Particle3D, Distance> maxs) {
        int count = 0;
        int calcsToDoNumber = listA.size() * listB.size();
        int calcsBeforeUpdateInfo = calcsToDoNumber < 100 ? calcsToDoNumber : calcsToDoNumber / 100;
        this.logger.info("Thread number for distance computation: 1");
        long startCalcs = System.currentTimeMillis();
        if (calcsToDoNumber != 0) {
            for (Particle3D parA : listA) {
                AbstractListPoint3D pointsA = this.processorA.getPresentationPointsA(parA.getInnerPoints());
                MinMaxList<Distance> distances = new MinMaxList<Distance>();
                for (Particle3D parB : listB) {
                    distances.addAll(this.processorB.calcDistance(parB, pointsA, parA));
                    if (++count % calcsBeforeUpdateInfo != 0) continue;
                    this.sendEvent(ProgressEvent.ProgressEventType.PROGRESS_CALC_DISTANCES_EVENT, (int)((double)count / (double)calcsToDoNumber * 1000.0));
                }
                mins.put(parA, (Distance)Collections.min(distances));
                maxs.put(parA, (Distance)Collections.max(distances));
            }
        }
        this.logger.info("Calc " + count + " distances in " + (System.currentTimeMillis() - startCalcs) + " ms.");
    }

    private void calcMultiThreads(List<Particle3D> listA, List<Particle3D> listB, Map<Particle3D, Distance> mins, Map<Particle3D, Distance> maxs, int threadNumber) {
        new CalcThread(0, 0, 2, threadNumber).calc(this.processorA, this.processorB, listA, listB, mins, maxs);
    }

    private void filterExtremeDistances(List<Distance> distances) {
        if (distances == null) {
            return;
        }
        Distance min = Collections.min(distances);
        Distance max = Collections.max(distances);
        distances.clear();
        distances.add(min);
        distances.add(max);
    }

    private void sendEvent(ProgressEvent.ProgressEventType type) {
        if (this.updateStatus == null) {
            return;
        }
        this.updateStatus.updateStatus(new ProgressEvent(type));
    }

    private void sendEvent(ProgressEvent.ProgressEventType type, int value1) {
        if (this.updateStatus == null) {
            return;
        }
        this.updateStatus.updateStatus(new ProgressEvent(type, value1));
    }

    public DistancesCalculator(CorsenResult result) {
        if (result == null) {
            throw new NullPointerException("The result object is null");
        }
        this.result = result;
        this.updateStatus = result.getUpdateStatus();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CalcThread
    extends GuidedLoopHandler {
        private DistanceProcessor currentProcessorB;
        private List<Particle3D> listB;
        private Particle3D currentParticleA;
        private AbstractListPoint3D currentPointsA;
        private List<Distance> distances;

        CalcThread(int start, int end, int min, int threads) {
            super(start, end, min, threads);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void loopDoRange(int start, int end) {
            MinMaxList<Distance> distances = new MinMaxList<Distance>();
            for (int i = start; i < end; ++i) {
                Particle3D parB = this.listB.get(i);
                distances.addAll(this.currentProcessorB.calcDistance(parB, this.currentPointsA, this.currentParticleA));
            }
            List<Distance> list = this.distances;
            synchronized (list) {
                this.distances.addAll(distances);
            }
        }

        public void calc(DistanceProcessor processorA, DistanceProcessor processorB, List<Particle3D> listA, List<Particle3D> listB, Map<Particle3D, Distance> mins, Map<Particle3D, Distance> maxs) {
            this.currentProcessorB = processorB;
            this.listB = listB;
            int count = 0;
            int lastShow = 0;
            int listBSize = listB.size();
            int calcsToDoNumber = listA.size() * listBSize;
            int calcsBeforeUpdateInfo = calcsToDoNumber / 100;
            DistancesCalculator.this.logger.info("Thread number for distance computation: " + this.numThreads);
            long startCalcs = System.currentTimeMillis();
            if (calcsBeforeUpdateInfo != 0) {
                Iterator<Particle3D> i$ = listA.iterator();
                while (i$.hasNext()) {
                    Particle3D parA;
                    this.currentParticleA = parA = i$.next();
                    this.currentPointsA = processorA.getPresentationPointsA(parA.getInnerPoints());
                    this.distances = new MinMaxList<Distance>();
                    this.setRange(0, listBSize);
                    this.loopProcess();
                    if ((count += listBSize) - lastShow >= calcsBeforeUpdateInfo) {
                        lastShow = count;
                        DistancesCalculator.this.sendEvent(ProgressEvent.ProgressEventType.PROGRESS_CALC_DISTANCES_EVENT, (int)((double)count / (double)calcsToDoNumber * 1000.0));
                    }
                    mins.put(parA, Collections.min(this.distances));
                    maxs.put(parA, Collections.max(this.distances));
                }
            }
            DistancesCalculator.this.logger.info("Calc " + count + " distances in " + (System.currentTimeMillis() - startCalcs) + " ms.");
        }
    }
}

