/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.calc;

import fr.ens.transcriptome.corsen.calc.Distance;
import fr.ens.transcriptome.corsen.calc.DistancesFilter;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class JavascriptDistancesFilter
implements DistancesFilter {
    private CompiledScript script;
    private Bindings bindings;

    public boolean accept(Distance distance) {
        if (this.script == null) {
            return true;
        }
        if (distance == null) {
            return false;
        }
        Bindings b = this.bindings;
        b.put("distance", (Object)Float.valueOf(distance.getDistance()));
        try {
            Object o = this.script.eval();
            if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
                return true;
            }
        }
        catch (ScriptException scriptException) {
            // empty catch block
        }
        return false;
    }

    private boolean setExpression(String expression) {
        this.script = null;
        if (expression == null || "".equals(expression.trim())) {
            return true;
        }
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("js");
        Compilable compilable = (Compilable)((Object)engine);
        try {
            CompiledScript script;
            this.script = script = compilable.compile(expression);
            this.bindings = script.getEngine().getBindings(100);
        }
        catch (ScriptException e) {
            return false;
        }
        return true;
    }

    public static JavascriptDistancesFilter createFilter(String expression) {
        JavascriptDistancesFilter result = new JavascriptDistancesFilter();
        if (result.setExpression(expression)) {
            return result;
        }
        return null;
    }

    private JavascriptDistancesFilter() {
    }
}

