/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.calc;

import fr.ens.transcriptome.corsen.calc.AllPointsParticles3DType;
import fr.ens.transcriptome.corsen.calc.BarycenterParticles3DType;
import fr.ens.transcriptome.corsen.calc.DecompostionParticles3DType;
import fr.ens.transcriptome.corsen.calc.DistanceProcessor;
import fr.ens.transcriptome.corsen.calc.SurfaceParticles3DType;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ParticleType {
    SURFACE("Surface particle", "Use the surface points of particles to compute distances."),
    DECOMPOSITION("Decomposition particle", "Decompose the particles in cuboids before compute distances."),
    ALLPOINTS("All points particle", "Use all the points of the particles to compute distances."),
    BARYCENTER("Barycenter particle", "Use the barycenter of particles to compute distances.");

    private String description;
    private String fullDescription;

    public String toString() {
        return this.description;
    }

    public String getFullDescription() {
        return this.fullDescription;
    }

    public DistanceProcessor getDistanceProcessor() {
        switch (this) {
            case SURFACE: {
                return new SurfaceParticles3DType();
            }
            case DECOMPOSITION: {
                return new DecompostionParticles3DType();
            }
            case ALLPOINTS: {
                return new AllPointsParticles3DType();
            }
            case BARYCENTER: {
                return new BarycenterParticles3DType();
            }
        }
        return null;
    }

    public static ParticleType getParticleType(String type) {
        if (type == null) {
            return null;
        }
        ParticleType[] types = ParticleType.values();
        for (int i = 0; i < types.length; ++i) {
            if (!type.equals(types[i].toString())) continue;
            return types[i];
        }
        return null;
    }

    public Properties getDefaultProperties() {
        switch (this) {
            case DECOMPOSITION: {
                Properties properties = new Properties();
                properties.setProperty("cuboid.automatic.size", "true");
                properties.setProperty("cuboid.custom.size", "1.0");
                return properties;
            }
        }
        return null;
    }

    private ParticleType(String description, String fullDescription) {
        this.description = description;
        this.fullDescription = fullDescription;
    }
}

