/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.calc;

import fr.ens.transcriptome.corsen.calc.Distance;
import fr.ens.transcriptome.corsen.calc.DistancesFilter;
import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.model.Particles3D;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowedParticlesDistancesFilter
implements DistancesFilter {
    private Set<Particle3D> particlesA;
    private Set<Particle3D> particlesB;

    @Override
    public boolean accept(Distance distance) {
        if (distance == null || this.particlesA == null || this.particlesB == null) {
            return false;
        }
        Particle3D pA = distance.getParticleA();
        Particle3D pB = distance.getParticleB();
        if (pA == null || pB == null) {
            return false;
        }
        return this.particlesA.contains(pA) && this.particlesB.contains(pB);
    }

    private static Set<Particle3D> convertParticles(Particles3D particles) {
        if (particles == null) {
            return null;
        }
        List<Particle3D> pars = particles.getParticles();
        HashSet<Particle3D> result = new HashSet<Particle3D>(pars.size());
        result.addAll(pars);
        return result;
    }

    public ShowedParticlesDistancesFilter(Set<Particle3D> particlesA, Set<Particle3D> particlesB) {
        this.particlesA = particlesA;
        this.particlesB = particlesB;
    }

    public ShowedParticlesDistancesFilter(Particles3D particlesA, Particles3D particlesB) {
        this(ShowedParticlesDistancesFilter.convertParticles(particlesA), ShowedParticlesDistancesFilter.convertParticles(particlesB));
    }
}

