/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.calc;

import fr.ens.transcriptome.corsen.ProgressEvent;
import fr.ens.transcriptome.corsen.calc.Distance;
import fr.ens.transcriptome.corsen.calc.DistanceProcessor;
import fr.ens.transcriptome.corsen.model.AbstractListPoint3D;
import fr.ens.transcriptome.corsen.model.BitMapParticle3D;
import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.model.Particle3DBuilder;
import fr.ens.transcriptome.corsen.model.Particles3D;
import fr.ens.transcriptome.corsen.model.Point3D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfaceParticles3DType
extends DistanceProcessor {
    private static String TYPE = "Surface";

    @Override
    public String getPreProcessorType() {
        return TYPE;
    }

    @Override
    protected Map<Particle3D, List<Particle3D>> computePreprocessedParticles(ProgressEvent.ProgressEventType eventType) {
        Particles3D mitoParticles = this.getSourceParticles();
        if (mitoParticles == null) {
            throw new NullPointerException("The source Particle is null");
        }
        float xlen = mitoParticles.getPixelWidth();
        float ylen = mitoParticles.getPixelHeight();
        float zlen = mitoParticles.getPixelDepth();
        HashMap<Particle3D, List<Particle3D>> mapCuboids = new HashMap<Particle3D, List<Particle3D>>();
        int n = mitoParticles.getParticles().size();
        int i = 0;
        for (Particle3D par : mitoParticles.getParticles()) {
            Particle3DBuilder builder = new Particle3DBuilder(xlen, ylen, zlen);
            BitMapParticle3D bitmap = par.getBitMapParticle();
            for (Point3D p : bitmap.getSurfacePoints()) {
                builder.addInnerPoint(p);
                builder.addSurfacePoint(p);
            }
            builder.setBitMapParticle(par.getBitMapParticle());
            List<Particle3D> surface = Collections.singletonList(builder.getParticle());
            double p = (double)(++i) / (double)n * 1000.0;
            this.sendEvent(eventType, (int)p);
            mapCuboids.put(par, surface);
        }
        return mapCuboids;
    }

    private List<Distance> calcAllDistances(Particle3D mito, Point3D point, Particle3D particleOfPoint, boolean isNeg, List<Distance> result) {
        AbstractListPoint3D listPoints = mito.getInnerPoints();
        if (result == null) {
            result = new ArrayList<Distance>(listPoints.size());
        } else {
            result.clear();
        }
        for (Point3D p : listPoints) {
            float d = p.distance(point);
            result.add(new Distance(p, point, particleOfPoint, mito, isNeg ? -d : d));
        }
        return result;
    }

    @Override
    List<Distance> calcDistance(Particle3D particle, Point3D point, Particle3D particleOfPoint, List<Distance> result) {
        if (point == null) {
            throw new NullPointerException("Point is null");
        }
        if (particle == null) {
            throw new NullPointerException("Particle is null");
        }
        return this.calcAllDistances(particle, point, particleOfPoint, particle.getBitMapParticle().isPointInParticle(point), result);
    }

    @Override
    AbstractListPoint3D getPresentationPointsA(AbstractListPoint3D points) {
        return points;
    }

    @Override
    protected void setProperties(Properties properties) {
    }
}

