/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.gui;

import fr.ens.transcriptome.corsen.Corsen;
import fr.ens.transcriptome.corsen.CorsenCore;
import fr.ens.transcriptome.corsen.ProgressEvent;
import fr.ens.transcriptome.corsen.Settings;
import fr.ens.transcriptome.corsen.UpdateStatus;
import fr.ens.transcriptome.corsen.calc.CorsenResult;
import fr.ens.transcriptome.corsen.util.Util;
import java.io.File;

public final class CLIGui {
    public static void main(String[] args) {
        Settings s = Corsen.getSettings();
        CorsenCore cc = new CorsenCore();
        cc.setSettings(s);
        cc.setUpdateStatus(new CLIUpdateStatus());
        if (Corsen.isBatchMode()) {
            cc.setMultipleFiles(true);
            cc.setDirFiles(new File(args[2]));
            s.setParticlesABatchPrefix(args[0]);
            s.setParticlesBBatchPrefix(args[1]);
        } else {
            cc.setMultipleFiles(false);
            cc.setParticlesAFile(new File(args[0]));
            cc.setParticlesBFile(new File(args[1]));
            cc.setResultFile(new File(args[2]));
        }
        Thread t = new Thread(cc);
        t.start();
        while (t.isAlive()) {
            Thread.yield();
        }
    }

    private CLIGui() {
    }

    private static final class CLIUpdateStatus
    implements UpdateStatus {
        private long timeStartCells;
        private long timeStartCell;

        private CLIUpdateStatus() {
        }

        public void endProcess(CorsenResult result) {
            long timeToDoACell = System.currentTimeMillis() - this.timeStartCell;
            System.out.println(result.getMinAnalyser());
            System.out.println("Process cell in " + Util.toTimeHumanReadable(timeToDoACell) + " (" + timeToDoACell + "ms).");
        }

        public void showError(String msg) {
            System.err.println(msg);
            System.exit(1);
        }

        public void showMessage(String msg) {
        }

        public void updateStatus(ProgressEvent e) {
            switch (e.getType()) {
                case START_CELL_EVENT: {
                    this.timeStartCell = System.currentTimeMillis();
                    System.out.println("Particle A file: " + e.getStringValue1());
                    System.out.println("Particle B file: " + e.getStringValue2());
                    break;
                }
                case START_CELLS_EVENT: {
                    this.timeStartCells = System.currentTimeMillis();
                    break;
                }
                case END_CELLS_SUCCESSFULL_EVENT: {
                    long timeToDoCells = System.currentTimeMillis() - this.timeStartCells;
                    System.out.println("Process all cells in " + Util.toTimeHumanReadable(timeToDoCells) + " (" + timeToDoCells + "ms).");
                    break;
                }
            }
        }

        public void moveToThread(Thread thread) {
        }

        public UpdateStatus chain() {
            return this;
        }

        public Thread newThread(Runnable runnable) {
            return new Thread(runnable);
        }
    }
}

