/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.gui;

import fr.ens.transcriptome.corsen.Corsen;
import fr.ens.transcriptome.corsen.ProgressEvent;
import fr.ens.transcriptome.corsen.Settings;
import fr.ens.transcriptome.corsen.UpdateStatus;
import fr.ens.transcriptome.corsen.calc.CorsenResult;
import fr.ens.transcriptome.corsen.calc.DistanceAnalyser;
import fr.ens.transcriptome.corsen.calc.DistancesCalculator;
import fr.ens.transcriptome.corsen.calc.ParticleType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class CorsenFakeGui {
    public static void main(String[] args) throws IOException {
        System.out.println("Java version: " + System.getProperty("java.version"));
        InputStream isA = Corsen.class.getResourceAsStream("/files/atp16cy3c1.par");
        InputStream isB = Corsen.class.getResourceAsStream("/files/mitocy35c1.par");
        Settings settings = new Settings();
        FakeGuiUpdateStatus updateStatus = new FakeGuiUpdateStatus();
        CorsenResult result = new CorsenResult(new File("atp16"), new File("mito"), isA, isB, null, settings, updateStatus);
        DistancesCalculator dc = new DistancesCalculator(result);
        dc.loadParticles();
        result.getParticlesA().setType(ParticleType.DECOMPOSITION);
        result.getParticlesB().setType(ParticleType.SURFACE);
        System.out.println("Messengers inner: " + result.getParticlesA().countParticlesInnerPoints() + " points.");
        System.out.println("Messengers surface: " + result.getParticlesA().countParticlesSurfacePoints() + " points.");
        System.out.println("Messengers image filename: " + result.getParticlesA().getImageFilename());
        System.out.println("Mitos inner: " + result.getParticlesB().countParticlesInnerPoints() + " points.");
        System.out.println("Mitos surface: " + result.getParticlesB().countParticlesSurfacePoints() + " points.");
        System.out.println("Mitos image filename: " + result.getParticlesB().getImageFilename());
        long startTime = System.currentTimeMillis();
        dc.calc();
        long endTime = System.currentTimeMillis();
        System.out.println("exec time: " + (endTime - startTime) + " ms.");
        DistanceAnalyser da = new DistanceAnalyser(result.getMinDistances());
        System.out.println("Median: " + da.getMedian());
        settings.setThreadNumber(2);
        startTime = System.currentTimeMillis();
        dc.calc();
        endTime = System.currentTimeMillis();
        System.out.println("exec time: " + (endTime - startTime) + " ms.");
        da = new DistanceAnalyser(result.getMinDistances());
        System.out.println("Median: " + da.getMedian());
    }

    private static final class FakeGuiUpdateStatus
    implements UpdateStatus {
        long last = -1L;

        private FakeGuiUpdateStatus() {
        }

        public void endProcess(CorsenResult result) {
            long current = System.currentTimeMillis();
            System.out.println("time: " + (current - this.last));
        }

        public void showError(String msg) {
            System.err.println("msg: " + msg);
        }

        public void showMessage(String msg) {
            System.out.println("msg: " + msg);
        }

        public void updateStatus(ProgressEvent e) {
            if ("".equals(e.getType().toString())) {
                return;
            }
            long current = System.currentTimeMillis();
            if (this.last != -1L) {
                System.out.println("time: " + (current - this.last));
            }
            this.last = current;
            System.out.println("Start: " + e.getType().toString());
        }

        public void moveToThread(Thread thread) {
        }

        public UpdateStatus chain() {
            return this;
        }

        public Thread newThread(Runnable runnable) {
            return new Thread(runnable);
        }
    }
}

