/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.gui.marchingcubes;

import fr.ens.transcriptome.corsen.gui.marchingcubes.MCCube;
import fr.ens.transcriptome.corsen.model.Particle3D;
import java.util.Iterator;
import java.util.List;
import javax.media.opengl.GL;
import javax.vecmath.Point3f;

public final class DrawMarchingCubes {
    public static final void showParticle3D(GL gl, Particle3D particle) {
        List<Point3f> triangles = MCCube.getTriangles(particle);
        gl.glBegin(4);
        Iterator<Point3f> iter = triangles.iterator();
        while (iter.hasNext()) {
            Point3f p1 = iter.next();
            Point3f p2 = iter.next();
            Point3f p3 = iter.next();
            Point3f n = DrawMarchingCubes.CalculateVectorNormal(p1, p2, p3);
            gl.glNormal3f(n.x, n.y, n.z);
            gl.glVertex3f(p1.x, p1.y, p1.z);
            gl.glNormal3f(n.x, n.y, n.z);
            gl.glVertex3f(p2.x, p2.y, p2.z);
            gl.glNormal3f(n.x, n.y, n.z);
            gl.glVertex3f(p3.x, p3.y, p3.z);
        }
        gl.glEnd();
    }

    private static final Point3f CalculateVectorNormal(Point3f fVert1, Point3f fVert2, Point3f fVert3) {
        float Qx = fVert2.x - fVert1.x;
        float Qy = fVert2.y - fVert1.y;
        float Qz = fVert2.z - fVert1.z;
        float Px = fVert3.x - fVert1.x;
        float Py = fVert3.y - fVert1.y;
        float Pz = fVert3.z - fVert1.z;
        Point3f result = new Point3f();
        result.x = Py * Qz - Pz * Qy;
        result.y = Pz * Qx - Px * Qz;
        result.z = Px * Qy - Py * Qx;
        return result;
    }
}

