/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.gui.qt;

import com.trolltech.qt.core.QObject;
import com.trolltech.qt.gui.QColor;
import com.trolltech.qt.gui.QColorDialog;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QMessageBox;
import com.trolltech.qt.gui.QPixmap;
import com.trolltech.qt.gui.QWidget;
import fr.ens.transcriptome.corsen.Settings;
import fr.ens.transcriptome.corsen.calc.CorsenHistoryResults;
import fr.ens.transcriptome.corsen.calc.ParticleType;
import fr.ens.transcriptome.corsen.gui.qt.CorsenQt;
import fr.ens.transcriptome.corsen.gui.qt.ParticleTypeProperties;
import fr.ens.transcriptome.corsen.gui.qt.Ui_ConfigureDialog;
import fr.ens.transcriptome.corsen.model.JavascriptParticles3DFilter;
import java.awt.Color;
import java.util.Properties;

public class CorsenConfigureQt {
    private CorsenQt mainWindow;
    private Settings settings;
    private QColor messengersColor;
    private QColor mitosColor;
    private QColor baryCentersColor;
    private QColor distancesColor;
    private QColor backgroundColor;
    private QColor legendColor;
    private Properties particlesAProporties;
    private Properties particlesBProporties;

    public void configureDialog() {
        int i;
        final Ui_ConfigureDialog dialogUi = new Ui_ConfigureDialog();
        final QDialog dialog = new QDialog((QWidget)this.mainWindow);
        dialogUi.setupUi(dialog);
        QObject o = new QObject(){

            public void changeMessengersColor() {
                QColor c = QColorDialog.getColor((QColor)CorsenConfigureQt.this.messengersColor);
                if (c.isValid()) {
                    CorsenConfigureQt.this.messengersColor = c;
                    dialogUi.particlesAColorPushButton.setIcon(CorsenConfigureQt.this.createIcon(c));
                }
            }

            public void changeMitosColor() {
                QColor c = QColorDialog.getColor((QColor)CorsenConfigureQt.this.mitosColor);
                if (c.isValid()) {
                    CorsenConfigureQt.this.mitosColor = c;
                    dialogUi.particlesBColorPushButton.setIcon(CorsenConfigureQt.this.createIcon(c));
                }
            }

            public void changeBaryCentersColor() {
                QColor c = QColorDialog.getColor((QColor)CorsenConfigureQt.this.baryCentersColor);
                if (c.isValid()) {
                    CorsenConfigureQt.this.baryCentersColor = c;
                    dialogUi.barycentersColorPushButton.setIcon(CorsenConfigureQt.this.createIcon(c));
                }
            }

            public void changeDistancesColor() {
                QColor c = QColorDialog.getColor((QColor)CorsenConfigureQt.this.distancesColor);
                if (c.isValid()) {
                    CorsenConfigureQt.this.distancesColor = c;
                    dialogUi.distancesColorPushButton.setIcon(CorsenConfigureQt.this.createIcon(c));
                }
            }

            public void changeBackgroundColor() {
                QColor c = QColorDialog.getColor((QColor)CorsenConfigureQt.this.backgroundColor);
                if (c.isValid()) {
                    CorsenConfigureQt.this.backgroundColor = c;
                    dialogUi.backgroundColorPushButton.setIcon(CorsenConfigureQt.this.createIcon(c));
                }
            }

            public void changeLegendColor() {
                QColor c = QColorDialog.getColor((QColor)CorsenConfigureQt.this.legendColor);
                if (c.isValid()) {
                    CorsenConfigureQt.this.legendColor = c;
                    dialogUi.legendColorPushButton.setIcon(CorsenConfigureQt.this.createIcon(c));
                }
            }

            public void enableCustomThread() {
                dialogUi.customThreadSpinBox.setEnabled(true);
            }

            public void disableCustomThread() {
                dialogUi.customThreadSpinBox.setEnabled(false);
            }

            public void dialogParticleAProperties() {
                ParticleType type = ParticleType.getParticleType(dialogUi.particleATypeComboBox.currentText());
                ParticleTypeProperties ptp = new ParticleTypeProperties(dialog, type, CorsenConfigureQt.this.particlesAProporties);
                ptp.configureDialog();
                CorsenConfigureQt.this.particlesAProporties = ptp.getProperties();
            }

            public void dialogParticleBProperties() {
                ParticleType type = ParticleType.getParticleType(dialogUi.particleBTypeComboBox.currentText());
                ParticleTypeProperties ptp = new ParticleTypeProperties(dialog, type, CorsenConfigureQt.this.particlesBProporties);
                ptp.configureDialog();
                CorsenConfigureQt.this.particlesBProporties = ptp.getProperties();
            }
        };
        Settings s = this.settings;
        ParticleType[] particleTypes = ParticleType.values();
        for (i = 0; i < particleTypes.length; ++i) {
            dialogUi.particleATypeComboBox.addItem(particleTypes[i].toString());
            dialogUi.particleBTypeComboBox.addItem(particleTypes[i].toString());
        }
        dialogUi.particleANameLineEdit.setText(s.getParticlesAName());
        dialogUi.particleATypeComboBox.setCurrentIndex(s.getParticlesAType().ordinal());
        dialogUi.particleABatchPrefixLineEdit.setText(s.getParticlesABatchPrefix());
        dialogUi.particleAFilterLineEdit.setText(s.getParticlesAFilterExpression());
        dialogUi.particleAPropertiesPushButton.clicked.connect((Object)o, "dialogParticleAProperties()");
        dialogUi.particleBNameLineEdit.setText(s.getParticlesBName());
        dialogUi.particleBTypeComboBox.setCurrentIndex(s.getParticlesBType().ordinal());
        dialogUi.particleBBatchPrefixLineEdit.setText(s.getParticlesBBatchPrefix());
        dialogUi.particleBFilterLineEdit.setText(s.getParticlesBFilterExpression());
        dialogUi.particleBPropertiesPushButton.clicked.connect((Object)o, "dialogParticleBProperties()");
        dialogUi.zFactorLineEdit.setText("" + s.getZFactor());
        dialogUi.factorLineEdit.setText("" + s.getFactor());
        if (s.getUnit() != null) {
            dialogUi.unitLineEdit.setText(s.getUnit().trim());
        }
        dialogUi.customThreadRadioButton.toggled.connect((Object)o, "enableCustomThread()");
        dialogUi.automaticThreadRadioButton.toggled.connect((Object)o, "disableCustomThread()");
        dialogUi.noThreadRadioButton.toggled.connect((Object)o, "disableCustomThread()");
        dialogUi.customThreadSpinBox.setEnabled(false);
        switch (s.getThreadNumber()) {
            case -1: {
                dialogUi.noThreadRadioButton.setChecked(true);
                break;
            }
            case 0: {
                dialogUi.automaticThreadRadioButton.setChecked(true);
                break;
            }
            default: {
                i = s.getThreadNumber();
                if (i > 0) {
                    dialogUi.customThreadRadioButton.setChecked(true);
                    dialogUi.customThreadSpinBox.setValue(i);
                    break;
                }
                dialogUi.automaticThreadRadioButton.setChecked(true);
            }
        }
        dialogUi.dataFileCheckBox.setChecked(s.isSaveDataFile());
        dialogUi.ivFileCheckBox.setChecked(s.isSaveIVFile());
        dialogUi.resultCheckBox.setChecked(s.isSaveResultsFile());
        dialogUi.clearHistoryCheckBox.setChecked(s.isClearHistoryWhenLaunchingNewCalc());
        dialogUi.resultCheckBox.setHidden(true);
        dialogUi.particlesAColorPushButton.clicked.connect((Object)o, "changeMessengersColor()");
        dialogUi.particlesBColorPushButton.clicked.connect((Object)o, "changeMitosColor()");
        dialogUi.barycentersColorPushButton.clicked.connect((Object)o, "changeBaryCentersColor()");
        dialogUi.distancesColorPushButton.clicked.connect((Object)o, "changeDistancesColor()");
        dialogUi.backgroundColorPushButton.clicked.connect((Object)o, "changeBackgroundColor()");
        dialogUi.legendColorPushButton.clicked.connect((Object)o, "changeLegendColor()");
        dialogUi.particlesATranscparencySpinBox.setValue(s.getParticlesATransparency());
        dialogUi.particlesBTranscparencySpinBox.setValue(s.getParticlesBTransparency());
        dialogUi.showDistancesNegativeCheckBox.setChecked(s.isVisualizationShowNegativeDistances());
        dialogUi.showParticlesADifferentColorCcheckBox.setChecked(s.isVisualisationParticlesAInDifferentsColor());
        dialogUi.showParticlesBDifferentColorCcheckBox.setChecked(s.isVisualisationParticlesBInDifferentsColor());
        this.messengersColor = this.colorToQColor(s.getColorParticlesA());
        this.mitosColor = this.colorToQColor(s.getColorParticlesB());
        this.distancesColor = this.colorToQColor(s.getColorDistances());
        this.baryCentersColor = this.colorToQColor(s.getColorBaryCenters());
        this.backgroundColor = this.colorToQColor(s.getColorBackground());
        this.legendColor = this.colorToQColor(s.getColorLegend());
        dialogUi.particlesAColorPushButton.setIcon(this.createIcon(this.messengersColor));
        dialogUi.particlesBColorPushButton.setIcon(this.createIcon(this.mitosColor));
        dialogUi.distancesColorPushButton.setIcon(this.createIcon(this.distancesColor));
        dialogUi.barycentersColorPushButton.setIcon(this.createIcon(this.baryCentersColor));
        dialogUi.backgroundColorPushButton.setIcon(this.createIcon(this.backgroundColor));
        dialogUi.legendColorPushButton.setIcon(this.createIcon(this.legendColor));
        dialogUi.histoResultClassesNumberSpinBox.setValue(s.getHistogramResultsNumberClasses());
        dialogUi.histoHistoryClassesNumberSpinBox.setValue(s.getHistogramHistoryNumberClasses());
        dialogUi.customExpressionLineEdit.setText(s.getCustomHistoryExpression());
        if (dialog.exec() == QDialog.DialogCode.Accepted.value()) {
            String unitValue;
            try {
                s.setZFactor(Float.parseFloat(dialogUi.zFactorLineEdit.text().trim()));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                s.setFactor(Float.parseFloat(dialogUi.factorLineEdit.text().trim()));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (dialogUi.unitLineEdit.text() != null && !(unitValue = dialogUi.unitLineEdit.text().trim()).equals("")) {
                s.setUnit(unitValue);
            }
            s.setParticlesAName(dialogUi.particleANameLineEdit.text());
            s.setParticlesAType(ParticleType.getParticleType(dialogUi.particleATypeComboBox.currentText()));
            s.setParticlesABatchPrefix(dialogUi.particleABatchPrefixLineEdit.text());
            s.setParticlesAProperties(this.particlesAProporties);
            s.setParticlesBName(dialogUi.particleBNameLineEdit.text());
            s.setParticlesBType(ParticleType.getParticleType(dialogUi.particleBTypeComboBox.currentText()));
            s.setParticlesBBatchPrefix(dialogUi.particleBBatchPrefixLineEdit.text());
            s.setParticlesBProperties(this.particlesBProporties);
            if (dialogUi.noThreadRadioButton.isChecked()) {
                s.setThreadNumber(-1);
            } else if (dialogUi.automaticThreadRadioButton.isChecked()) {
                s.setThreadNumber(0);
            } else {
                s.setThreadNumber(dialogUi.customThreadSpinBox.value());
            }
            s.setSaveDataFile(dialogUi.dataFileCheckBox.isChecked());
            s.setSaveIVFile(dialogUi.ivFileCheckBox.isChecked());
            s.setSaveResultFile(dialogUi.resultCheckBox.isChecked());
            s.setClearHistoryWhenLaunchNewCalc(dialogUi.clearHistoryCheckBox.isChecked());
            s.setVisualizationShowNegativeDistances(dialogUi.showDistancesNegativeCheckBox.isChecked());
            s.setVisualisationParticlesAInDifferentsColors(dialogUi.showParticlesADifferentColorCcheckBox.isChecked());
            s.setVisualisationParticlesBInDifferentsColors(dialogUi.showParticlesBDifferentColorCcheckBox.isChecked());
            s.setParticlesATransparency(dialogUi.particlesATranscparencySpinBox.value());
            s.setParticlesBTransparency(dialogUi.particlesBTranscparencySpinBox.value());
            s.setColorParticlesA(this.qColorToColor(this.messengersColor));
            s.setColorParticlesB(this.qColorToColor(this.mitosColor));
            s.setColorBaryCenters(this.qColorToColor(this.baryCentersColor));
            s.setColorDistances(this.qColorToColor(this.distancesColor));
            s.setColorBackground(this.qColorToColor(this.backgroundColor));
            s.setColorLegend(this.qColorToColor(this.legendColor));
            int histoResultClassesNumber = dialogUi.histoResultClassesNumberSpinBox.value();
            int histoHistoryClassesNumber = dialogUi.histoHistoryClassesNumberSpinBox.value();
            if (histoResultClassesNumber != s.getHistogramResultsNumberClasses()) {
                s.setHistogramResultsNumberClasses(histoResultClassesNumber);
                this.mainWindow.redrawResultGraph();
            }
            if (histoHistoryClassesNumber != s.getHistogramHistoryNumberClasses()) {
                s.setHistogramHistoryNumberClasses(histoHistoryClassesNumber);
                this.mainWindow.redrawHistoryGraph();
            }
            String customExpression = dialogUi.customExpressionLineEdit.text();
            if (!CorsenHistoryResults.getCorsenHistoryResults().setCustomExpression(customExpression)) {
                QMessageBox.warning((QWidget)this.mainWindow, (String)"Corsen", (String)"Warning: Your custom expression is not valid.");
            } else {
                s.setCustomHistoryExpression(customExpression);
            }
            String particleAFilter = dialogUi.particleAFilterLineEdit.text();
            if (JavascriptParticles3DFilter.createFilter(particleAFilter) != null) {
                s.setParticlesAFilterExpression(particleAFilter);
            } else {
                QMessageBox.warning((QWidget)this.mainWindow, (String)"Corsen", (String)"Warning: Your filter for particles A is not valid.");
            }
            String particleBFilter = dialogUi.particleBFilterLineEdit.text();
            if (JavascriptParticles3DFilter.createFilter(particleBFilter) != null) {
                s.setParticlesBFilterExpression(particleBFilter);
            } else {
                QMessageBox.warning((QWidget)this.mainWindow, (String)"Corsen", (String)"Warning: Your filter for particles B is not valid.");
            }
        }
    }

    private QColor colorToQColor(Color color) {
        if (color == null) {
            return null;
        }
        return QColor.fromRgb((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue(), (int)color.getAlpha());
    }

    private Color qColorToColor(QColor color) {
        if (color == null) {
            return null;
        }
        return new Color(color.red(), color.green(), color.blue(), color.alpha());
    }

    private QIcon createIcon(Color color) {
        if (color == null) {
            return null;
        }
        return this.createIcon(this.colorToQColor(color));
    }

    private QIcon createIcon(QColor color) {
        if (color == null) {
            return null;
        }
        QPixmap pixmap = new QPixmap(10, 10);
        pixmap.fill(color);
        return new QIcon(pixmap);
    }

    CorsenConfigureQt(CorsenQt mainWindow, Settings settings) {
        this.mainWindow = mainWindow;
        this.settings = settings;
        this.particlesAProporties = settings.getParticlesAProperties();
        this.particlesBProporties = settings.getParticlesBProperties();
    }
}

