/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.gui.qt;

import com.sun.opengl.util.GLUT;
import com.trolltech.qt.gui.QColor;
import com.trolltech.qt.opengl.QGLWidget;
import fr.ens.transcriptome.corsen.calc.Distance;
import fr.ens.transcriptome.corsen.gui.marchingcubes.DrawMarchingCubes;
import fr.ens.transcriptome.corsen.model.AbstractListPoint3D;
import fr.ens.transcriptome.corsen.model.BitMapParticle3D;
import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.model.Particles3D;
import fr.ens.transcriptome.corsen.model.Point3D;
import fr.ens.transcriptome.corsen.model.SimplePoint3DImpl;
import java.awt.Color;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorsenGL {
    public static final Color COLOR_CYAN = Color.cyan;
    public static final Color COLOR_GREEN = Color.green;
    public static final Color COLOR_RED = Color.red;
    public static final Color COLOR_WHITE = Color.white;
    public static final Color COLOR_BLACK = Color.black;
    protected float xScale = 1.0f;
    protected float yScale = 1.0f;
    protected float zScale = 1.0f;
    private static final float LEN = 0.5f;
    private GL gl;
    private GLUT glut;
    private GLU glu;
    private QGLWidget widgetGL;
    private static final FloatBuffer no_mat = FloatBuffer.wrap(new float[]{0.06f, 0.06f, 0.06f, 1.0f});
    private static final FloatBuffer no_shininess = FloatBuffer.wrap(new float[]{0.0f});
    private static final FloatBuffer shininess = FloatBuffer.wrap(new float[]{1.0f});
    private static final FloatBuffer mat_emission = FloatBuffer.wrap(new float[]{1.0f, 1.0f, 1.0f, 0.0f});
    private static float[][] boxVertices;
    private static final float[][] boxNormals;
    private static final int[][] boxFaces;

    public void drawAxis() {
        SimplePoint3DImpl o = new SimplePoint3DImpl(0.0f, 0.0f, 0.0f);
        SimplePoint3DImpl x = new SimplePoint3DImpl(10.0f, 0.0f, 0.0f);
        SimplePoint3DImpl y = new SimplePoint3DImpl(0.0f, 10.0f, 0.0f);
        SimplePoint3DImpl z = new SimplePoint3DImpl(0.0f, 0.0f, 10.0f);
        this.drawLine3D(o, x, COLOR_WHITE);
        this.drawLine3D(o, y, COLOR_WHITE);
        this.drawLine3D(o, z, COLOR_WHITE);
    }

    public void writeDistances(Map<Particle3D, Distance> distances, Color color) throws IOException {
        if (distances != null) {
            Iterator<Particle3D> it = distances.keySet().iterator();
            while (it.hasNext()) {
                Distance d = distances.get(it.next());
                this.drawLine3D(d.getPointA(), d.getPointB(), color);
            }
        }
    }

    public void drawParticle(Particle3D particle, Color color, boolean barycentre, Color colorBaryCentre, float alpha) {
        if (particle == null) {
            return;
        }
        this.xScale = particle.getPixelWidth();
        this.yScale = particle.getPixelHeight();
        this.zScale = particle.getPixelDepth();
        this.drawSurfaceParticle3D(particle, color, alpha);
    }

    public void drawBarycenter(Particles3D particles, Color color) {
        if (particles == null) {
            return;
        }
        for (Particle3D p : particles.getParticles()) {
            this.drawPoint3D(p.getInnerPoints().getBarycenter(), color, 0.25f);
        }
    }

    public void drawParticles(Particles3D particles, Color color, boolean barycentre, Color colorBaryCentre, boolean randomColor, float alpha) {
        if (particles == null) {
            return;
        }
        Color c = color;
        Random ran = new Random(0L);
        for (Particle3D par : particles.getParticles()) {
            if (randomColor) {
                c = new Color(ran.nextInt(255), ran.nextInt(255), ran.nextInt(255));
            }
            this.drawParticle(par, c, barycentre, colorBaryCentre, alpha);
        }
    }

    public void drawParticleBitmap(BitMapParticle3D bitmap, Color c) {
        int lenX = bitmap.getXLen();
        int lenY = bitmap.getYLen();
        int lenZ = bitmap.getZLen();
        bitmap.getX0();
        for (int i = 0; i < lenX; ++i) {
            for (int j = 0; j < lenY; ++j) {
                for (int k = 0; k < lenZ; ++k) {
                    if (bitmap.isParticleInnerPoint(i, j, k)) {
                        this.drawPoint3D(new SimplePoint3DImpl((float)i + bitmap.getX0(), (float)j + bitmap.getY0(), (float)k + bitmap.getZ0()), c, 0.5f);
                        continue;
                    }
                    if (!bitmap.isParticleSurfacePoint(i, j, k)) continue;
                    this.drawPoint3D(new SimplePoint3DImpl((float)i + bitmap.getX0(), (float)j + bitmap.getY0(), (float)k + bitmap.getZ0()), c, 0.5f);
                }
            }
        }
    }

    public static Color getLowColor(Color c) {
        if (c == null) {
            return null;
        }
        float factor = 0.999f;
        int r = (int)((float)c.getRed() * 0.999f);
        int g = (int)((float)c.getGreen() * 0.999f);
        int b = (int)((float)c.getBlue() * 0.999f);
        return new Color(r, g, b, c.getAlpha());
    }

    public static Color inverseColor(Color c) {
        if (c == null) {
            return null;
        }
        return new Color(255 - c.getRed(), 255 - c.getGreen(), 255 - c.getBlue(), c.getAlpha());
    }

    public void drawPoint3D(Point3D point, Color color, float size) {
        if (point == null) {
            return;
        }
        this.solidCube(size, point, color);
    }

    public void drawPoints3D(AbstractListPoint3D points, Color color, float size) {
        if (points == null) {
            return;
        }
        this.gl.glPolygonMode(1032, 6912);
        this.setGLColor(color);
        this.gl.glBegin(0);
        int n = points.size();
        for (int i = 0; i < n; ++i) {
            Point3D p = (Point3D)points.get(i);
            this.solidCube(size, p, color);
        }
        this.gl.glEnd();
    }

    public void drawPolygon3D(AbstractListPoint3D points, Color color) {
        if (points == null) {
            return;
        }
        this.gl.glPolygonMode(1032, 6913);
        this.setGLColor(color);
        this.gl.glBegin(9);
        int n = points.size();
        for (int i = 0; i < n; ++i) {
            Point3D p = (Point3D)points.get(i);
            this.gl.glVertex3f(p.getX(), p.getY(), p.getZ());
        }
        this.gl.glEnd();
    }

    public void drawLine3D(Point3D a, Point3D b, Color c) {
        if (a == null || b == null) {
            return;
        }
        FloatBuffer mat_diffuse = FloatBuffer.wrap(new float[]{(float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, 1.0f});
        this.gl.glMaterialfv(1028, 4608, mat_diffuse);
        this.gl.glMaterialfv(1028, 4609, mat_diffuse);
        this.gl.glMaterialfv(1028, 4610, mat_diffuse);
        this.gl.glMaterialfv(1028, 5633, shininess);
        this.gl.glMaterialfv(1028, 5632, mat_diffuse);
        this.gl.glColor4f((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, 1.0f);
        this.gl.glBegin(1);
        this.gl.glVertex3f(a.getX(), a.getY(), a.getZ());
        this.gl.glVertex3f(b.getX(), b.getY(), b.getZ());
        this.gl.glEnd();
    }

    public void text3D(Point3D p, String text, Color c) {
        this.gl.glPushMatrix();
        this.gl.glColor4f((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, 1.0f);
        this.widgetGL.renderText(5, 15, text);
        this.gl.glPopMatrix();
    }

    public void drawDistances(Map<Particle3D, Distance> distances, Color color, boolean showNegativesDistances) {
        if (distances == null) {
            return;
        }
        for (Map.Entry<Particle3D, Distance> e : distances.entrySet()) {
            Distance d = e.getValue();
            if (showNegativesDistances) {
                if (d.getDistance() < 0.0f) {
                    this.drawLine3D(d.getPointA(), d.getPointB(), CorsenGL.inverseColor(color));
                    continue;
                }
                this.drawLine3D(d.getPointA(), d.getPointB(), color);
                continue;
            }
            this.drawLine3D(d.getPointA(), d.getPointB(), color);
        }
    }

    private final void setGLColor(Color color) {
        if (color == null) {
            return;
        }
        this.widgetGL.qglColor(new QColor(color.getRed(), color.getGreen(), color.getRed(), color.getAlpha()));
    }

    private void drawDiamondPoint(float x, float y, float z, float d, Color color) {
        FloatBuffer no_mat = FloatBuffer.wrap(new float[]{0.0f, 0.0f, 0.0f, 1.0f});
        FloatBuffer mat_diffuse = FloatBuffer.wrap(new float[]{color.getRed(), color.getGreen(), color.getBlue(), 1.0f});
        FloatBuffer no_shininess = FloatBuffer.wrap(new float[]{0.0f});
        this.gl.glMaterialfv(1028, 4608, no_mat);
        this.gl.glMaterialfv(1028, 4609, mat_diffuse);
        this.gl.glMaterialfv(1028, 4610, no_mat);
        this.gl.glMaterialfv(1028, 5633, no_shininess);
        this.gl.glMaterialfv(1028, 5632, no_mat);
        this.gl.glPolygonMode(1032, 6914);
        this.gl.glBegin(4);
        this.gl.glVertex3d((double)(x - d), (double)y, (double)z);
        this.gl.glVertex3d((double)x, (double)(y + d), (double)z);
        this.gl.glVertex3d((double)x, (double)y, (double)(z + d));
        this.gl.glVertex3d((double)x, (double)(y + d), (double)z);
        this.gl.glVertex3d((double)(x + d), (double)y, (double)z);
        this.gl.glVertex3d((double)x, (double)y, (double)(z + d));
        this.gl.glVertex3d((double)(x + d), (double)y, (double)z);
        this.gl.glVertex3d((double)x, (double)(y - d), (double)z);
        this.gl.glVertex3d((double)x, (double)y, (double)(z + d));
        this.gl.glVertex3d((double)x, (double)(y - d), (double)z);
        this.gl.glVertex3d((double)(x - d), (double)y, (double)z);
        this.gl.glVertex3d((double)x, (double)y, (double)(z + d));
        this.gl.glVertex3d((double)(x - d), (double)y, (double)z);
        this.gl.glVertex3d((double)x, (double)(y + d), (double)z);
        this.gl.glVertex3d((double)x, (double)y, (double)(z - d));
        this.gl.glVertex3d((double)x, (double)(y + d), (double)z);
        this.gl.glVertex3d((double)(x + d), (double)y, (double)z);
        this.gl.glVertex3d((double)x, (double)y, (double)(z - d));
        this.gl.glVertex3d((double)(x + d), (double)y, (double)z);
        this.gl.glVertex3d((double)x, (double)(y - d), (double)z);
        this.gl.glVertex3d((double)x, (double)y, (double)(z - d));
        this.gl.glVertex3d((double)x, (double)(y - d), (double)z);
        this.gl.glVertex3d((double)(x - d), (double)y, (double)z);
        this.gl.glVertex3d((double)x, (double)y, (double)(z - d));
        this.gl.glEnd();
    }

    private void drawDiamondPoint(float x, float y, float z, float d) {
    }

    public void solidCube(float size, Point3D p, Color c) {
        FloatBuffer mat_diffuse = FloatBuffer.wrap(new float[]{(float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, 0.5f});
        this.gl.glPolygonMode(1032, 6914);
        this.gl.glPushMatrix();
        this.gl.glTranslatef(p.getX(), p.getY(), p.getZ());
        this.gl.glScalef(this.xScale, this.yScale, this.zScale);
        this.gl.glMaterialfv(1028, 4608, no_mat);
        this.gl.glMaterialfv(1028, 4609, mat_diffuse);
        this.gl.glMaterialfv(1028, 4610, no_mat);
        this.gl.glMaterialfv(1028, 5633, no_shininess);
        this.gl.glMaterialfv(1028, 5632, no_mat);
        this.glu.gluSphere(this.glu.gluNewQuadric(), (double)size, 4, 4);
        this.gl.glPopMatrix();
    }

    private void solidCube(float size, float x, float y, float z, Color c) {
        this.gl.glPolygonMode(1032, 6914);
        this.drawBox(GLU.getCurrentGL(), size, 7, x, y, z, c);
    }

    private void drawBox(GL gl, float size, int type, float x, float y, float z, Color c) {
        Object v;
        if (boxVertices == null) {
            v = new float[8][];
            for (int i = 0; i < 8; ++i) {
                v[i] = new float[3];
            }
            v[3][0] = -0.5f;
            v[2][0] = -0.5f;
            v[1][0] = -0.5f;
            v[0][0] = -0.5f;
            v[7][0] = 0.5f;
            v[6][0] = 0.5f;
            v[5][0] = 0.5f;
            v[4][0] = 0.5f;
            v[5][1] = -0.5f;
            v[4][1] = -0.5f;
            v[1][1] = -0.5f;
            v[0][1] = -0.5f;
            v[7][1] = 0.5f;
            v[6][1] = 0.5f;
            v[3][1] = 0.5f;
            v[2][1] = 0.5f;
            v[7][2] = -0.5f;
            v[4][2] = -0.5f;
            v[3][2] = -0.5f;
            v[0][2] = -0.5f;
            v[6][2] = 0.5f;
            v[5][2] = 0.5f;
            v[2][2] = 0.5f;
            v[1][2] = 0.5f;
            boxVertices = v;
        }
        v = boxVertices;
        float[][] n = boxNormals;
        int[][] faces = boxFaces;
        FloatBuffer mat_diffuse = FloatBuffer.wrap(new float[]{c.getRed(), c.getGreen(), c.getBlue(), 1.0f});
        for (int i = 5; i >= 0; --i) {
            gl.glBegin(type);
            gl.glMaterialfv(1028, 4608, no_mat);
            gl.glMaterialfv(1028, 4609, mat_diffuse);
            gl.glMaterialfv(1028, 4610, no_mat);
            gl.glMaterialfv(1028, 5633, no_shininess);
            gl.glMaterialfv(1028, 5632, no_mat);
            gl.glNormal3fv(n[i], 0);
            float[] vt = v[faces[i][0]];
            gl.glVertex3f(vt[0] * size + x, vt[1] * size + y, vt[2] * size + z);
            vt = v[faces[i][1]];
            gl.glVertex3f(vt[0] * size + x, vt[1] * size + y, vt[2] * size + z);
            vt = v[faces[i][2]];
            gl.glVertex3f(vt[0] * size + x, vt[1] * size + y, vt[2] * size + z);
            vt = v[faces[i][3]];
            gl.glVertex3f(vt[0] * size + x, vt[1] * size + y, vt[2] * size + z);
            gl.glEnd();
        }
    }

    private void drawSurfaceParticle3DWithMarchingCubes(Particle3D particle, Color c, float alpha) {
        if (particle == null || c == null) {
            return;
        }
        this.gl.glPushMatrix();
        this.gl.glEnable(3042);
        this.gl.glBlendFunc(770, 771);
        FloatBuffer mat_diffuse = FloatBuffer.wrap(new float[]{(float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, alpha});
        this.gl.glMaterialfv(1028, 4608, no_mat);
        this.gl.glMaterialfv(1028, 4609, mat_diffuse);
        this.gl.glMaterialfv(1028, 4610, no_mat);
        this.gl.glMaterialfv(1028, 5633, no_shininess);
        this.gl.glMaterialfv(1028, 5632, no_mat);
        BitMapParticle3D bitmap = particle.getBitMapParticle();
        this.gl.glTranslatef(bitmap.getX0() * particle.getPixelWidth(), bitmap.getY0() * particle.getPixelHeight(), bitmap.getZ0() * particle.getPixelDepth());
        DrawMarchingCubes.showParticle3D(this.gl, particle);
        this.gl.glDisable(3042);
        this.gl.glPopMatrix();
        this.gl.glFlush();
    }

    public void drawSurfaceParticle3D(Particle3D particle, Color color, float alpha) {
        this.drawSurfaceParticle3DWithMarchingCubes(particle, color, alpha);
    }

    public void drawSurfaceParticle3DWithCubes(Particle3D particle, Color color) {
        if (particle == null || color == null) {
            return;
        }
        BitMapParticle3D bpar = particle.getBitMapParticle();
        AbstractListPoint3D points = particle.getInnerPoints();
        float alpha = 1.0f;
        for (Point3D p : points) {
            int z;
            int y;
            if (!bpar.isParticleSurfacePoint(p)) continue;
            int x = bpar.getXBitmapCoordinate(p.getX());
            if (!bpar.isParticlePoint(x, y = bpar.getYBitmapCoordinate(p.getY()), (z = bpar.getZBitmapCoordinate(p.getZ())) - 1)) {
                this.makeObjectSquare(x, y, z, 0.0f, 0.0f, 1.0f, 0.0f, color, 1.0f);
            }
            if (!bpar.isParticlePoint(x, y, z + 1)) {
                this.makeObjectSquare(x, y, z, 180.0f, 0.0f, 1.0f, 0.0f, color, 1.0f);
            }
            if (!bpar.isParticlePoint(x + 1, y, z)) {
                this.makeObjectSquare(x, y, z, 270.0f, 0.0f, 1.0f, 0.0f, color, 1.0f);
            }
            if (!bpar.isParticlePoint(x - 1, y, z)) {
                this.makeObjectSquare(x, y, z, 90.0f, 0.0f, 1.0f, 0.0f, color, 1.0f);
            }
            if (!bpar.isParticlePoint(x, y + 1, z)) {
                this.makeObjectSquare(x, y, z, 90.0f, 1.0f, 0.0f, 0.0f, color, 1.0f);
            }
            if (bpar.isParticlePoint(x, y - 1, z)) continue;
            this.makeObjectSquare(x, y, z, 270.0f, 1.0f, 0.0f, 0.0f, color, 1.0f);
        }
    }

    private void makeObjectSquare(float x, float y, float z, float angle, float xr, float yr, float zr, Color c, float alpha) {
        if (this.gl == null) {
            return;
        }
        GL gl = this.gl;
        gl.glPushMatrix();
        this.gl.glPolygonMode(1032, 6914);
        this.gl.glEnable(3042);
        this.gl.glBlendFunc(770, 771);
        FloatBuffer mat_diffuse = FloatBuffer.wrap(new float[]{(float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, alpha});
        FloatBuffer no_mat = FloatBuffer.wrap(new float[]{0.0f, 0.0f, 0.0f, 1.0f});
        FloatBuffer no_shininess = FloatBuffer.wrap(new float[]{0.0f});
        FloatBuffer mat_emission = FloatBuffer.wrap(new float[]{1.0f, 1.0f, 1.0f, 0.0f});
        gl.glMaterialfv(1028, 4608, no_mat);
        gl.glMaterialfv(1028, 4609, mat_diffuse);
        gl.glMaterialfv(1028, 4610, no_mat);
        gl.glMaterialfv(1028, 5633, no_shininess);
        gl.glMaterialfv(1028, 5632, no_mat);
        gl.glScalef(this.xScale, this.yScale, this.zScale);
        gl.glTranslatef(x, y, z);
        gl.glRotatef(angle, xr, yr, zr);
        gl.glBegin(9);
        gl.glVertex3f(-0.5f, -0.5f, -0.5f);
        gl.glVertex3f(-0.5f, 0.5f, -0.5f);
        gl.glVertex3f(0.5f, 0.5f, -0.5f);
        gl.glVertex3f(0.5f, -0.5f, -0.5f);
        gl.glEnd();
        this.gl.glDisable(3042);
        gl.glPopMatrix();
        gl.glFlush();
    }

    public CorsenGL(GL gl, QGLWidget widgetGL) {
        this.gl = gl;
        this.widgetGL = widgetGL;
        this.glut = new GLUT();
        this.glu = new GLU();
    }

    static {
        boxNormals = new float[][]{{-1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, -1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}, {0.0f, 0.0f, -1.0f}};
        boxFaces = new int[][]{{0, 1, 2, 3}, {3, 2, 6, 7}, {7, 6, 5, 4}, {4, 5, 1, 0}, {5, 6, 2, 1}, {7, 4, 0, 3}};
    }
}

