/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.gui.qt;

import com.trolltech.qt.QSignalEmitter;
import com.trolltech.qt.QThread;
import com.trolltech.qt.QtInfo;
import com.trolltech.qt.core.QLocale;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.QRect;
import com.trolltech.qt.core.QUrl;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QCloseEvent;
import com.trolltech.qt.gui.QDesktopServices;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QFileDialog;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QImage;
import com.trolltech.qt.gui.QMainWindow;
import com.trolltech.qt.gui.QMessageBox;
import com.trolltech.qt.gui.QPixmap;
import com.trolltech.qt.gui.QWidget;
import fr.ens.transcriptome.corsen.Corsen;
import fr.ens.transcriptome.corsen.CorsenCore;
import fr.ens.transcriptome.corsen.CorsenResultWriter;
import fr.ens.transcriptome.corsen.Globals;
import fr.ens.transcriptome.corsen.ProgressEvent;
import fr.ens.transcriptome.corsen.Settings;
import fr.ens.transcriptome.corsen.UpdateStatus;
import fr.ens.transcriptome.corsen.calc.CorsenHistoryResults;
import fr.ens.transcriptome.corsen.calc.CorsenResult;
import fr.ens.transcriptome.corsen.calc.DistancesCalculator;
import fr.ens.transcriptome.corsen.gui.qt.CorsenConfigureQt;
import fr.ens.transcriptome.corsen.gui.qt.DataModelQt;
import fr.ens.transcriptome.corsen.gui.qt.FilterDialog;
import fr.ens.transcriptome.corsen.gui.qt.QtUtil;
import fr.ens.transcriptome.corsen.gui.qt.Ui_CorsenMainWindow;
import fr.ens.transcriptome.corsen.gui.qt.ViewOGL;
import fr.ens.transcriptome.corsen.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;

public class CorsenQt
extends QMainWindow {
    private static Logger logger = Logger.getLogger("Corsen");
    private static final int PATH_STRING_MAX_LEN = 50;
    private static CorsenQt mainw;
    private Ui_CorsenMainWindow mainWindowUi = new Ui_CorsenMainWindow();
    private DataModelQt models = new DataModelQt();
    private final StatusInfo status = new StatusInfo();
    private Settings settings = new Settings();
    private String lastDir = Globals.DEBUG_HOME_DIR ? "/home/jourdren/Desktop/atp16" : "";
    private String particlesAPath = "";
    private String particlesBPath = "";
    private String directoryPath = "";
    private boolean refreshHistoryGraphics;

    private void openWebsite() {
        QUrl url = new QUrl();
        url.setPath(Globals.WEBSITE_URL);
        QDesktopServices.openUrl((QUrl)url);
    }

    private void openHandbook() {
        QUrl url = new QUrl();
        url.setPath(Globals.HANDBOOK_URL);
        QDesktopServices.openUrl((QUrl)url);
    }

    private void reportBug() {
        QUrl url = new QUrl();
        url.setPath("http://code.google.com/p/corsen/issues/list");
        QDesktopServices.openUrl((QUrl)url);
    }

    void clearHistoryResults() {
        CorsenHistoryResults.getCorsenHistoryResults().clear();
        this.resultsHistoryChanged();
    }

    private void saveHistoryResults() {
        String fileName = QFileDialog.getSaveFileName((QWidget)this, (String)"Save result", (String)this.lastDir, (QFileDialog.Filter)new QFileDialog.Filter("Result file (*.pop)"));
        if (fileName.length() != 0) {
            try {
                CorsenResultWriter.writeHistoryResults(new File(fileName));
            }
            catch (IOException e) {
                this.showError("An error occurs while writing result file.");
            }
        }
    }

    private void about() {
        QMessageBox.about((QWidget)this, (String)"About Corsen", (String)Globals.ABOUT_HTML);
    }

    private void saveSettings() {
        try {
            this.settings.saveSettings();
        }
        catch (IOException e) {
            QMessageBox.critical((QWidget)this, (String)"Corsen", (String)"An error occurs while writing the setting on the disk.");
        }
    }

    private void setParticlesAPathLabelText(String text) {
        this.particlesAPath = text;
        this.mainWindowUi.particlesAPathLabel.setText(Util.shortPath(text, 50));
    }

    private void setParticlesBPathLabelText(String text) {
        this.particlesBPath = text;
        this.mainWindowUi.particlesBPathLabel.setText(Util.shortPath(text, 50));
    }

    private void setDirectoryPathLabelText(String text) {
        this.directoryPath = text;
        this.mainWindowUi.directoryPathLabel.setText(Util.shortPath(text, 50));
    }

    private void openParticlesA() {
        String fileName = QFileDialog.getOpenFileName((QWidget)this, (String)("Set " + this.settings.getParticlesAName().toLowerCase() + " file"), (String)this.lastDir, (QFileDialog.Filter)new QFileDialog.Filter("Particles file (*.par)"));
        if (fileName.length() != 0) {
            this.setParticlesAPathLabelText(fileName);
            this.setDirectoryPathLabelText("");
            this.setLastDir(fileName);
        }
    }

    private void openParticlesB() {
        String fileName = QFileDialog.getOpenFileName((QWidget)this, (String)("Set " + this.settings.getParticlesBName().toLowerCase() + " file"), (String)this.lastDir, (QFileDialog.Filter)new QFileDialog.Filter("Particles file (*.par)"));
        if (fileName.length() != 0) {
            this.setParticlesBPathLabelText(fileName);
            this.setDirectoryPathLabelText("");
            this.setLastDir(fileName);
        }
    }

    private void openDirectory() {
        List fileNames;
        QFileDialog dialog = new QFileDialog((QWidget)this);
        dialog.setFileMode(QFileDialog.FileMode.DirectoryOnly);
        dialog.setDirectory(this.lastDir);
        dialog.setWindowTitle("Set particles directory");
        if (dialog.exec() == QDialog.DialogCode.Accepted.value() && (fileNames = dialog.selectedFiles()).size() > 0) {
            String file = (String)fileNames.get(0);
            this.setDirectoryPathLabelText(file);
            this.setParticlesAPathLabelText("");
            this.setParticlesBPathLabelText("");
            this.setLastDir(file);
        }
    }

    private void openOutputFiles() {
        String fileName = QFileDialog.getOpenFileName((QWidget)this);
        if (fileName.length() != 0) {
            this.mainWindowUi.outputFilesPathLabel.setText(fileName);
        }
    }

    private void saveResultFile() {
        int modelView = this.mainWindowUi.resultViewComboBox.currentIndex();
        String ext = this.models.getSaveFileExtension(modelView);
        String fileName = QFileDialog.getSaveFileName((QWidget)this, (String)"Save result", (String)this.lastDir, (QFileDialog.Filter)new QFileDialog.Filter("Result file (*" + ext + ")"));
        if (fileName.length() != 0) {
            try {
                this.models.saveView(modelView, fileName);
            }
            catch (IOException e) {
                this.showError("An error occurs while writing result file.");
            }
        }
    }

    private void saveParticlesFile() {
        int modelView = this.mainWindowUi.resultViewComboBox.currentIndex();
        String fileName = QFileDialog.getSaveFileName((QWidget)this, (String)"Save result", (String)this.lastDir, (QFileDialog.Filter)new QFileDialog.Filter("Result file (*.par)"));
        if (fileName.length() != 0) {
            try {
                this.models.saveParticlesView(modelView, fileName);
            }
            catch (IOException e) {
                this.showError("An error occurs while writing result file.");
            }
        }
    }

    private void endProcess(CorsenResult result) {
        this.mainWindowUi.viewOGL.setResult(result);
        this.mainWindowUi.viewOGL.setSettings(this.settings);
        this.models.setResult(result);
        this.resultViewChanged(this.mainWindowUi.resultViewComboBox.currentIndex());
        if (result == null || result.getCuboidsParticlesA() == null) {
            this.mainWindowUi.particlesACuboidsRadioButton.setEnabled(false);
        } else {
            this.mainWindowUi.particlesACuboidsRadioButton.setEnabled(true);
        }
        if (result == null || result.getParticlesA() == null) {
            this.mainWindowUi.particlesARadioButton.setEnabled(false);
        } else {
            this.mainWindowUi.particlesARadioButton.setEnabled(true);
        }
        if (result == null || result.getCuboidsParticlesB() == null) {
            this.mainWindowUi.particlesBCuboidsRadioButton.setEnabled(false);
        } else {
            this.mainWindowUi.particlesBCuboidsRadioButton.setEnabled(true);
        }
        if (result == null || result.getParticlesB() == null) {
            this.mainWindowUi.particlesARadioButton.setEnabled(false);
        } else {
            this.mainWindowUi.particlesARadioButton.setEnabled(true);
        }
        if (result == null || result.getMinDistances() == null) {
            this.mainWindowUi.showDistancesCheckBox.setEnabled(false);
        } else {
            this.mainWindowUi.showDistancesCheckBox.setEnabled(true);
        }
    }

    private void updateVisualisation() {
        ViewOGL v = this.mainWindowUi.viewOGL;
        v.setDrawNoParticlesA(this.mainWindowUi.particlesANothingRadioButton.isChecked());
        v.setDrawNoParticlesB(this.mainWindowUi.particlesBNothingRadioButton.isChecked());
        v.setDrawBaryCenter(this.mainWindowUi.showBarycentersCheckBox.isChecked());
        v.setDrawDistances(this.mainWindowUi.showDistancesCheckBox.isChecked());
        v.setDrawParticlesACuboids(this.mainWindowUi.particlesACuboidsRadioButton.isChecked());
        v.setDrawParticlesBCuboids(this.mainWindowUi.particlesBCuboidsRadioButton.isChecked());
        v.setDrawDistances(this.mainWindowUi.showDistancesCheckBox.isChecked());
        v.setRemakeObject(true);
        v.repaint();
    }

    private void launch3DView() {
        this.setStartEnable(false);
        this.mainWindowUi.viewOGL.clear();
        this.models.setResult(null);
        this.resultViewChanged(this.mainWindowUi.resultViewComboBox.currentIndex());
        String particlesAFile = this.particlesAPath;
        String particlesBFile = this.particlesBPath;
        if (particlesAFile.length() == 0) {
            this.showError("No particles particles A (" + this.settings.getParticlesAName() + ") to load.");
            this.setStartEnable(true);
            return;
        }
        if (particlesBFile.length() == 0) {
            this.showError("No particles particles B (" + this.settings.getParticlesBName() + ") to load.");
            this.setStartEnable(true);
            return;
        }
        try {
            this.mainWindowUi.logTextEdit.setText("");
            CorsenResult cr = new CorsenResult(new File(particlesAFile), new File(particlesBFile), null, this.settings, null);
            DistancesCalculator dc = new DistancesCalculator(cr);
            dc.setCoordinatesFactor(this.settings.getFactor());
            dc.setZCoordinatesFactor(this.settings.getZFactor());
            this.mainWindowUi.progressLabel.setText("Process 0 of 1 cell");
            this.mainWindowUi.progressBar.setValue(0);
            this.mainWindowUi.logTextEdit.append("Lannch 3D visualisation only.");
            this.mainWindowUi.logTextEdit.append("Particles A (" + this.settings.getParticlesAName() + ") file: " + particlesAFile);
            this.mainWindowUi.logTextEdit.append("Particles B (" + this.settings.getParticlesBName() + ") file: " + particlesBFile);
            dc.loadParticles();
            this.mainWindowUi.logTextEdit.append("Show 3D visualisation successfully.");
            this.mainWindowUi.progressLabel.setText("Process 1 of 1 cell");
            this.mainWindowUi.progressBar.setValue(100);
            this.endProcess(cr);
        }
        catch (IOException e) {
            this.showError("Error while loading particles files.");
        }
        this.setStartEnable(true);
    }

    private UpdateStatusQt createNewUpdateStatus() {
        UpdateStatusQt updateStatus = new UpdateStatusQt();
        updateStatus.errorSignal.connect((Object)this, "showError(String)", Qt.ConnectionType.QueuedConnection);
        updateStatus.messageSignal.connect((Object)this, "showMessage(String)", Qt.ConnectionType.QueuedConnection);
        updateStatus.statusSignal.connect((Object)this, "updateStatus(ProgressEvent)", Qt.ConnectionType.QueuedConnection);
        updateStatus.resultSignal.connect((Object)this, "endProcess(CorsenResult)", Qt.ConnectionType.QueuedConnection);
        return updateStatus;
    }

    void launchAnalysis() {
        this.launchAnalysis(this.directoryPath, this.particlesAPath, this.particlesBPath, null);
    }

    void launchAnalysis(String dirFile, String particlesAFile, String particlesBFile, String resultDir) {
        this.mainWindowUi.viewOGL.clear();
        this.models.setResult(null);
        this.resultViewChanged(this.mainWindowUi.resultViewComboBox.currentIndex());
        CorsenCore cc = new CorsenCore();
        cc.setSettings(this.settings);
        cc.setUpdateStatus(this.createNewUpdateStatus());
        if (dirFile != null && dirFile.length() > 0) {
            cc.setDirFiles(new File(dirFile));
            cc.setMultipleFiles(true);
            if (this.settings.isClearHistoryWhenLaunchingNewCalc()) {
                CorsenHistoryResults.getCorsenHistoryResults().clear();
                CorsenQt.updateHistoryResults();
            }
            QThread t = new QThread((Runnable)cc);
            cc.getUpdateStatus().moveToThread((Thread)t);
            t.start();
        } else if (particlesAFile.length() == 0 || particlesBFile.length() == 0) {
            if (particlesAFile.length() == 0) {
                this.showError("No particles A (" + this.settings.getParticlesAName() + ")  file specified.");
            } else {
                this.showError("No particles B (" + this.settings.getParticlesBName() + ")  file specified.");
            }
        } else {
            String outputDir = resultDir;
            if (outputDir == null) {
                QFileDialog dialog = new QFileDialog((QWidget)this);
                dialog.setFileMode(QFileDialog.FileMode.AnyFile);
                dialog.setWindowTitle("Set output files prefix");
                dialog.setDirectory(this.lastDir);
                if (dialog.exec() == QDialog.DialogCode.Accepted.value()) {
                    List fileNames = dialog.selectedFiles();
                    File f = new File((String)fileNames.get(0));
                    outputDir = f.getAbsolutePath();
                }
            }
            if (outputDir != null) {
                this.mainWindowUi.particlesAPathLabel.setText(particlesAFile);
                this.mainWindowUi.particlesBPathLabel.setText(particlesBFile);
                this.mainWindowUi.outputFilesPathLabel.setText(outputDir);
                cc.setParticlesBFile(new File(particlesBFile));
                cc.setParticlesAFile(new File(particlesAFile));
                cc.setResultFile(new File(outputDir));
                cc.setMultipleFiles(false);
                Thread t = new Thread(cc);
                cc.getUpdateStatus().moveToThread(t);
                t.start();
            }
        }
    }

    private void setStartEnable(boolean value) {
        this.mainWindowUi.launchAnalysisPushButton.setEnabled(value);
        this.mainWindowUi.launch3DViewPushButton.setEnabled(value);
        this.mainWindowUi.updateViewPushButton.setEnabled(value);
        this.mainWindowUi.viewOGL.setRemakeObject(value);
        if (value && this.models.getResult() != null) {
            this.mainWindowUi.saveResultPushButton.setEnabled(true);
            if (this.mainWindowUi.resultViewComboBox.currentIndex() > 1) {
                this.mainWindowUi.saveParticlesPushButton.setEnabled(true);
            }
        } else {
            this.mainWindowUi.saveResultPushButton.setEnabled(false);
            this.mainWindowUi.saveParticlesPushButton.setEnabled(false);
        }
        this.resultViewChanged(this.mainWindowUi.resultViewComboBox.currentIndex());
        this.resultsHistoryChanged();
    }

    private void showStatusMessage(String message) {
        if (message == null) {
            return;
        }
        this.mainWindowUi.logTextEdit.insertPlainText(message + "\n");
    }

    private void clearStatusMessage() {
        this.mainWindowUi.logTextEdit.setPlainText("");
    }

    private void setLastDir(String filename) {
        if (filename == null) {
            return;
        }
        File f = new File(filename);
        this.lastDir = f.getParentFile().getAbsolutePath();
    }

    private void showProgressMessage(String message) {
        this.mainWindowUi.progressLabel.setText(message);
    }

    private void showProgressBarProgress(int currentCell, int cellCount, int phase, int maxPhase, int indexInPhase) {
        int max = cellCount * maxPhase * 1000;
        int value = (currentCell - 1) * maxPhase * 1000 + (phase - 1) * 1000 + indexInPhase;
        this.mainWindowUi.progressBar.setMinimum(0);
        this.mainWindowUi.progressBar.setMaximum(max);
        this.mainWindowUi.progressBar.setValue(value);
    }

    private void quit() {
        QApplication.exit();
    }

    private void copy() {
        if (this.mainWindowUi.tabWidget.currentIndex() == 1) {
            this.copyCorsenResult();
        }
        if (this.mainWindowUi.tabWidget.currentIndex() == 3) {
            this.copyHistoryResult();
        }
    }

    private void copyCorsenResult() {
        int index = this.mainWindowUi.resultViewComboBox.currentIndex();
        if (this.models.getResult() == null) {
            return;
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.models.saveView(index, os);
            QApplication.clipboard().setText(new String(os.toByteArray()));
        }
        catch (IOException e) {
            this.showError(e.getMessage());
            this.mainWindowUi.statusbar.showMessage("Error while copying result to clipboard", 2000);
        }
    }

    private void copyHistoryResult() {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            CorsenResultWriter.writeHistoryResults(os);
            QApplication.clipboard().setText(new String(os.toByteArray()));
        }
        catch (IOException e) {
            this.showError(e.getMessage());
            this.mainWindowUi.statusbar.showMessage("Error while copying result to clipboard", 2000);
        }
    }

    public void configureDialog() {
        CorsenConfigureQt cc = new CorsenConfigureQt(this, this.settings);
        cc.configureDialog();
        this.setWidgetTexts();
        this.updateVisualisation();
    }

    public void configureViewerFilters() {
        FilterDialog fd = new FilterDialog(this, this.settings);
        fd.show();
        this.updateVisualisation();
    }

    private void resultsHistoryChanged() {
        DataModelQt.HistoryDataModel historyModel = DataModelQt.getHistoryModel();
        if (this.mainWindowUi.historyTableView.model() == null) {
            this.mainWindowUi.historyTableView.setModel(historyModel);
            this.mainWindowUi.historyTableView.setSortingEnabled(true);
        } else {
            historyModel.update();
        }
        if (this.mainWindowUi.launchAnalysisPushButton.isEnabled()) {
            this.mainWindowUi.historyBoxplotLabel.setPixmap(historyModel.getBoxplot(this.settings));
            this.mainWindowUi.historyHistogramLabel.setPixmap(historyModel.getHisto(this.settings.getHistogramHistoryNumberClasses(), this.settings));
            if (this.models.getResult() == null) {
                this.mainWindowUi.saveParticlesPushButton.setEnabled(false);
            } else {
                this.mainWindowUi.saveParticlesPushButton.setEnabled(this.mainWindowUi.resultViewComboBox.currentIndex() > 1);
            }
            this.refreshHistoryGraphics = true;
        } else {
            if (this.refreshHistoryGraphics) {
                this.refreshHistoryGraphics = false;
                QImage img = this.mainWindowUi.historyBoxplotLabel.pixmap().toImage();
                if (img != null && !img.isNull()) {
                    this.mainWindowUi.historyBoxplotLabel.setPixmap(QPixmap.fromImage((QImage)QtUtil.toGrayscale(img)));
                }
                if ((img = this.mainWindowUi.historyHistogramLabel.pixmap().toImage()) != null && !img.isNull()) {
                    this.mainWindowUi.historyHistogramLabel.setPixmap(QPixmap.fromImage((QImage)QtUtil.toGrayscale(img)));
                }
            }
            this.mainWindowUi.saveParticlesPushButton.setEnabled(false);
        }
        this.mainWindowUi.HistoryResultlabel.setText(historyModel.getResultMessage());
    }

    private void resultViewChanged(Object o) {
        this.resultsHistoryChanged();
        int i = (Integer)o;
        this.mainWindowUi.resultTableView.setModel(this.models.getModel(i));
        this.mainWindowUi.resultTableView.setSortingEnabled(true);
        if (this.mainWindowUi.launchAnalysisPushButton.isEnabled()) {
            if (this.models.getResult() == null || this.models.getResult().getCuboidsParticlesA() == null) {
                return;
            }
            this.mainWindowUi.imageLabel.setPixmap(this.models.getResultPixmap(i, this.settings));
        } else {
            this.mainWindowUi.imageLabel.setText("Waiting the end of the process to show graphics");
        }
        this.mainWindowUi.resultTableView.setAlternatingRowColors(true);
        this.mainWindowUi.historyTableView.setAlternatingRowColors(true);
    }

    private void resultsHistoryViewChanged(Object o) {
        int i = (Integer)o;
        String val = CorsenHistoryResults.StatType.values()[i].toString();
        DataModelQt.HistoryDataModel historyModel = DataModelQt.getHistoryModel();
        if (!val.equals(CorsenHistoryResults.getCorsenHistoryResults().getStatType().toString())) {
            historyModel.setType(val);
            historyModel.update();
            this.mainWindowUi.HistoryResultlabel.setText(historyModel.getResultMessage());
            if (this.mainWindowUi.launchAnalysisPushButton.isEnabled()) {
                this.mainWindowUi.historyBoxplotLabel.setPixmap(historyModel.getBoxplot(this.settings));
                this.mainWindowUi.historyHistogramLabel.setPixmap(historyModel.getHisto(this.settings.getHistogramHistoryNumberClasses(), this.settings));
            }
        }
    }

    public void updateStatus(ProgressEvent e) {
        if (e == null) {
            return;
        }
        boolean endEvent = false;
        this.status.type = e.getType();
        switch (e.getType()) {
            case START_CELLS_EVENT: {
                this.setStartEnable(false);
                this.status.timeStartCells = System.currentTimeMillis();
                this.status.maxPhase = e.getIntValue1();
                this.setParticlesAPathLabelText("");
                this.setParticlesBPathLabelText("");
                this.clearStatusMessage();
                this.status.currentPhase = 0;
                break;
            }
            case START_CELL_EVENT: {
                this.status.timeStartCell = System.currentTimeMillis();
                this.status.currentCellToProcess = e.getIntValue1();
                this.status.cellToProcessCount = e.getIntValue2();
                this.status.particlesAFilePath = e.getStringValue1();
                this.status.particlesBFilePath = e.getStringValue2();
                this.status.resultFilePath = e.getStringValue3();
                this.setParticlesAPathLabelText(this.status.particlesAFilePath);
                this.setParticlesBPathLabelText(this.status.particlesBFilePath);
                this.status.currentPhase = 0;
                this.status.nbPhaseDone = 0;
                this.showProgressMessage("Progress: " + this.status.currentCellToProcess + " of " + this.status.cellToProcessCount + " cells");
                this.showStatusMessage("Process cell " + this.status.currentCellToProcess + " of " + this.status.cellToProcessCount + " cells");
                this.showStatusMessage("Particles A (" + this.settings.getParticlesAName() + ") file: " + this.status.particlesAFilePath);
                this.showStatusMessage("Particles B (" + this.settings.getParticlesBName() + ") file: " + this.status.particlesBFilePath);
                this.showStatusMessage("Output files prefix: " + this.status.resultFilePath);
                break;
            }
            case START_READ_PARTICLES_A_FILE_EVENT: 
            case START_READ_PARTICLES_B_FILE_EVENT: 
            case START_CHANGE_PARTICLES_A_COORDINATES_EVENT: 
            case START_CHANGE_PARTICLES_B_COORDINATES_EVENT: 
            case START_FILTER_PARTICLES_A_EVENT: 
            case START_FILTER_PARTICLES_B_EVENT: 
            case START_CALC_PARTICLES_A_CUBOIDS_EVENT: 
            case START_CALC_PARTICLES_B_CUBOIDS_EVENT: 
            case START_CALC_MIN_DISTANCES_EVENT: 
            case START_DISTANCES_ANALYSIS: 
            case START_WRITE_DATA_EVENT: 
            case START_WRITE_IV_PARTICLES_A_EVENT: 
            case START_WRITE_IV_PARTICLES_B_EVENT: 
            case START_WRITE_IV_PARTICLES_A_CUBOIDS_EVENT: 
            case START_WRITE_FULLRESULT_EVENT: 
            case START_WRITE_RPLOT_PARTICLES_A_EVENT: 
            case START_WRITE_RPLOT_PARTICLES_B_EVENT: 
            case START_WRITE_RPLOT_PARTICLES_A_CUBOIDS_EVENT: 
            case START_WRITE_RPLOT_PARTICLES_B_CUBOIDS_EVENT: 
            case START_WRITE_RPLOT_DISTANCES_EVENT: {
                this.status.currentPhase = e.getType().ordinal();
                this.status.indexInPhase = 0;
                ++this.status.nbPhaseDone;
                this.showCurrentPhase();
                break;
            }
            case PROGRESS_CALC_PARTICLES_A_CUBOIDS_EVENT: 
            case PROGRESS_CALC_PARTICLES_B_CUBOIDS_EVENT: 
            case PROGRESS_CALC_DISTANCES_EVENT: {
                this.status.indexInPhase = e.getIntValue1();
                break;
            }
            case END_CELL_EVENT: {
                long timeEndCell = System.currentTimeMillis();
                this.showStatusMessage("Process current cell in " + Util.toTimeHumanReadable(timeEndCell - this.status.timeStartCell) + ".\n");
                endEvent = true;
                break;
            }
            case END_CELLS_SUCCESSFULL_EVENT: {
                long timeEndCells = System.currentTimeMillis();
                this.showStatusMessage("Process all cells in " + Util.toTimeHumanReadable(timeEndCells - this.status.timeStartCells) + ".");
                this.setStartEnable(true);
                endEvent = true;
                break;
            }
            case END_ERROR_EVENT: {
                this.setStartEnable(true);
                this.showStatusMessage("Error !!!");
                return;
            }
            default: {
                return;
            }
        }
        if (this.status.currentPhase != 0) {
            this.showProgressBarProgress(this.status.currentCellToProcess, this.status.cellToProcessCount, this.status.nbPhaseDone, this.status.maxPhase, endEvent ? 1000 : this.status.indexInPhase);
        }
    }

    private void showCurrentPhase() {
        StringBuffer sb = new StringBuffer();
        sb.append(" Phase: ");
        sb.append(this.status.nbPhaseDone);
        sb.append("/");
        sb.append(this.status.maxPhase);
        sb.append(" (");
        sb.append(this.status.type.toString());
        sb.append(")");
        this.showStatusMessage(sb.toString());
    }

    public void showError(String msg) {
        QMessageBox.critical((QWidget)this, (String)"Corsen", (String)msg);
    }

    public void showMessage(String msg) {
        QMessageBox.information((QWidget)this, (String)"Corsen", (String)msg);
    }

    void redrawResultGraph() {
        this.models.setResult(this.models.getResult());
        this.resultViewChanged(this.mainWindowUi.resultViewComboBox.currentIndex());
    }

    void redrawHistoryGraph() {
        this.refreshHistoryGraphics = true;
        this.resultsHistoryChanged();
    }

    private void initResultTab() {
        int n = this.models.getViewCount();
        for (int i = 0; i < n; ++i) {
            this.mainWindowUi.resultViewComboBox.addItem(this.models.getViewDescription(i, this.settings), (Object)i);
        }
        this.mainWindowUi.resultViewComboBox.currentIndexChanged.connect((Object)this, "resultViewChanged(Object)");
        this.resultViewChanged(0);
        this.mainWindowUi.saveResultPushButton.clicked.connect((Object)this, "saveResultFile()");
        this.mainWindowUi.saveParticlesPushButton.clicked.connect((Object)this, "saveParticlesFile()");
    }

    private void initView3DTab() {
        this.mainWindowUi.launch3DViewPushButton.clicked.connect((Object)this, "launch3DView()");
        this.mainWindowUi.updateViewPushButton.clicked.connect((Object)this, "updateVisualisation()");
        this.mainWindowUi.updateViewPushButton.setHidden(true);
        this.mainWindowUi.particlesANothingRadioButton.clicked.connect((Object)this, "updateVisualisation()");
        this.mainWindowUi.particlesARadioButton.clicked.connect((Object)this, "updateVisualisation()");
        this.mainWindowUi.particlesACuboidsRadioButton.clicked.connect((Object)this, "updateVisualisation()");
        this.mainWindowUi.particlesBNothingRadioButton.clicked.connect((Object)this, "updateVisualisation()");
        this.mainWindowUi.particlesBRadioButton.clicked.connect((Object)this, "updateVisualisation()");
        this.mainWindowUi.particlesBCuboidsRadioButton.clicked.connect((Object)this, "updateVisualisation()");
        this.mainWindowUi.showBarycentersCheckBox.clicked.connect((Object)this, "updateVisualisation()");
        this.mainWindowUi.showDistancesCheckBox.clicked.connect((Object)this, "updateVisualisation()");
        this.mainWindowUi.filterViewpushButton.clicked.connect((Object)this, "configureViewerFilters()");
    }

    private void initHistoryTab() {
        this.mainWindowUi.historyClearPushButton.clicked.connect((Object)this, "clearHistoryResults()");
        this.mainWindowUi.historySaveResultsPushButton.clicked.connect((Object)this, "saveHistoryResults()");
        for (CorsenHistoryResults.StatType t : CorsenHistoryResults.StatType.values()) {
            this.mainWindowUi.historyStatComboBox.addItem(t.toString());
        }
        this.mainWindowUi.historyStatComboBox.currentIndexChanged.connect((Object)this, "resultsHistoryViewChanged(Object)");
    }

    private void setWidgetTexts() {
        String particlesAName = this.settings.getParticlesAName();
        String particlesBName = this.settings.getParticlesBName();
        Ui_CorsenMainWindow mui = this.mainWindowUi;
        mui.particleAFileLabel.setText("<b>Particles A (" + particlesAName + ") file:</b>");
        mui.particleBFileLabel.setText("<b>Particles B (" + particlesBName + ") file:</b>");
        mui.actionOpen_particlesA.setText("Open particles A (" + particlesAName + ")...");
        mui.actionOpen_particlesB.setText("Open particles B (" + particlesBName + ")...");
        mui.particlesAGroupBox.setTitle(particlesAName);
        mui.particlesBGroupBox.setTitle(particlesBName);
        mui.particlesARadioButton.setText(particlesAName);
        mui.particlesBRadioButton.setText(particlesBName);
        mui.particlesACuboidsRadioButton.setText(particlesAName + " preprocessed");
        mui.particlesBCuboidsRadioButton.setText(particlesBName + " preprocessed");
        int max = mui.particlesBCuboidsRadioButton.geometry().width();
        QRect gA = mui.particlesAGroupBox.geometry();
        mui.particlesAGroupBox.setGeometry(gA.x(), gA.y(), max, gA.height());
        QRect gB = mui.particlesBGroupBox.geometry();
        mui.particlesBGroupBox.setGeometry(gB.x(), gB.y(), max, gB.height());
        QRect gBt = mui.updateViewPushButton.geometry();
        mui.updateViewPushButton.setGeometry(gBt.x(), gBt.y(), max, gBt.height());
        mui.historyTableView.setToolTip("Results history table");
        mui.historyTableView.setStatusTip("Results history table");
        int n = this.models.getViewCount();
        for (int i = 0; i < n; ++i) {
            this.mainWindowUi.resultViewComboBox.setItemText(i, this.models.getViewDescription(i, this.settings));
        }
        mui.viewOGL.setToolTip("3D Visualisation");
        mui.viewOGL.setStatusTip("3D Visualisation");
    }

    static void launchAnalysis(String particlesAFile, String particlesBFile, String dirFile) {
        mainw.launchAnalysis(null, particlesAFile, particlesBFile, dirFile);
    }

    static void updateHistoryResults() {
        mainw.resultsHistoryChanged();
    }

    static boolean isCalculation() {
        return !CorsenQt.mainw.mainWindowUi.launchAnalysisPushButton.isEnabled();
    }

    public void closeEvent(QCloseEvent event) {
        QApplication.exit();
    }

    public static void main(String[] args) {
        QApplication.initialize((String[])args);
        logger.info("Java version: " + System.getProperty("java.version"));
        logger.info("Qt version: " + QtInfo.versionString());
        Locale.setDefault(Locale.UK);
        QLocale.setDefault((QLocale)new QLocale(QLocale.Language.English, QLocale.Country.UnitedKingdom));
        mainw = new CorsenQt();
        mainw.show();
        QApplication.exec();
    }

    public CorsenQt() {
        this.settings = Corsen.getSettings();
        this.mainWindowUi.setupUi(this);
        this.setWindowTitle(Globals.getWindowsTitle());
        this.mainWindowUi.actionAbout_Corsen.triggered.connect((Object)this, "about()");
        this.mainWindowUi.actionCorsen_Website.triggered.connect((Object)this, "openWebsite()");
        this.mainWindowUi.actionCorsen_Handbook.triggered.connect((Object)this, "openHandbook()");
        this.mainWindowUi.action_Report_Bug.triggered.connect((Object)this, "reportBug()");
        this.mainWindowUi.action_Configure_Corsen.triggered.connect((Object)this, "configureDialog()");
        this.mainWindowUi.actionSave_settings.triggered.connect((Object)this, "saveSettings()");
        this.mainWindowUi.actionOpen_particlesA.triggered.connect((Object)this, "openParticlesA()");
        this.mainWindowUi.actionOpen_particlesB.triggered.connect((Object)this, "openParticlesB()");
        this.mainWindowUi.actionOpen_a_directory.triggered.connect((Object)this, "openDirectory()");
        this.mainWindowUi.action_Start_analysis.triggered.connect((Object)this, "launchAnalysis()");
        this.mainWindowUi.launchAnalysisPushButton.clicked.connect((Object)this, "launchAnalysis()");
        this.mainWindowUi.action_Quit.triggered.connect((Object)this, "quit()");
        this.mainWindowUi.action_Copy.triggered.connect((Object)this, "copy()");
        this.setWidgetTexts();
        this.initResultTab();
        this.initView3DTab();
        this.initHistoryTab();
        String iconPath = "classpath:" + (Globals.IS_JAR ? "" : "/files") + "/images/corsen-logo.png";
        logger.info("iconPath: " + iconPath);
        this.setWindowIcon(new QIcon(iconPath));
        this.endProcess(null);
        this.setStartEnable(true);
    }

    private static final class StatusInfo {
        int currentCellToProcess;
        int cellToProcessCount;
        ProgressEvent.ProgressEventType type;
        int currentPhase;
        int nbPhaseDone;
        int maxPhase;
        int indexInPhase;
        long timeStartCells;
        long timeStartCell;
        String particlesAFilePath;
        String particlesBFilePath;
        String resultFilePath;

        private StatusInfo() {
        }
    }

    private class UpdateStatusQt
    extends QObject
    implements UpdateStatus {
        public QSignalEmitter.Signal1<ProgressEvent> statusSignal = new QSignalEmitter.Signal1((QSignalEmitter)this);
        public QSignalEmitter.Signal1<String> messageSignal = new QSignalEmitter.Signal1((QSignalEmitter)this);
        public QSignalEmitter.Signal1<String> errorSignal = new QSignalEmitter.Signal1((QSignalEmitter)this);
        public QSignalEmitter.Signal1<CorsenResult> resultSignal = new QSignalEmitter.Signal1((QSignalEmitter)this);

        private UpdateStatusQt() {
        }

        public void showError(String msg) {
            this.errorSignal.emit((Object)msg);
        }

        public void showMessage(String msg) {
            this.messageSignal.emit((Object)msg);
        }

        public void updateStatus(ProgressEvent e) {
            this.statusSignal.emit((Object)e);
        }

        public void endProcess(CorsenResult result) {
            this.resultSignal.emit((Object)result);
        }

        public Thread newThread(Runnable runnable) {
            return new QThread(runnable);
        }

        public UpdateStatus chain() {
            UpdateStatusQt result = new UpdateStatusQt();
            result.errorSignal.connect((Object)this, "showError(String)", Qt.ConnectionType.QueuedConnection);
            result.messageSignal.connect((Object)this, "showMessage(String)", Qt.ConnectionType.QueuedConnection);
            result.statusSignal.connect((Object)this, "updateStatus(ProgressEvent)", Qt.ConnectionType.QueuedConnection);
            result.resultSignal.connect((Object)this, "endProcess(CorsenResult)", Qt.ConnectionType.QueuedConnection);
            return result;
        }
    }
}

