/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.gui.qt;

import com.trolltech.qt.core.QAbstractItemModel;
import com.trolltech.qt.core.QModelIndex;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QAbstractTableModel;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QImage;
import com.trolltech.qt.gui.QPixmap;
import com.trolltech.qt.gui.QSortFilterProxyModel;
import fr.ens.transcriptome.corsen.CorsenResultWriter;
import fr.ens.transcriptome.corsen.Settings;
import fr.ens.transcriptome.corsen.calc.CorsenHistoryResults;
import fr.ens.transcriptome.corsen.calc.CorsenResult;
import fr.ens.transcriptome.corsen.calc.Distance;
import fr.ens.transcriptome.corsen.calc.DistanceAnalyser;
import fr.ens.transcriptome.corsen.gui.qt.QtUtil;
import fr.ens.transcriptome.corsen.gui.qt.ResultGraphs;
import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.model.Particles3D;
import fr.ens.transcriptome.corsen.util.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DataModelQt {
    private static final int VIEWS_COUNT = 6;
    private static final String DATA_SUMMARY_DESCRIPTION = "Data result summary";
    private static final String DATA_VIEW_DESCRIPTION = "Full data results";
    private static final String IV_MESSENGERS_DESCRIPTION = "Intensities and volumes of messengers";
    private static final String IV_MESSENGERS_CUBOIDS_DESCRIPTION = "Intensities and volumes of messengers cuboids";
    private static final String IV_MITO_DESCRIPTION = "Intensities and volumes of mitochondria ";
    private static final String IV_MITO_CUBOIDS_DESCRIPTION = "Intensities and volumes of mitochondria cuboids";
    private static HistoryDataModel historyModelSingleton = new HistoryDataModel();
    private CorsenResult result;
    private Map<Integer, QImage> cacheImage = new HashMap<Integer, QImage>();
    private Map<Integer, QPixmap> cachePixmap = new HashMap<Integer, QPixmap>();

    public static HistoryDataModel getHistoryModel() {
        return historyModelSingleton;
    }

    public CorsenResult getResult() {
        return this.result;
    }

    public void setResult(CorsenResult result) {
        this.result = result;
        this.cacheImage.clear();
        this.cachePixmap.clear();
    }

    public int getViewCount() {
        return 6;
    }

    public String getViewDescription(int index) {
        switch (index) {
            case 0: {
                return DATA_SUMMARY_DESCRIPTION;
            }
            case 1: {
                return DATA_VIEW_DESCRIPTION;
            }
            case 2: {
                return IV_MESSENGERS_DESCRIPTION;
            }
            case 3: {
                return IV_MESSENGERS_CUBOIDS_DESCRIPTION;
            }
            case 4: {
                return IV_MITO_DESCRIPTION;
            }
            case 5: {
                return IV_MITO_CUBOIDS_DESCRIPTION;
            }
        }
        return null;
    }

    public String getViewDescription(int index, Settings settings) {
        String desc = this.getViewDescription(index);
        if (desc == null) {
            return null;
        }
        desc = desc.replaceAll("messengers", settings.getParticlesAName());
        desc = desc.replaceAll("mitochondria", settings.getParticlesBName());
        return desc;
    }

    public QAbstractItemModel getModel(int index) {
        QAbstractTableModel model;
        CorsenResult r = this.getResult();
        if (r == null || r.getMinDistances() == null || r.getMaxDistances() == null) {
            return null;
        }
        switch (index) {
            case 0: {
                model = new SummaryDataModel(r);
                break;
            }
            case 1: {
                model = new FullDataModel(r);
                break;
            }
            case 2: {
                model = new IVModel(r.getParticlesA());
                break;
            }
            case 3: {
                model = new IVModel(r.getCuboidsParticlesA());
                break;
            }
            case 4: {
                model = new IVModel(r.getParticlesB());
                break;
            }
            case 5: {
                model = new IVModel(r.getCuboidsParticlesB());
                break;
            }
            default: {
                model = null;
            }
        }
        QSortFilterProxyModel sortModel = new QSortFilterProxyModel();
        sortModel.setSourceModel((QAbstractItemModel)model);
        return sortModel;
    }

    public void saveView(int index, String filename) throws IOException {
        this.saveView(index, new File(filename));
    }

    public void saveView(int index, File file) throws IOException {
        this.saveView(index, new FileOutputStream(file));
    }

    public void saveView(int index, OutputStream os) throws IOException {
        CorsenResult r = this.getResult();
        if (r == null) {
            return;
        }
        CorsenResultWriter crw = new CorsenResultWriter(r);
        switch (index) {
            case 0: {
                crw.writeSummaryResultFile(os);
                break;
            }
            case 1: {
                crw.writeDataFile(os);
                break;
            }
            case 2: {
                crw.writeMessengersIntensityVolume(os);
                break;
            }
            case 3: {
                crw.writeCuboidsMessengersIntensityVolume(os);
                break;
            }
            case 4: {
                crw.writeMitosIntensityVolume(os);
                break;
            }
            case 5: {
                crw.writeCuboidsMitosIntensityVolume(os);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void saveParticlesView(int index, String filename) throws IOException {
        this.saveParticlesView(index, new File(filename));
    }

    public void saveParticlesView(int index, File file) throws IOException {
        this.saveParticlesView(index, new FileOutputStream(file));
    }

    public void saveParticlesView(int index, OutputStream outputStream) throws IOException {
        Particles3D particlesToSave;
        CorsenResult r = this.getResult();
        switch (index) {
            case 2: {
                particlesToSave = r.getParticlesA();
                break;
            }
            case 3: {
                particlesToSave = r.getCuboidsParticlesA();
                break;
            }
            case 4: {
                particlesToSave = r.getParticlesB();
                break;
            }
            case 5: {
                particlesToSave = r.getCuboidsParticlesB();
                break;
            }
            default: {
                particlesToSave = null;
            }
        }
        if (particlesToSave != null) {
            particlesToSave.saveParticles(outputStream);
        }
    }

    public String getSaveFileExtension(int index) {
        switch (index) {
            case 1: {
                return ".data";
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return ".iv";
            }
        }
        return "";
    }

    public QPixmap getResultPixmap(final int index, final Settings settings) {
        QPixmap result;
        if (!this.cachePixmap.containsKey(index)) {
            QtUtil.CreateQImageThread cqpt = new QtUtil.CreateQImageThread(){

                protected QImage createQImage() {
                    return DataModelQt.this.getImage(index, settings);
                }
            };
            Thread t = new Thread(cqpt);
            t.start();
            while (!cqpt.isEnd()) {
                QApplication.processEvents();
            }
            result = QPixmap.fromImage((QImage)cqpt.getQImage());
            this.cachePixmap.put(index, result);
        } else {
            result = this.cachePixmap.get(index);
        }
        return result;
    }

    public QImage getImage(int index, Settings settings) {
        CorsenResult r = this.getResult();
        if (r == null) {
            return null;
        }
        switch (index) {
            case 0: {
                if (!this.cacheImage.containsKey(0)) {
                    QImage img = new ResultGraphs().createBoxPlot(r, settings.getUnit());
                    if (img == null) {
                        return null;
                    }
                    this.cacheImage.put(0, img);
                }
                return this.cacheImage.get(0);
            }
            case 1: {
                if (!this.cacheImage.containsKey(1)) {
                    QImage img = new ResultGraphs().createDistanceDistributionImage(r, settings.getHistogramResultsNumberClasses(), settings.getUnit());
                    if (img == null) {
                        return null;
                    }
                    QApplication.processEvents();
                    this.cacheImage.put(1, img);
                }
                return this.cacheImage.get(1);
            }
            case 2: {
                if (!this.cacheImage.containsKey(2)) {
                    QImage img = new ResultGraphs().createScatterPlot(r.getParticlesA(), r.getParticlesA().getName() + " intensity/volume", settings.getUnit());
                    if (img == null) {
                        return null;
                    }
                    QApplication.processEvents();
                    this.cacheImage.put(2, img);
                }
                return this.cacheImage.get(2);
            }
            case 3: {
                if (!this.cacheImage.containsKey(3)) {
                    QImage img = new ResultGraphs().createScatterPlot(r.getCuboidsParticlesA(), r.getParticlesA().getName() + " cuboids intensity/volume", settings.getUnit());
                    if (img == null) {
                        return null;
                    }
                    QApplication.processEvents();
                    this.cacheImage.put(3, img);
                }
                return this.cacheImage.get(3);
            }
            case 4: {
                if (!this.cacheImage.containsKey(4)) {
                    QImage img = new ResultGraphs().createScatterPlot(r.getParticlesB(), r.getParticlesB().getName() + " intensity/volume", settings.getUnit());
                    if (img == null) {
                        return null;
                    }
                    QApplication.processEvents();
                    this.cacheImage.put(4, img);
                }
                return this.cacheImage.get(4);
            }
            case 5: {
                if (!this.cacheImage.containsKey(5)) {
                    QImage img = new ResultGraphs().createScatterPlot(r.getCuboidsParticlesB(), r.getParticlesB().getName() + " cuboids intensity/volume", settings.getUnit());
                    if (img == null) {
                        return null;
                    }
                    QApplication.processEvents();
                    this.cacheImage.put(4, img);
                }
                return this.cacheImage.get(4);
            }
        }
        return null;
    }

    static class HistoryDataModel
    extends QAbstractTableModel {
        private CorsenHistoryResults results = CorsenHistoryResults.getCorsenHistoryResults();
        private static final DecimalFormat percentFormat = new DecimalFormat("00.000%", new DecimalFormatSymbols(Locale.UK));

        HistoryDataModel() {
        }

        public int columnCount(QModelIndex arg0) {
            return 4;
        }

        public Object data(QModelIndex mIndex, int role) {
            if (mIndex == null || role != 0) {
                return null;
            }
            CorsenHistoryResults.Entry e = this.results.get(mIndex.row());
            int col = mIndex.column();
            switch (col) {
                case 0: {
                    return e.getId();
                }
                case 1: {
                    return e.getFileA().getName();
                }
                case 2: {
                    return e.getFileB().getName();
                }
                case 3: {
                    switch (this.results.getStatType()) {
                        case CUSTOM: {
                            double val = e.getCustomMinDistance();
                            if (Double.isInfinite(val) || Double.isNaN(val)) {
                                return val;
                            }
                            return percentFormat.format(val);
                        }
                        case MIN: {
                            return e.getMinMinDistance();
                        }
                        case MAX: {
                            return e.getMaxMinDistance();
                        }
                        case MEAN: {
                            return e.getMeanMinDistance();
                        }
                    }
                    return e.getMedianMinDistance();
                }
            }
            return null;
        }

        public int rowCount(QModelIndex arg0) {
            return this.results.size();
        }

        public Object headerData(int section, Qt.Orientation orientation, int role) {
            if (orientation != Qt.Orientation.Horizontal || role != 0) {
                return null;
            }
            switch (section) {
                case 0: {
                    return "Id";
                }
                case 1: {
                    return "File A";
                }
                case 2: {
                    return "File B";
                }
                case 3: {
                    switch (this.results.getStatType()) {
                        case CUSTOM: {
                            return "Percent of particles";
                        }
                    }
                    return "Minimal distance";
                }
            }
            return null;
        }

        public QPixmap getBoxplot(Settings settings) {
            QImage img = new ResultGraphs().createBoxPlot(Util.removeNaN(this.results.getDistances()), settings.getUnit());
            if (img == null) {
                return null;
            }
            return QPixmap.fromImage((QImage)img);
        }

        public QPixmap getHisto(int classes, Settings settings) {
            QImage img = new ResultGraphs().createDistanceDistributionImage(Util.removeNaN(this.results.getDistances()), classes, settings.getUnit());
            if (img == null) {
                return null;
            }
            return QPixmap.fromImage((QImage)img);
        }

        public String getResultMessage() {
            double median = this.results.getMedianOfMedianMinDistances();
            double mean = this.results.getMeanOfMedianMinDistances();
            StringBuilder sb = new StringBuilder();
            sb.append("The median of minimal distances is: ");
            if (Double.isNaN(median)) {
                sb.append("undefined");
            } else {
                sb.append(String.format("%.3f", median));
            }
            sb.append(" and the mean of minimal distances is: ");
            if (Double.isNaN(mean)) {
                sb.append("undefined");
            } else {
                sb.append(String.format("%.3f", mean));
            }
            sb.append(" (");
            sb.append(this.results.size());
            if (this.results.size() > 1) {
                sb.append(" cells).");
            } else {
                sb.append(" cell).");
            }
            return sb.toString();
        }

        public void setType(String name) {
            this.results.setStatType(CorsenHistoryResults.StatType.getTypeFromDescription(name));
        }

        public void update() {
            super.reset();
        }
    }

    private static class SummaryDataModel
    extends QAbstractTableModel {
        private DistanceAnalyser daMins = null;
        private DistanceAnalyser daMaxs = null;

        public int columnCount(QModelIndex arg0) {
            return 7;
        }

        public Object data(QModelIndex mIndex, int role) {
            if (mIndex == null || role != 0) {
                return null;
            }
            if (this.daMins == null || this.daMaxs == null) {
                return null;
            }
            int row = mIndex.row();
            int col = mIndex.column();
            if (col == 0) {
                if (row == 0) {
                    return "Min distances";
                }
                return "Max distances";
            }
            DistanceAnalyser da = row == 0 ? this.daMins : this.daMaxs;
            switch (col) {
                case 1: {
                    return da.getMin();
                }
                case 2: {
                    return da.getFirstQuartile();
                }
                case 3: {
                    return da.getMedian();
                }
                case 4: {
                    return da.getMean();
                }
                case 5: {
                    return da.getThirdQuartile();
                }
                case 6: {
                    return da.getMax();
                }
            }
            return null;
        }

        public int rowCount(QModelIndex arg0) {
            int count = 0;
            if (this.daMins != null) {
                ++count;
            }
            if (this.daMaxs != null) {
                ++count;
            }
            return count;
        }

        public Object headerData(int section, Qt.Orientation orientation, int role) {
            if (orientation != Qt.Orientation.Horizontal || role != 0) {
                return null;
            }
            switch (section) {
                case 0: {
                    return "";
                }
                case 1: {
                    return "Mininum";
                }
                case 2: {
                    return "1st Quartile";
                }
                case 3: {
                    return "Median";
                }
                case 4: {
                    return "Mean";
                }
                case 5: {
                    return "3rd Quartile";
                }
                case 6: {
                    return "Maximum";
                }
            }
            return null;
        }

        public SummaryDataModel(CorsenResult r) {
            if (r == null) {
                return;
            }
            this.daMins = r.getMinAnalyser();
            this.daMaxs = r.getMaxAnalyser();
        }
    }

    private static class IVModel
    extends QAbstractTableModel {
        private List<Particle3D> pars;

        public int columnCount(QModelIndex arg0) {
            return 3;
        }

        public Object data(QModelIndex mIndex, int role) {
            if (mIndex == null || role != 0) {
                return null;
            }
            Particle3D p = this.pars.get(mIndex.row());
            int col = mIndex.column();
            switch (col) {
                case 0: {
                    return p.getName();
                }
                case 1: {
                    return p.getIntensity();
                }
                case 2: {
                    return p.getVolume();
                }
            }
            return null;
        }

        public int rowCount(QModelIndex arg0) {
            return this.pars == null ? 0 : this.pars.size();
        }

        public Object headerData(int section, Qt.Orientation orientation, int role) {
            if (orientation != Qt.Orientation.Horizontal || role != 0) {
                return null;
            }
            switch (section) {
                case 0: {
                    return "Particle Id";
                }
                case 1: {
                    return "Intensity";
                }
                case 2: {
                    return "Volume";
                }
            }
            return null;
        }

        public IVModel(Particles3D particles) {
            if (particles != null) {
                this.pars = particles.getParticles();
            }
        }
    }

    private static final class FullDataModel
    extends QAbstractTableModel {
        private Map<Particle3D, Distance> mins = null;
        private Map<Particle3D, Distance> maxs = null;
        private List<Particle3D> listParticles;
        private int nRows;

        public int columnCount(QModelIndex arg0) {
            return 4;
        }

        public int rowCount(QModelIndex arg0) {
            return this.nRows;
        }

        public Object data(QModelIndex mIndex, int role) {
            if (mIndex == null || role != 0) {
                return null;
            }
            int row = mIndex.row();
            int col = mIndex.column();
            Particle3D p = this.listParticles.get(row);
            switch (col) {
                case 0: {
                    return p.getName();
                }
                case 1: {
                    return p.getIntensity();
                }
                case 2: {
                    return (double)this.mins.get(p).getDistance();
                }
                case 3: {
                    return (double)this.maxs.get(p).getDistance();
                }
            }
            return null;
        }

        public Object headerData(int section, Qt.Orientation orientation, int role) {
            if (orientation != Qt.Orientation.Horizontal || role != 0) {
                return null;
            }
            switch (section) {
                case 0: {
                    return "Particle Id";
                }
                case 1: {
                    return "Intensity";
                }
                case 2: {
                    return "Min";
                }
                case 3: {
                    return "Max";
                }
            }
            return null;
        }

        public FullDataModel(CorsenResult r) {
            if (r == null) {
                return;
            }
            this.mins = r.getMinDistances();
            this.maxs = r.getMaxDistances();
            this.listParticles = new ArrayList<Particle3D>(this.mins.keySet());
            this.nRows = this.mins.size();
        }
    }
}

