/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.gui.qt;

import com.trolltech.qt.core.QObject;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QMessageBox;
import com.trolltech.qt.gui.QWidget;
import fr.ens.transcriptome.corsen.Settings;
import fr.ens.transcriptome.corsen.calc.JavascriptDistancesFilter;
import fr.ens.transcriptome.corsen.gui.qt.CorsenQt;
import fr.ens.transcriptome.corsen.gui.qt.Ui_FilterDialog;
import fr.ens.transcriptome.corsen.model.JavascriptParticles3DFilter;

public class FilterDialog {
    private CorsenQt mainWindow;
    private Settings settings;

    public void show() {
        final Ui_FilterDialog dialogUi = new Ui_FilterDialog();
        QDialog dialog = new QDialog((QWidget)this.mainWindow);
        dialogUi.setupUi(dialog);
        QObject o = new QObject(){

            public void enableParticlesAFilter() {
                dialogUi.particlesAFilterlabel.setEnabled(true);
                dialogUi.particlesAFilterlineEdit.setEnabled(true);
            }

            public void disableParticlesAFilter() {
                dialogUi.particlesAFilterlabel.setEnabled(false);
                dialogUi.particlesAFilterlineEdit.setEnabled(false);
            }

            public void stateChangedParticlesAFilter(int value) {
                if (value == 0) {
                    this.disableParticlesAFilter();
                } else {
                    this.enableParticlesAFilter();
                }
            }

            public void enableParticlesBFilter() {
                dialogUi.particlesBFilterlabel.setEnabled(true);
                dialogUi.particlesBFilterlineEdit.setEnabled(true);
            }

            public void disableParticlesBFilter() {
                dialogUi.particlesBFilterlabel.setEnabled(false);
                dialogUi.particlesBFilterlineEdit.setEnabled(false);
            }

            public void stateChangedParticlesBFilter(int value) {
                if (value == 0) {
                    this.disableParticlesBFilter();
                } else {
                    this.enableParticlesBFilter();
                }
            }

            public void enableDistancesFilter() {
                dialogUi.distancesFilterlabel.setEnabled(true);
                dialogUi.distancesFilterlineEdit.setEnabled(true);
            }

            public void disableDistancesFilter() {
                dialogUi.distancesFilterlabel.setEnabled(false);
                dialogUi.distancesFilterlineEdit.setEnabled(false);
            }

            public void stateChangedDistancesFilter(int value) {
                if (value == 0) {
                    this.disableDistancesFilter();
                } else {
                    this.enableDistancesFilter();
                }
            }
        };
        dialogUi.particlesAFilterCheckBox.stateChanged.connect((Object)o, "stateChangedParticlesAFilter(int)");
        dialogUi.particlesBFilterCheckBox.stateChanged.connect((Object)o, "stateChangedParticlesBFilter(int)");
        dialogUi.distancesFilterCheckBox.stateChanged.connect((Object)o, "stateChangedDistancesFilter(int)");
        Settings s = this.settings;
        dialogUi.particlesAFilterCheckBox.setChecked(true);
        dialogUi.particlesAFilterCheckBox.setChecked(s.isParticlesAViewFilterEnabled());
        dialogUi.particlesAFilterlineEdit.setText(s.getParticlesAViewFilterExpression());
        dialogUi.particlesBFilterCheckBox.setChecked(true);
        dialogUi.particlesBFilterCheckBox.setChecked(s.isParticlesBViewFilterEnabled());
        dialogUi.particlesBFilterlineEdit.setText(s.getParticlesBViewFilterExpression());
        dialogUi.distancesFilterCheckBox.setChecked(true);
        dialogUi.distancesFilterCheckBox.setChecked(s.isDistancesViewFilterEnabled());
        dialogUi.distancesFilterlineEdit.setText(s.getDistancesViewFilterExpression());
        dialogUi.onlyDistanceOfShowedParticlesCheckBox.setChecked(s.isFilterShowDistanceShowedParticles());
        if (dialog.exec() == QDialog.DialogCode.Accepted.value()) {
            s.setEnableParticlesAViewerFilter(dialogUi.particlesAFilterCheckBox.isChecked());
            String expA = dialogUi.particlesAFilterlineEdit.text();
            if (JavascriptParticles3DFilter.createFilter(expA) != null) {
                s.setExpressionParticlesAViewerFilter(expA);
            } else {
                QMessageBox.warning((QWidget)this.mainWindow, (String)"Corsen", (String)"Warning: Your filter for particles A is not valid.");
            }
            s.setEnableParticlesBViewerFilter(dialogUi.particlesBFilterCheckBox.isChecked());
            String expB = dialogUi.particlesBFilterlineEdit.text();
            if (JavascriptParticles3DFilter.createFilter(expB) != null) {
                s.setExpressionParticlesBViewerFilter(expB);
            } else {
                QMessageBox.warning((QWidget)this.mainWindow, (String)"Corsen", (String)"Warning: Your filter for particles B is not valid.");
            }
            s.setEnableDistancesViewerFilter(dialogUi.distancesFilterCheckBox.isChecked());
            String expD = dialogUi.distancesFilterlineEdit.text();
            if (JavascriptDistancesFilter.createFilter(expD) != null) {
                s.setExpressionDistancesViewerFilter(expD);
            } else {
                QMessageBox.warning((QWidget)this.mainWindow, (String)"Corsen", (String)"Warning: Your filter for distances is not valid.");
            }
            s.setFilterShowDistanceShowedParticles(dialogUi.onlyDistanceOfShowedParticlesCheckBox.isChecked());
        }
    }

    FilterDialog(CorsenQt mainWindow, Settings settings) {
        this.mainWindow = mainWindow;
        this.settings = settings;
    }
}

