/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.gui.qt;

import com.trolltech.qt.core.QAbstractItemModel;
import com.trolltech.qt.core.QModelIndex;
import com.trolltech.qt.gui.QContextMenuEvent;
import com.trolltech.qt.gui.QCursor;
import com.trolltech.qt.gui.QMenu;
import com.trolltech.qt.gui.QMessageBox;
import com.trolltech.qt.gui.QSortFilterProxyModel;
import com.trolltech.qt.gui.QTableView;
import com.trolltech.qt.gui.QWidget;
import fr.ens.transcriptome.corsen.calc.CorsenHistoryResults;
import fr.ens.transcriptome.corsen.gui.qt.CorsenQt;
import fr.ens.transcriptome.corsen.gui.qt.DataModelQt;

public class HistoryTableView
extends QTableView {
    private int lastRowIndex;
    private QSortFilterProxyModel sorter;

    public void contextMenuEvent(QContextMenuEvent e) {
        QModelIndex index = this.sorter.mapToSource(this.indexAt(e.pos()));
        if (index != null) {
            this.lastRowIndex = index.row();
            QMenu menu = new QMenu((QWidget)this);
            menu.addAction("Redo calcultion for this result", (Object)this, "recalcResult()");
            menu.addAction("Delete this result", (Object)this, "deleteResult()");
            menu.addAction("Delete all results", (Object)this, "deleteAllResults()");
            menu.setEnabled(!CorsenQt.isCalculation());
            menu.exec(QCursor.pos());
        }
    }

    void setModel(final DataModelQt.HistoryDataModel model) {
        this.sorter = new QSortFilterProxyModel(){

            protected boolean lessThan(QModelIndex a, QModelIndex b) {
                if (a == null || b == null) {
                    return false;
                }
                int size = model.rowCount();
                if (a.row() >= size || b.row() >= size) {
                    return false;
                }
                Object oa = a.data();
                if (oa instanceof Number) {
                    Number na = (Number)oa;
                    Number nb = (Number)b.data();
                    return na.doubleValue() < nb.doubleValue();
                }
                return oa.toString().compareTo(b.data().toString()) < 0;
            }
        };
        this.sorter.setSourceModel((QAbstractItemModel)model);
        super.setModel((QAbstractItemModel)this.sorter);
    }

    private void recalcResult() {
        CorsenHistoryResults.Entry e = CorsenHistoryResults.getCorsenHistoryResults().get(this.lastRowIndex);
        CorsenQt.launchAnalysis(e.getFileA().getAbsolutePath(), e.getFileB().getAbsolutePath(), e.getResultsPath().getAbsolutePath());
    }

    private void deleteResult() {
        CorsenHistoryResults.getCorsenHistoryResults().remove(this.lastRowIndex);
        CorsenQt.updateHistoryResults();
    }

    private void deleteAllResults() {
        QMessageBox.StandardButton result = QMessageBox.warning((QWidget)this, (String)"Delete all results", (String)"Are you sure to remove all results ?", (QMessageBox.StandardButtons)new QMessageBox.StandardButtons(new QMessageBox.StandardButton[]{QMessageBox.StandardButton.Yes, QMessageBox.StandardButton.No}), (QMessageBox.StandardButton)QMessageBox.StandardButton.No);
        if (result == QMessageBox.StandardButton.Yes) {
            CorsenHistoryResults.getCorsenHistoryResults().clear();
            CorsenQt.updateHistoryResults();
        }
    }

    public HistoryTableView() {
        this(null);
    }

    public HistoryTableView(QWidget widget) {
        super(widget);
    }
}

