/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.gui.qt;

import com.trolltech.qt.gui.QImage;

public final class QtUtil {
    public static final QImage toGrayscale(QImage srcImage) {
        if (srcImage.isNull()) {
            return new QImage();
        }
        QImage dstImage = new QImage(srcImage.size(), QImage.Format.Format_ARGB32);
        for (int y = 0; y < srcImage.height(); ++y) {
            for (int x = 0; x < srcImage.width(); ++x) {
                int pixel = srcImage.pixel(x, y);
                int alpha = (pixel & 0xFF000000) >> 24 & 0xFF;
                int red = (pixel & 0xFF0000) >> 16 & 0xFF;
                int green = (pixel & 0xFF00) >> 8 & 0xFF;
                int blue = pixel & 0xFF;
                int gray = (red * 11 + green * 16 + blue * 5) / 32;
                int newpixel = (alpha << 24) + (gray << 16) + (gray << 8) + gray;
                dstImage.setPixel(x, y, newpixel);
            }
        }
        return dstImage;
    }

    private QtUtil() {
    }

    public static abstract class CreateQImageThread
    implements Runnable {
        private boolean end = false;
        private QImage qImage;

        public boolean isEnd() {
            return this.end;
        }

        public QImage getQImage() {
            return this.qImage;
        }

        protected abstract QImage createQImage();

        public void run() {
            this.qImage = this.createQImage();
            this.end = true;
        }
    }
}

