/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.gui.qt;

import com.trolltech.qt.gui.QImage;
import fr.ens.transcriptome.corsen.calc.CorsenResult;
import fr.ens.transcriptome.corsen.calc.Distance;
import fr.ens.transcriptome.corsen.calc.DistanceAnalyser;
import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.model.Particles3D;
import fr.ens.transcriptome.corsen.util.SystemUtil;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYDotRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerItem;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultGraphs {
    private static final int IMAGE_WIDTH_DEFAULT = 500;
    private static final int IMAGE_HEIGHT_DEFAULT = 500;
    private int width = 500;
    private int height = 500;
    private static final boolean TRANSPARENT_ENABLE = true;
    private static final Color TRANSPARENT_COLOR = new Color(255, 255, 255, 0);

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    private static final byte[] toByte(DataBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        int size = buffer.getSize();
        byte[] result = new byte[size * 4];
        for (int i = 0; i < size; ++i) {
            int val = buffer.getElem(i);
            int j = i * 4;
            result[j + 3] = (byte)((val & 0xFF000000) >> 24 & 0xFF);
            result[j + 2] = (byte)((val & 0xFF0000) >> 16 & 0xFF);
            result[j + 1] = (byte)((val & 0xFF00) >> 8 & 0xFF);
            result[j] = (byte)(val & 0xFF);
        }
        return result;
    }

    private static final double getMax(double[] array) {
        double max = Double.MIN_VALUE;
        if (array == null) {
            return max;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] > max)) continue;
            max = array[i];
        }
        return max;
    }

    private static final double getMin(double[] array) {
        double min = Double.MAX_VALUE;
        if (array == null) {
            return min;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] < min)) continue;
            min = array[i];
        }
        return min;
    }

    private static final String unitLegend(String unit) {
        if (unit == null) {
            return "";
        }
        String trimedUnit = unit.trim();
        if ("".equals(trimedUnit)) {
            return "";
        }
        return " (" + trimedUnit + ")";
    }

    private static final String unitLegendCude(String unit) {
        if (unit == null) {
            return "";
        }
        String trimedUnit = unit.trim();
        if ("".equals(trimedUnit)) {
            return "";
        }
        return " (" + trimedUnit + "\u00b3)";
    }

    private static final BoxAndWhiskerItem convertDistanceAnalyserToBoxAndWhiskerItem(DistanceAnalyser da) {
        if (da.count() == 0) {
            return null;
        }
        BoxAndWhiskerItem result = new BoxAndWhiskerItem(da.getMean(), da.getMedian(), da.getFirstQuartile(), da.getThirdQuartile(), da.getMinRegularValue(), da.getMaxRegularValue(), da.getMin(), da.getMax(), new ArrayList());
        return result;
    }

    private void addTransparency(JFreeChart chart) {
        if (SystemUtil.isWindowsSystem() || SystemUtil.isMacOsX()) {
            chart.setBackgroundPaint((Paint)TRANSPARENT_COLOR);
        }
    }

    private void createHistoDataSet(Map<Particle3D, Distance> dists, String name, HistogramDataset histogramdataset, int classes) {
        ArrayList<Float> list = new ArrayList<Float>();
        for (Map.Entry<Particle3D, Distance> e : dists.entrySet()) {
            long intensity = e.getKey().getIntensity();
            float distance = e.getValue().getDistance();
            int i = 0;
            while ((long)i < intensity) {
                list.add(Float.valueOf(distance));
                ++i;
            }
        }
        double[] data = new double[list.size()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = ((Float)list.get(i)).floatValue();
        }
        double max = ResultGraphs.getMax(data);
        double min = ResultGraphs.getMin(data);
        histogramdataset.addSeries((Comparable)((Object)name), data, classes, min, max);
    }

    public QImage createDistanceDistributionImage(double[] data, int classes, String unit) {
        if (data == null || data.length < 2) {
            return null;
        }
        HistogramDataset histogramdataset = new HistogramDataset();
        histogramdataset.addSeries((Comparable)((Object)"Min distances"), data, classes, ResultGraphs.getMin(data), ResultGraphs.getMax(data));
        JFreeChart chart = ChartFactory.createHistogram((String)"Distribution of minimal distances", (String)("Distance" + ResultGraphs.unitLegend(unit)), (String)"Cell number", (IntervalXYDataset)histogramdataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        this.addTransparency(chart);
        BufferedImage image = chart.createBufferedImage(this.width, this.height, 2, null);
        return new QImage(ResultGraphs.toByte(image.getData().getDataBuffer()), this.width, this.height, QImage.Format.Format_ARGB32);
    }

    public QImage createDistanceDistributionImage(CorsenResult results, int classes, String unit) {
        HistogramDataset histogramdataset = new HistogramDataset();
        this.createHistoDataSet(results.getMinDistances(), "Min distances", histogramdataset, classes);
        JFreeChart chart = ChartFactory.createHistogram((String)"Distribution of minimal distances", (String)("Distance" + ResultGraphs.unitLegend(unit)), (String)"Intensity", (IntervalXYDataset)histogramdataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        this.addTransparency(chart);
        BufferedImage image = chart.createBufferedImage(this.width, this.height, 2, null);
        return new QImage(ResultGraphs.toByte(image.getData().getDataBuffer()), this.width, this.height, QImage.Format.Format_ARGB32);
    }

    public QImage createBoxPlot(double[] data, String unit) {
        if (data == null || data.length < 2) {
            return null;
        }
        this.width /= 2;
        ArrayList<Float> listData = new ArrayList<Float>(data.length);
        for (int i = 0; i < data.length; ++i) {
            listData.add(Float.valueOf((float)data[i]));
        }
        DefaultBoxAndWhiskerCategoryDataset defaultboxandwhiskercategorydataset = new DefaultBoxAndWhiskerCategoryDataset();
        defaultboxandwhiskercategorydataset.add(listData, (Comparable)((Object)"Distances"), (Comparable)((Object)"Min"));
        JFreeChart chart = ChartFactory.createBoxAndWhiskerChart((String)"Intensities Boxplot", (String)"", (String)("Distance" + ResultGraphs.unitLegend(unit)), (BoxAndWhiskerCategoryDataset)defaultboxandwhiskercategorydataset, (boolean)false);
        this.addTransparency(chart);
        BufferedImage image = chart.createBufferedImage(this.width, this.height, 2, null);
        return new QImage(ResultGraphs.toByte(image.getData().getDataBuffer()), this.width, this.height, QImage.Format.Format_ARGB32);
    }

    public QImage createBoxPlot(CorsenResult results, String unit) {
        this.width /= 2;
        Map<Particle3D, Distance> distsMin = results.getMinDistances();
        Map<Particle3D, Distance> distsMax = results.getMaxDistances();
        if (distsMin == null || distsMax == null) {
            return null;
        }
        ArrayList<Float> listMin = new ArrayList<Float>();
        ArrayList<Float> listMax = new ArrayList<Float>();
        for (Map.Entry<Particle3D, Distance> e : distsMin.entrySet()) {
            Particle3D p = e.getKey();
            long intensity = p.getIntensity();
            float distanceMin = e.getValue().getDistance();
            float distanceMax = distsMax.get(p).getDistance();
            int i = 0;
            while ((long)i < intensity) {
                listMin.add(Float.valueOf(distanceMin));
                listMax.add(Float.valueOf(distanceMax));
                ++i;
            }
        }
        DefaultBoxAndWhiskerCategoryDataset defaultboxandwhiskercategorydataset = new DefaultBoxAndWhiskerCategoryDataset();
        if (results.getMinAnalyser().count() > 0) {
            defaultboxandwhiskercategorydataset.add(ResultGraphs.convertDistanceAnalyserToBoxAndWhiskerItem(results.getMinAnalyser()), (Comparable)((Object)"Distances"), (Comparable)((Object)"Min"));
        }
        JFreeChart chart = ChartFactory.createBoxAndWhiskerChart((String)"Intensities Boxplot", (String)"", (String)("Distance" + ResultGraphs.unitLegend(unit)), (BoxAndWhiskerCategoryDataset)defaultboxandwhiskercategorydataset, (boolean)false);
        this.addTransparency(chart);
        BufferedImage image = chart.createBufferedImage(this.width, this.height, 2, null);
        return new QImage(ResultGraphs.toByte(image.getData().getDataBuffer()), this.width, this.height, QImage.Format.Format_ARGB32);
    }

    public QImage createScatterPlot(Particles3D particles, String title, String unit) {
        if (particles == null) {
            return null;
        }
        List<Particle3D> pars = particles.getParticles();
        int count = pars.size();
        double[][] data = new double[][]{new double[count], new double[count]};
        int i = 0;
        for (Particle3D p : pars) {
            data[0][i] = p.getIntensity();
            data[1][i] = p.getVolume();
            ++i;
        }
        DefaultXYDataset xydataset = new DefaultXYDataset();
        xydataset.addSeries((Comparable)((Object)"data"), (double[][])data);
        JFreeChart chart = ChartFactory.createScatterPlot((String)title, (String)"Intensity", (String)("Volume" + ResultGraphs.unitLegendCude(unit)), (XYDataset)xydataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        this.addTransparency(chart);
        XYPlot xyplot = (XYPlot)chart.getPlot();
        XYDotRenderer xydotrenderer = new XYDotRenderer();
        xydotrenderer.setDotWidth(2);
        xydotrenderer.setDotHeight(2);
        xyplot.setRenderer((XYItemRenderer)xydotrenderer);
        NumberAxis numberaxis = (NumberAxis)xyplot.getDomainAxis();
        numberaxis.setAutoRangeIncludesZero(false);
        BufferedImage image = chart.createBufferedImage(this.width, this.height, 2, null);
        return new QImage(ResultGraphs.toByte(image.getData().getDataBuffer()), this.width, this.height, QImage.Format.Format_ARGB32);
    }
}

