/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.gui.qt;

import com.sun.opengl.util.GLUT;
import com.trolltech.qt.core.QPoint;
import com.trolltech.qt.core.QRect;
import com.trolltech.qt.core.QSize;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QMouseEvent;
import com.trolltech.qt.gui.QWheelEvent;
import com.trolltech.qt.gui.QWidget;
import com.trolltech.qt.opengl.QGL;
import com.trolltech.qt.opengl.QGLFormat;
import com.trolltech.qt.opengl.QGLWidget;
import fr.ens.transcriptome.corsen.Settings;
import fr.ens.transcriptome.corsen.calc.CorsenResult;
import fr.ens.transcriptome.corsen.calc.Distance;
import fr.ens.transcriptome.corsen.calc.JavascriptDistancesFilter;
import fr.ens.transcriptome.corsen.calc.ShowedParticlesDistancesFilter;
import fr.ens.transcriptome.corsen.gui.qt.CorsenGL;
import fr.ens.transcriptome.corsen.model.JavascriptParticles3DFilter;
import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.model.Particles3D;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.glu.GLU;

public class ViewOGL
extends QGLWidget {
    private static Logger logger = Logger.getLogger("Corsen");
    private GL gl;
    private GLU glu;
    private GLUT glut;
    private CorsenResult result;
    private Settings settings;
    private boolean drawNoMessengers;
    private boolean drawMessengersCuboids;
    private boolean drawNoMitos;
    private boolean drawMitosCuboids;
    private boolean drawBaryCenter;
    private boolean drawDistances;
    private String legend;
    private boolean remakeObject = true;
    private int gllist = 0;
    private int xRot = 0;
    private int yRot = 0;
    private int zRot = 0;
    private double zoom = 100.0;
    private static final double ZOOM_FACTOR = 1.2;
    QPoint lastPos;

    public CorsenResult getResult() {
        return this.result;
    }

    public boolean isDrawBaryCenter() {
        return this.drawBaryCenter;
    }

    public boolean isDrawDistances() {
        return this.drawDistances;
    }

    public boolean isDrawMessengersCuboids() {
        return this.drawMessengersCuboids;
    }

    public boolean isDrawMitosCuboids() {
        return this.drawMitosCuboids;
    }

    public boolean isRemakeObject() {
        return this.remakeObject;
    }

    public boolean isDrawNoMessengers() {
        return this.drawNoMessengers;
    }

    public boolean isDrawNoMitos() {
        return this.drawNoMitos;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void setDrawNoParticlesA(boolean drawNoMessengers) {
        this.drawNoMessengers = drawNoMessengers;
    }

    public void setDrawNoParticlesB(boolean drawNoMitos) {
        this.drawNoMitos = drawNoMitos;
    }

    public void setResult(CorsenResult result) {
        this.result = result;
    }

    public void setDrawBaryCenter(boolean drawBaryCenter) {
        this.drawBaryCenter = drawBaryCenter;
    }

    public void setDrawDistances(boolean drawDistances) {
        this.drawDistances = drawDistances;
    }

    public void setDrawParticlesACuboids(boolean drawMessengersCuboids) {
        this.drawMessengersCuboids = drawMessengersCuboids;
    }

    public void setDrawParticlesBCuboids(boolean drawMitosCuboids) {
        this.drawMitosCuboids = drawMitosCuboids;
    }

    public void setRemakeObject(boolean okToDraw) {
        this.remakeObject = okToDraw;
    }

    public void clear() {
        this.setResult(null);
        this.setRemakeObject(true);
        this.legend = null;
        this.repaint();
    }

    public void initializeGL() {
        GLContext context = GLDrawableFactory.getFactory().createExternalGLContext();
        this.gl = context.getGL();
        context.makeCurrent();
        this.glu = new GLU();
        this.glut = new GLUT();
        float[] l0pos = new float[]{0.0f, 2.0f, -1.0f};
        float[] l0dif = new float[]{0.3f, 0.3f, 0.8f};
        float[] l1pos = new float[]{2.0f, 2.0f, 2.0f};
        float[] l1dif = new float[]{0.5f, 0.5f, 0.5f};
        this.gl.glEnable(2929);
        this.gl.glShadeModel(7425);
        this.gl.glLightModeli(2897, 1);
        this.gl.glEnable(2896);
        this.gl.glEnable(16384);
        this.gl.glEnable(16385);
        this.gl.glLightfv(16384, 4609, l0dif, 0);
        this.gl.glLightfv(16384, 4610, l0dif, 0);
        this.gl.glLightfv(16384, 4611, l1pos, 0);
        this.gl.glLightfv(16385, 4609, l1dif, 0);
        this.gl.glLightfv(16385, 4610, l1dif, 0);
        this.gl.glLightfv(16385, 4611, l1pos, 0);
        float[] pos0 = new float[]{5.0f, 5.0f, 10.0f, 0.0f};
        float[] pos1 = new float[]{-5.0f, 5.0f, -10.0f, 0.0f};
        this.gl.glLightfv(16384, 4611, pos0, 0);
        this.gl.glLightfv(16385, 4611, pos1, 0);
        this.gl.glEnable(2896);
        this.gl.glEnable(16385);
        this.gl.glMatrixMode(5889);
        this.gl.glEnable(2977);
        this.gl.glEnable(2929);
        long start = System.currentTimeMillis();
        this.make3DObject();
        this.drawLegend();
        long end = System.currentTimeMillis();
        logger.info("3D render in " + (end - start) + " ms.");
    }

    public void drawLegend() {
        if (this.legend == null) {
            CorsenResult r = this.getResult();
            if (r == null || r.getParticlesA() == null) {
                this.legend = "";
            } else {
                String unit = r.getParticlesA().getUnitOfLength();
                this.legend = "Scale: 10 " + unit;
            }
        }
        this.renderText(5, 15, this.legend);
    }

    public void resizeGL(int width, int height) {
        int side = width <= height ? height : width;
        this.gl.glViewport((width - side) / 2, (height - side) / 2, side, side);
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        this.gl.glOrtho(-this.zoom, this.zoom, this.zoom, -this.zoom, -1000.0, 1000.0);
        this.gl.glMatrixMode(5888);
    }

    public void paintGL() {
        this.gl.glClear(16640);
        this.gl.glLoadIdentity();
        this.gl.glTranslated(0.0, 0.0, -10.0);
        this.gl.glRotated((double)this.xRot / 16.0, 1.0, 0.0, 0.0);
        this.gl.glRotated((double)this.yRot / 16.0, 0.0, 1.0, 0.0);
        this.gl.glRotated((double)this.zRot / 16.0, 0.0, 0.0, 1.0);
        if (this.isRemakeObject()) {
            this.make3DObject();
        }
        this.drawLegend();
        this.gl.glMatrixMode(5888);
        this.gl.glCallList(this.gllist);
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        this.gl.glOrtho(-this.zoom, this.zoom, this.zoom, -this.zoom, -1000.0, 1000.0);
        this.gl.glMatrixMode(5888);
    }

    public void mousePressEvent(QMouseEvent event) {
        this.lastPos = event.pos();
    }

    public void mouseMoveEvent(QMouseEvent event) {
        int dx = event.x() - this.lastPos.x();
        int dy = event.y() - this.lastPos.y();
        if (event.buttons().value() == Qt.MouseButton.LeftButton.value()) {
            this.setXRotation(this.xRot + 8 * dy);
            this.setYRotation(this.yRot + 8 * dx);
        } else if (event.buttons().value() == Qt.MouseButton.RightButton.value()) {
            this.setXRotation(this.xRot + 8 * dy);
            this.setZRotation(this.zRot + 8 * dx);
        }
        this.lastPos = event.pos();
    }

    public void wheelEvent(QWheelEvent event) {
        double zoom;
        this.zoom = event.delta() > 0 ? (zoom = this.zoom * 1.2) : (zoom = this.zoom / 1.2);
        QRect geo = this.geometry();
        this.resize(geo.width(), geo.height());
        this.updateGL();
    }

    public void setXRotation(int angle) {
        if ((angle = this.normalizeAngle(angle)) != this.xRot) {
            this.xRot = angle;
            this.updateGL();
        }
    }

    public void setYRotation(int angle) {
        if ((angle = this.normalizeAngle(angle)) != this.yRot) {
            this.yRot = angle;
            this.updateGL();
        }
    }

    public void setZRotation(int angle) {
        if ((angle = this.normalizeAngle(angle)) != this.zRot) {
            this.zRot = angle;
            this.updateGL();
        }
    }

    private float transparencyToAlpha(int transparency) {
        return 1.0f - (float)transparency / 100.0f;
    }

    private void make3DObject() {
        if (this.gl == null) {
            return;
        }
        this.setRemakeObject(false);
        if (this.gllist >= 0) {
            this.gl.glDeleteLists(this.gllist, 1);
        }
        int list = this.gl.glGenLists(++this.gllist);
        this.gl.glNewList(list, 4864);
        CorsenGL cgl = new CorsenGL(this.gl, this);
        CorsenResult r = this.getResult();
        Settings s = this.settings;
        if (r != null) {
            if (r.getParticlesA() != null) {
                Particles3D pars = r.getParticlesA();
                this.gl.glTranslated((double)((float)(-1 * pars.getWidth()) * pars.getPixelWidth() / 2.0f), (double)((float)(-1 * pars.getHeight()) * pars.getPixelHeight() / 2.0f), (double)((float)(-1 * pars.getZSlices()) * pars.getPixelDepth() / 2.0f));
            }
            Particles3D particlesA = null;
            Particles3D particlesB = null;
            JavascriptParticles3DFilter filterA = JavascriptParticles3DFilter.createFilter(s.getParticlesAViewFilterExpression());
            JavascriptParticles3DFilter filterB = JavascriptParticles3DFilter.createFilter(s.getParticlesBViewFilterExpression());
            if (r.getParticlesA() != null && !this.isDrawNoMessengers()) {
                if (r.getCuboidsParticlesA() == null) {
                    particlesA = r.getParticlesA().filter(filterA);
                } else {
                    Particles3D particles3D = particlesA = this.isDrawMessengersCuboids() ? r.getCuboidsParticlesA().filter(filterA) : r.getParticlesA().filter(filterA);
                }
            }
            if (r.getParticlesB() != null && !this.isDrawNoMitos()) {
                if (r.getCuboidsParticlesB() == null) {
                    particlesB = r.getParticlesB().filter(filterB);
                } else {
                    Particles3D particles3D = particlesB = this.isDrawMitosCuboids() ? r.getCuboidsParticlesB().filter(filterB) : r.getParticlesB().filter(filterB);
                }
            }
            if (particlesA != null) {
                cgl.drawParticles(particlesA, s.getColorParticlesA(), this.isDrawBaryCenter(), s.getColorBaryCenters(), s.isVisualisationParticlesAInDifferentsColor(), this.transparencyToAlpha(s.getParticlesATransparency()));
            }
            if (this.isDrawBaryCenter() && r.getParticlesA() != null) {
                Particles3D particlesBarycenter = r.getCuboidsParticlesA() == null ? r.getParticlesA().filter(filterA) : (!this.isDrawMessengersCuboids() ? r.getCuboidsParticlesA().filter(filterA) : r.getParticlesA().filter(filterA));
                cgl.drawBarycenter(particlesBarycenter, s.getColorBaryCenters());
            }
            if (particlesB != null) {
                cgl.drawParticles(particlesB, s.getColorParticlesB(), false, null, s.isVisualisationParticlesBInDifferentsColor(), this.transparencyToAlpha(s.getParticlesBTransparency()));
            }
            if (this.isDrawDistances() && r.getMinDistances() != null) {
                HashMap<Particle3D, Distance> distancesToShow = null;
                JavascriptDistancesFilter jsdf = s.isDistancesViewFilterEnabled() ? JavascriptDistancesFilter.createFilter(s.getDistancesViewFilterExpression()) : null;
                ShowedParticlesDistancesFilter spf = s.isFilterShowDistanceShowedParticles() ? new ShowedParticlesDistancesFilter(r.getCuboidsParticlesA().filter(filterA), r.getCuboidsParticlesB().filter(filterB)) : null;
                distancesToShow = new HashMap<Particle3D, Distance>();
                for (Map.Entry<Particle3D, Distance> e : r.getMinDistances().entrySet()) {
                    Distance d = e.getValue();
                    boolean f1 = true;
                    if (jsdf != null) {
                        f1 = jsdf.accept(d);
                    }
                    boolean f2 = true;
                    if (spf != null) {
                        f2 = spf.accept(d);
                    }
                    if (!f1 || !f2) continue;
                    distancesToShow.put(e.getKey(), d);
                }
                cgl.drawDistances(distancesToShow, s.getColorDistances(), s.isVisualizationShowNegativeDistances());
            }
        }
        cgl.drawAxis();
        this.gl.glEndList();
        this.gllist = list;
    }

    private int normalizeAngle(int angle) {
        if (angle < 0) {
            return angle += 5760;
        }
        if (angle > 5760) {
            return angle -= 5760;
        }
        return angle;
    }

    public QSize sizeHint() {
        int height;
        int width = this.size().width();
        int side = width <= (height = this.size().height()) ? width : height;
        return new QSize(side, side);
    }

    public ViewOGL(QWidget widget) {
        super(new QGLFormat(new QGL.FormatOptions(new QGL.FormatOption[]{QGL.FormatOption.DoubleBuffer, QGL.FormatOption.DepthBuffer, QGL.FormatOption.DirectRendering})));
    }
}

