/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.gui.swing;

import fr.ens.transcriptome.corsen.CorsenCore;
import fr.ens.transcriptome.corsen.ProgressEvent;
import fr.ens.transcriptome.corsen.UpdateStatus;
import fr.ens.transcriptome.corsen.calc.CorsenResult;
import fr.ens.transcriptome.corsen.gui.swing.CorsenUI;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;

public class CorsenSwing
implements UpdateStatus {
    private static final String WINDOWS_PLAF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private static final CorsenSwing corsen = new CorsenSwing();
    private CorsenUI gui;
    private final StatusInfo status = new StatusInfo();

    public void show() {
        this.gui.show();
        if (CorsenSwing.isWindowsSystem()) {
            CorsenSwing.setLookAndFeel(WINDOWS_PLAF);
        }
    }

    public void showError(String msg) {
        if (this.gui != null && msg != null) {
            this.gui.showError(msg);
        }
    }

    public void showMessage(String msg) {
        if (this.gui != null && msg != null) {
            JOptionPane.showMessageDialog(this.gui, msg);
        }
    }

    private CorsenSwing() {
        FileFilter ffPar = new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                if (f.getName().length() < 4) {
                    return false;
                }
                String end = f.getName().substring(f.getName().length() - 4);
                return end.toLowerCase().endsWith(".par");
            }

            public String getDescription() {
                return "Corsen ImageJ plugin result file";
            }
        };
        this.gui = new CorsenUI(ffPar);
        this.gui.setZCoef(2.96f);
        this.gui.setPixelSize(1.0f);
        this.gui.setDefaultCloseOperation(3);
        this.gui.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CorsenCore cc = new CorsenCore();
                cc.getSettings().setZFactor(CorsenSwing.this.gui.getZCoef());
                cc.getSettings().setFactor(CorsenSwing.this.gui.getPixelSize());
                cc.setUpdateStatus(CorsenSwing.this);
                if (CorsenSwing.this.gui.getDirFile() != null) {
                    cc.setDirFiles(CorsenSwing.this.gui.getDirFile());
                    cc.setMultipleFiles(true);
                    new Thread(cc).start();
                } else if (CorsenSwing.this.gui.getARNFile() == null || CorsenSwing.this.gui.getMitoFile() == null) {
                    if (CorsenSwing.this.gui.getARNFile() == null) {
                        CorsenSwing.this.gui.showError("No messager file specified.");
                    } else {
                        CorsenSwing.this.gui.showError("No mito file specified.");
                    }
                } else {
                    int result;
                    JFileChooser jfc = new JFileChooser();
                    if (CorsenSwing.this.gui.getCurrentDirectory() != null) {
                        jfc.setCurrentDirectory(CorsenSwing.this.gui.getCurrentDirectory());
                    }
                    if ((result = jfc.showSaveDialog(CorsenSwing.this.gui)) == 0) {
                        cc.setParticlesBFile(CorsenSwing.this.gui.getMitoFile());
                        cc.setParticlesAFile(CorsenSwing.this.gui.getARNFile());
                        cc.setResultFile(jfc.getSelectedFile());
                        cc.setMultipleFiles(false);
                        new Thread(cc).start();
                    }
                }
            }
        });
    }

    public void endProcess(CorsenResult result) {
    }

    public void updateStatus(ProgressEvent e) {
        if (e == null) {
            return;
        }
        switch (e.getType()) {
            case START_CELL_EVENT: {
                long last = this.status.cellStart;
                this.status.cellStart = System.currentTimeMillis();
                this.status.currentFile = e.getIntValue1();
                this.status.maxFiles = e.getIntValue2();
                if (this.status.currentFile == 1) {
                    this.gui.setStartEnable(false);
                    this.status.initStart = this.status.cellStart;
                    this.status.phaseStart = 0L;
                    break;
                }
                System.out.println("\n---\n\nProcess cell in " + ((long)this.status.currentFile - last));
                break;
            }
            case START_READ_PARTICLES_A_FILE_EVENT: 
            case START_READ_PARTICLES_B_FILE_EVENT: 
            case START_CHANGE_PARTICLES_A_COORDINATES_EVENT: 
            case START_CHANGE_PARTICLES_B_COORDINATES_EVENT: 
            case START_CALC_PARTICLES_A_CUBOIDS_EVENT: 
            case START_CALC_PARTICLES_B_CUBOIDS_EVENT: 
            case START_CALC_MIN_DISTANCES_EVENT: 
            case START_WRITE_DATA_EVENT: 
            case START_WRITE_IV_PARTICLES_A_EVENT: 
            case START_WRITE_IV_PARTICLES_B_EVENT: 
            case START_WRITE_IV_PARTICLES_A_CUBOIDS_EVENT: 
            case START_WRITE_FULLRESULT_EVENT: 
            case START_WRITE_RPLOT_PARTICLES_A_EVENT: 
            case START_WRITE_RPLOT_PARTICLES_B_EVENT: 
            case START_WRITE_RPLOT_PARTICLES_A_CUBOIDS_EVENT: 
            case START_WRITE_RPLOT_PARTICLES_B_CUBOIDS_EVENT: 
            case START_WRITE_RPLOT_DISTANCES_EVENT: {
                this.status.phaseStart = System.currentTimeMillis();
                this.status.currentPhase = e.getType().ordinal();
                break;
            }
            case PROGRESS_CALC_PARTICLES_A_CUBOIDS_EVENT: 
            case PROGRESS_CALC_PARTICLES_B_CUBOIDS_EVENT: {
                this.status.phaseIndex = e.getIntValue1();
                break;
            }
            case END_CELLS_SUCCESSFULL_EVENT: {
                long end = System.currentTimeMillis();
                System.out.println("Finish in " + (end - this.status.initStart) + " ms");
                this.gui.setStartEnable(true);
                this.gui.setStatusMessage("Ready");
                return;
            }
            case END_ERROR_EVENT: {
                this.gui.setStartEnable(true);
                this.gui.setStatusMessage("Ready");
                return;
            }
            default: {
                return;
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Cell: ");
        sb.append(this.status.currentFile);
        sb.append("/");
        sb.append(this.status.maxFiles);
        sb.append(" Phase: ");
        sb.append(this.status.currentPhase);
        sb.append("/11 (");
        sb.append(e.getType().toString());
        if (this.status.currentPhase == ProgressEvent.ProgressEventType.START_CALC_PARTICLES_A_CUBOIDS_EVENT.ordinal() || this.status.currentPhase == ProgressEvent.ProgressEventType.START_CALC_PARTICLES_B_CUBOIDS_EVENT.ordinal()) {
            sb.append(" ");
            sb.append((double)this.status.phaseIndex / 10.0);
            sb.append("%");
        }
        sb.append(")");
        this.gui.setStatusMessage(sb.toString());
    }

    public void moveToThread(Thread thread) {
    }

    public UpdateStatus chain() {
        return this;
    }

    public Thread newThread(Runnable runnable) {
        return new Thread(runnable);
    }

    public static boolean isWindowsSystem() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    private static void setLookAndFeel(final String uiClassName) {
        if (uiClassName == null) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        CorsenSwing.setLookAndFeel(uiClassName);
                    }
                });
            }
            catch (InterruptedException e) {
                System.err.println("Error when trying to use the Event dispatch thread.");
            }
            catch (InvocationTargetException e) {
                System.err.println("Error when trying to use the Event dispatch thread.");
            }
        } else {
            try {
                Class<?> c = CorsenSwing.class.getClassLoader().loadClass(uiClassName);
                LookAndFeel laf = (LookAndFeel)c.newInstance();
                UIManager.setLookAndFeel(laf);
            }
            catch (ClassNotFoundException e) {
                System.err.println("PLAF error, class not found: " + uiClassName);
                return;
            }
            catch (InstantiationException e) {
                System.err.println("PLAF error, instantiation exception: " + uiClassName);
                return;
            }
            catch (IllegalAccessException e) {
                System.err.println("PLAF error, illegal access: " + uiClassName);
                return;
            }
            catch (UnsupportedLookAndFeelException e) {
                System.err.println("PLAF error, unssopported look and feel: " + uiClassName);
                return;
            }
        }
    }

    private static void top() {
        System.out.print("Free mem: " + String.valueOf(Runtime.getRuntime().freeMemory() / 1024L));
        System.out.print(" Kb\tTot  mem: " + String.valueOf(Runtime.getRuntime().totalMemory() / 1024L));
        System.out.println(" Kb\t Thread n: " + String.valueOf(Thread.activeCount()));
    }

    public static void main(String[] args) throws IOException {
        JFrame.setDefaultLookAndFeelDecorated(true);
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        new CorsenSwing().show();
    }

    private static final class StatusInfo {
        int currentFile;
        int maxFiles;
        int currentPhase;
        int phaseIndex;
        int phaseEnd;
        long phaseStart;
        long cellStart;
        long initStart;

        private StatusInfo() {
        }
    }
}

