/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.gui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class CorsenUI
extends JFrame {
    private static final long serialVersionUID = -1337483720840258361L;
    private JPanel jContentPane = null;
    private File arnFile = null;
    private File mitoFile = null;
    private File dirFile = null;
    private final JLabel dirLabel = new JLabel("no derectory set");
    private final JLabel arnLabel = new JLabel("no file set");
    private final JLabel mitoLabel = new JLabel("no file set");
    private final JTextField zCoefTextField = new JTextField("");
    private final JCheckBox zCoefCheckBox = new JCheckBox();
    private final JTextField pixelSizeTextField = new JTextField("");
    private final JLabel statusBar = new JLabel("Ready");
    private final JButton startButton = new JButton("Start");
    private File currentDirectory;
    private FileFilter ff;

    public void addActionListener(ActionListener al) {
        this.startButton.addActionListener(al);
    }

    public File getMitoFile() {
        return this.mitoFile;
    }

    public File getARNFile() {
        return this.arnFile;
    }

    public File getDirFile() {
        return this.dirFile;
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public float getPixelSize() {
        String s = this.pixelSizeTextField.getText();
        if (s == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public void setPixelSize(float pixelSize) {
        this.pixelSizeTextField.setText("" + pixelSize);
    }

    public float getZCoef() {
        String s = this.zCoefTextField.getText();
        if (s == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public void setZCoef(float zCoef) {
        this.zCoefTextField.setText("" + zCoef);
    }

    public boolean isUpdateZ() {
        return this.zCoefCheckBox.isSelected();
    }

    public void setStartEnable(boolean value) {
        if (this.startButton != null) {
            this.startButton.setEnabled(value);
        }
    }

    public void showError(String error) {
        JOptionPane.showMessageDialog(this.getJContentPane(), error, "Error", 0);
    }

    public void setStatusMessage(String message) {
        if (message == null) {
            return;
        }
        this.statusBar.setText(message);
    }

    public CorsenUI() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setContentPane(this.getJContentPane());
        this.setTitle("JFrame");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            JPanel superPanel = new JPanel();
            superPanel.setLayout(new BorderLayout());
            superPanel.add((Component)this.startButton, "South");
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            final JPanel panelDir = new JPanel();
            panelDir.setLayout(new BorderLayout());
            panel.add(panelDir);
            panelDir.add((Component)new JLabel("Directory data"), "West");
            this.dirLabel.setEnabled(false);
            this.dirLabel.setHorizontalAlignment(0);
            panelDir.add((Component)this.dirLabel, "Center");
            JButton dirButton = new JButton("Browse");
            dirButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int result;
                    JFileChooser jfc = new JFileChooser();
                    jfc.setFileSelectionMode(1);
                    if (CorsenUI.this.getCurrentDirectory() != null) {
                        jfc.setCurrentDirectory(CorsenUI.this.getCurrentDirectory());
                    }
                    if ((result = jfc.showOpenDialog(panelDir)) == 0) {
                        CorsenUI.this.dirFile = jfc.getSelectedFile();
                        CorsenUI.this.dirLabel.setText(CorsenUI.this.dirFile.getName());
                        CorsenUI.this.currentDirectory = CorsenUI.this.dirFile.getParentFile();
                    }
                }
            });
            panelDir.add((Component)dirButton, "East");
            final JPanel panelMessagers = new JPanel();
            panelMessagers.setLayout(new BorderLayout());
            panel.add(panelMessagers);
            panelMessagers.add((Component)new JLabel("Messager data"), "West");
            this.arnLabel.setEnabled(false);
            this.arnLabel.setHorizontalAlignment(0);
            panelMessagers.add((Component)this.arnLabel, "Center");
            JButton arnButton = new JButton("Browse");
            arnButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int result;
                    JFileChooser jfc = new JFileChooser();
                    jfc.addChoosableFileFilter(CorsenUI.this.ff);
                    if (CorsenUI.this.getCurrentDirectory() != null) {
                        jfc.setCurrentDirectory(CorsenUI.this.getCurrentDirectory());
                    }
                    if ((result = jfc.showOpenDialog(panelMessagers)) == 0) {
                        CorsenUI.this.arnFile = jfc.getSelectedFile();
                        CorsenUI.this.arnLabel.setText(CorsenUI.this.arnFile.getName());
                        CorsenUI.this.currentDirectory = CorsenUI.this.arnFile.getParentFile();
                    }
                }
            });
            panelMessagers.add((Component)arnButton, "East");
            JPanel panelMito = new JPanel();
            panelMito.setLayout(new BorderLayout());
            panel.add(panelMito);
            panelMito.add((Component)new JLabel("Mito data"), "West");
            this.mitoLabel.setEnabled(false);
            this.mitoLabel.setHorizontalAlignment(0);
            panelMito.add((Component)this.mitoLabel, "Center");
            JButton mitoButton = new JButton("Browse");
            mitoButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int result;
                    JFileChooser jfc = new JFileChooser();
                    jfc.addChoosableFileFilter(CorsenUI.this.ff);
                    if (CorsenUI.this.getCurrentDirectory() != null) {
                        jfc.setCurrentDirectory(CorsenUI.this.getCurrentDirectory());
                    }
                    if ((result = jfc.showOpenDialog(panelMessagers)) == 0) {
                        CorsenUI.this.mitoFile = jfc.getSelectedFile();
                        CorsenUI.this.mitoLabel.setText(CorsenUI.this.mitoFile.getName());
                        CorsenUI.this.currentDirectory = CorsenUI.this.mitoFile.getParentFile();
                    }
                }
            });
            panelMito.add((Component)mitoButton, "East");
            JPanel panelCoefZ = new JPanel();
            panelCoefZ.setLayout(new BorderLayout());
            panel.add(panelCoefZ);
            panelCoefZ.add((Component)this.zCoefCheckBox, "West");
            panelCoefZ.add((Component)new JLabel("Z Coef: "), "Center");
            panelCoefZ.setEnabled(false);
            this.zCoefTextField.setHorizontalAlignment(4);
            panelCoefZ.add((Component)this.zCoefTextField, "East");
            JPanel panelPixelSize = new JPanel();
            panelPixelSize.setLayout(new BorderLayout());
            panel.add(panelPixelSize);
            panelPixelSize.add((Component)new JLabel("Pixel size: "), "West");
            panelPixelSize.setEnabled(false);
            this.pixelSizeTextField.setHorizontalAlignment(4);
            panelPixelSize.add((Component)this.pixelSizeTextField, "East");
            superPanel.add((Component)panel, "Center");
            this.jContentPane.add((Component)superPanel, "Center");
            this.jContentPane.add((Component)this.statusBar, "South");
        }
        return this.jContentPane;
    }

    public CorsenUI(FileFilter ff) {
        this();
        this.ff = ff;
    }

    public static void main(String[] args) {
        new CorsenUI().show();
    }
}

