/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.imagej;

import fr.ens.transcriptome.corsen.model.Particle2D;
import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.model.Point2D;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;

public final class CorsenImageJUtil {
    public static ImagePlus createImageParticles3D(int width, int height, Particle3D particle) {
        return CorsenImageJUtil.createImageParticles3D(null, width, height, particle);
    }

    public static ImagePlus createImageParticles3D(String title, int width, int height, Particle3D particle) {
        if (particle == null) {
            return null;
        }
        return CorsenImageJUtil.createImageParticles2D(title == null ? particle.getName() : "noname", width, height, particle.toParticles2D());
    }

    public static ImagePlus createImageParticles2D(String title, int width, int height, Particle2D[] particles) {
        if (particles == null || particles.length == 0 || width < 0 || height < 0) {
            return null;
        }
        ImageStack stack = new ImageStack(width, height);
        for (int i = 0; i < particles.length; ++i) {
            ByteProcessor drawIP = new ByteProcessor(width, height);
            stack.addSlice(null, (ImageProcessor)drawIP);
            drawIP.setColor(Color.white);
            drawIP.fill();
            drawIP.setColor(Color.black);
            CorsenImageJUtil.drawParticle((ImageProcessor)drawIP, particles[i]);
        }
        return new ImagePlus(title, stack);
    }

    private static void drawParticle(ImageProcessor ip, Particle2D particle) {
        CorsenImageJUtil.drawParticle(ip, particle, Color.GRAY);
    }

    private static void drawParticle(ImageProcessor ip, Particle2D particle, Color color) {
        int y;
        int x;
        Point2D pt;
        int i;
        if (particle == null) {
            return;
        }
        int nSurface = particle.surfacePointsCount();
        int nInner = particle.innerPointsCount();
        ip.setColor(color);
        float pixelWidth = particle.getPixelWidth();
        float pixelHeight = particle.getPixelHeight();
        for (i = 0; i < nInner; ++i) {
            pt = particle.getInnerPoint(i);
            x = (int)(pt.getX() / pixelWidth);
            y = (int)(pt.getY() / pixelHeight);
            ip.drawPixel(x, y);
        }
        ip.setColor(Color.BLACK);
        for (i = 0; i < nSurface; ++i) {
            pt = particle.getSurfacePoint(i);
            x = (int)(pt.getX() / pixelWidth);
            y = (int)(pt.getY() / pixelHeight);
            ip.drawPixel(x, y);
        }
    }

    public static void addParticle3DtoStack(ImageStack stack, Particle3D particle, Color color) {
        if (stack == null || particle == null) {
            return;
        }
        Color colorToDraw = color == null ? Color.white : color;
        int minStack = (int)(particle.getInnerPoints().getZMin() / particle.getPixelDepth());
        Particle2D[] pars2d = particle.toParticles2D();
        int surfaceCountPixel = 0;
        for (int i = 0; i < pars2d.length; ++i) {
            surfaceCountPixel += pars2d[i].surfacePointsCount();
            ImageProcessor drawIP = stack.getProcessor(minStack + i);
            CorsenImageJUtil.drawParticle(drawIP, pars2d[i], colorToDraw);
        }
    }

    private CorsenImageJUtil() {
    }
}

