/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.imagej;

import fr.ens.transcriptome.corsen.model.Particle2D;
import fr.ens.transcriptome.corsen.model.Particle2DBuilder;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Segmentation2DRunner {
    private int xLen;
    private int yLen;
    private int width;
    private int height;
    private int[][] arrayImage;
    private boolean[][] arrayDone;
    private List<Particle2D> particles = new ArrayList<Particle2D>();
    private double minThreshold;
    private double maxThreshold;
    private float pixelWidth;
    private float pixelHeight;

    public List<Particle2D> getParticles2D(ImageProcessor ip) {
        this.particles.clear();
        this.xLen = ip.getWidth();
        this.yLen = ip.getHeight();
        this.minThreshold = ip.getMinThreshold();
        this.maxThreshold = ip.getMaxThreshold();
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        this.arrayImage = ip.getIntArray();
        this.intArrayDone();
        for (int i = 0; i < this.xLen; ++i) {
            for (int j = 0; j < this.yLen; ++j) {
                if (this.getPixelMask(i, j) <= 0 || this.isPixelDone(i, j)) continue;
                this.particles.add(this.buildParticle(i, j));
            }
        }
        return this.particles;
    }

    private final Particle2D buildParticle(int x, int y) {
        Particle2DBuilder result = new Particle2DBuilder(this.pixelWidth, this.pixelHeight, this.width, this.height);
        LinkedList<Integer> queueX = new LinkedList<Integer>();
        LinkedList<Integer> queueY = new LinkedList<Integer>();
        queueX.add(x);
        queueY.add(y);
        while (queueX.size() != 0) {
            this.addPoint(result, (Integer)queueX.poll(), (Integer)queueY.poll(), queueX, queueY);
        }
        return result.getParticle();
    }

    private final void addPoint(Particle2DBuilder particle, int x, int y, Queue<Integer> queueX, Queue<Integer> queueY) {
        if (this.isPixelDone(x, y)) {
            return;
        }
        byte count = 0;
        count = this.testPoint(x - 1, y - 1, count, queueX, queueY);
        count = this.testPoint(x, y - 1, count, queueX, queueY);
        count = this.testPoint(x + 1, y - 1, count, queueX, queueY);
        count = this.testPoint(x - 1, y, count, queueX, queueY);
        count = this.testPoint(x, y, count, queueX, queueY);
        count = this.testPoint(x + 1, y, count, queueX, queueY);
        count = this.testPoint(x - 1, y + 1, count, queueX, queueY);
        count = this.testPoint(x, y + 1, count, queueX, queueY);
        count = this.testPoint(x + 1, y + 1, count, queueX, queueY);
        int value = this.getPixelImage(x, y);
        float xReal = ((float)x + 0.5f) * this.pixelWidth;
        float yReal = ((float)y + 0.5f) * this.pixelHeight;
        particle.addInnerPoint(xReal, yReal, value);
        if (count < 9) {
            particle.addSurfacePoint(xReal, yReal, value);
        }
        this.setPixelDone(x, y);
    }

    private final void intArrayDone() {
        this.arrayDone = new boolean[this.yLen][];
        for (int i = 0; i < this.yLen; ++i) {
            this.arrayDone[i] = new boolean[this.xLen];
        }
    }

    private final int getPixelImage(int x, int y) {
        if (x < 0 || y < 0 || x >= this.xLen || y >= this.yLen) {
            return 0;
        }
        return this.arrayImage[x][y];
    }

    private final int getPixelMask(int x, int y) {
        if (x < 0 || y < 0 || x >= this.xLen || y >= this.yLen) {
            return 0;
        }
        int value = this.arrayImage[x][y];
        if ((double)value < this.minThreshold || (double)value > this.maxThreshold) {
            return 0;
        }
        return value;
    }

    private final boolean isPixelDone(int x, int y) {
        if (x < 0 || y < 0 || x >= this.xLen || y >= this.yLen) {
            return true;
        }
        return this.arrayDone[y][x];
    }

    private final void setPixelDone(int x, int y) {
        if (x < 0 || y < 0 || x >= this.xLen || y >= this.yLen) {
            return;
        }
        this.arrayDone[y][x] = true;
    }

    private final byte testPoint(int x, int y, byte count, Queue<Integer> queueX, Queue<Integer> queueY) {
        if (this.getPixelMask(x, y) > 0) {
            if (!this.isPixelDone(x, y)) {
                queueX.add(x);
                queueY.add(y);
            }
            return (byte)(count + 1);
        }
        return count;
    }

    public Segmentation2DRunner(double pixelWidth, double pixelHeight) {
        this.pixelWidth = (float)pixelWidth;
        this.pixelHeight = (float)pixelHeight;
    }
}

