/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.imagej;

import fr.ens.transcriptome.corsen.model.Particle2D;
import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.model.Particle3DBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Segmentation3DRunner {
    private Set<Particle2D> previousParticules2D = new HashSet<Particle2D>();
    private Set<Particle2D> currentParticles2D = new HashSet<Particle2D>();
    private Map<Particle2D, Particle3DBuilder> previousParticles3D = new HashMap<Particle2D, Particle3DBuilder>();
    private Map<Particle2D, Particle3DBuilder> currentParticles3D = new HashMap<Particle2D, Particle3DBuilder>();
    private Set<Particle3DBuilder> particles3D = new HashSet<Particle3DBuilder>();
    private int previousZ = -1;
    private static final boolean DEBUG = false;
    private int totalPixels2D = 0;

    public void clear() {
        this.previousParticules2D.clear();
        this.currentParticles2D.clear();
        this.previousParticles3D.clear();
        this.currentParticles3D.clear();
        this.particles3D.clear();
        this.previousZ = -1;
        this.totalPixels2D = 0;
    }

    public void addParticles2DForSegmentation3D(List<Particle2D> particles2D, int slice, double pixelDepth, String imageTitle) {
        if (particles2D == null) {
            return;
        }
        for (Particle2D par : particles2D) {
            this.addParticle2DForSegmentation3D(par, slice, (float)pixelDepth, imageTitle);
        }
    }

    private void addParticle2DForSegmentation3D(Particle2D particle2D, int slice, float pixelDepth, String imageTitle) {
        if (slice - 1 != this.previousZ) {
            this.previousParticules2D = this.currentParticles2D;
            this.currentParticles2D = new HashSet<Particle2D>();
            this.previousParticles3D = this.currentParticles3D;
            this.currentParticles3D = new HashMap<Particle2D, Particle3DBuilder>();
            this.previousZ = this.previousZ == -1 ? slice - 1 : ++this.previousZ;
        }
        this.totalPixels2D += particle2D.innerPointsCount();
        boolean find = false;
        for (Particle2D p2DToTest : this.previousParticules2D) {
            if (!p2DToTest.innerPointIntersect(particle2D)) continue;
            Particle3DBuilder existingP3D = this.previousParticles3D.get(p2DToTest);
            if (!find) {
                existingP3D.add(particle2D, slice);
                find = true;
            }
            if (this.currentParticles3D.containsKey(particle2D)) {
                Particle3DBuilder particle3D2 = this.currentParticles3D.get(particle2D);
                if (particle3D2.getId() == existingP3D.getId()) continue;
                particle3D2.add(existingP3D);
                this.replaceOccurances(this.previousParticles3D, existingP3D, particle3D2);
                this.replaceOccurances(this.currentParticles3D, existingP3D, particle3D2);
                this.particles3D.remove(existingP3D);
                continue;
            }
            this.currentParticles3D.put(particle2D, existingP3D);
        }
        if (!find) {
            Particle3DBuilder newP3D = new Particle3DBuilder(particle2D.getPixelWidth(), particle2D.getPixelHeight(), pixelDepth);
            newP3D.setName(imageTitle + "-" + newP3D.getId());
            newP3D.add(particle2D, slice);
            this.particles3D.add(newP3D);
            this.currentParticles3D.put(particle2D, newP3D);
        }
        this.currentParticles2D.add(particle2D);
    }

    private void replaceOccurances(Map<Particle2D, Particle3DBuilder> map, Particle3DBuilder oldParticle3D, Particle3DBuilder newParticle3D) {
        if (map == null || oldParticle3D == null || newParticle3D == null) {
            return;
        }
        for (Map.Entry<Particle2D, Particle3DBuilder> e : map.entrySet()) {
            Particle3DBuilder value = e.getValue();
            if (value != oldParticle3D) continue;
            map.put(e.getKey(), newParticle3D);
        }
    }

    public List<Particle3D> getParticlesToSave() {
        return this.getParticlesToSave(false);
    }

    public List<Particle3D> getParticlesToSave(boolean removeEdgeParticles) {
        ArrayList<Particle3D> result = new ArrayList<Particle3D>(this.particles3D.size());
        int totalPixels3D = 0;
        for (Particle3DBuilder pb : this.particles3D) {
            Particle3D p = pb.getParticle();
            if (!removeEdgeParticles || !p.isEdgeParticle()) {
                result.add(p);
            }
            totalPixels3D += p.innerPointsCount();
        }
        if (this.totalPixels2D != totalPixels3D) {
            throw new RuntimeException("Segmentation 3D error: Segmented 2D and 3D points count are not the same.");
        }
        return result;
    }
}

