/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.model;

import fr.ens.transcriptome.corsen.model.Point3D;
import fr.ens.transcriptome.corsen.model.SimplePoint3DImpl;
import java.util.AbstractList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListPoint3D
extends AbstractList<Point3D> {
    public abstract void add(float var1, float var2, float var3, int var4);

    public abstract float getXAt(int var1);

    public abstract float getYAt(int var1);

    public abstract float getZAt(int var1);

    public abstract int getIAt(int var1);

    public abstract void applyXFactor(float var1);

    public abstract void applyYFactor(float var1);

    public abstract void applyZFactor(float var1);

    public abstract void ensureCapacity(int var1);

    public abstract void trimToSize();

    public Point3D getBarycenter() {
        int n = this.size();
        if (n == 0) {
            return null;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int sum = 0;
        for (Point3D p : this) {
            int val = p.getI();
            sum += val;
            x += (double)(p.getX() * (float)val);
            y += (double)(p.getY() * (float)val);
            z += (double)(p.getZ() * (float)val);
        }
        return new SimplePoint3DImpl((float)x / (float)sum, (float)y / (float)sum, (float)z / (float)sum, sum / n);
    }

    public Point3D getCenter() {
        int n = this.size();
        if (n == 0) {
            return null;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (Point3D p : this) {
            x += (double)p.getX();
            y += (double)p.getY();
            z += (double)p.getZ();
        }
        return new SimplePoint3DImpl((float)x / (float)n, (float)y / (float)n, (float)z / (float)n);
    }

    public float getXMax() {
        int n = this.size();
        if (n == 0) {
            return Float.NaN;
        }
        float result = Float.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            float val = this.getXAt(i);
            if (!(val > result)) continue;
            result = val;
        }
        return result;
    }

    public float getXMin() {
        int n = this.size();
        if (n == 0) {
            return Float.NaN;
        }
        float result = Float.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            float val = this.getXAt(i);
            if (!(val < result)) continue;
            result = val;
        }
        return result;
    }

    public float getYMax() {
        int n = this.size();
        if (n == 0) {
            return Float.NaN;
        }
        float result = Float.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            float val = this.getYAt(i);
            if (!(val > result)) continue;
            result = val;
        }
        return result;
    }

    public float getYMin() {
        int n = this.size();
        if (n == 0) {
            return Float.NaN;
        }
        float result = Float.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            float val = this.getYAt(i);
            if (!(val < result)) continue;
            result = val;
        }
        return result;
    }

    public float getZMax() {
        int n = this.size();
        if (n == 0) {
            return Float.NaN;
        }
        float result = Float.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            float val = this.getZAt(i);
            if (!(val > result)) continue;
            result = val;
        }
        return result;
    }

    public float getZMin() {
        int n = this.size();
        if (n == 0) {
            return Float.NaN;
        }
        float result = Float.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            float val = this.getZAt(i);
            if (!(val < result)) continue;
            result = val;
        }
        return result;
    }
}

