/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.model;

import fr.ens.transcriptome.corsen.model.AbstractListPoint2D;
import fr.ens.transcriptome.corsen.model.Point2D;
import fr.ens.transcriptome.corsen.util.Util;
import java.util.ArrayList;

class ArrayListPackedPoint2D
extends AbstractListPoint2D {
    private final ArrayList<Long> values = new ArrayList();
    private static final float X_PRECISION_DEFAULT = 100.0f;
    private static final float Y_PRECISION_DEFAULT = 100.0f;
    private float xPrecision;
    private float yPrecision;

    public int size() {
        return this.values.size();
    }

    public Point2D get(int index) {
        return new InnerPoint2DImpl(this, index);
    }

    public final int getIAt(int index) {
        long val = this.values.get(index);
        return Util.getI(val);
    }

    public final float getXAt(int index) {
        long val = this.values.get(index);
        return Util.getX(val, this.xPrecision);
    }

    public final float getYAt(int index) {
        long val = this.values.get(index);
        return Util.getY(val, this.yPrecision);
    }

    public final void set(int index, float x, float y, int i) {
        this.values.set(index, this.convert(x, y, i));
    }

    public boolean add(Point2D p) {
        if (p == null) {
            return false;
        }
        this.add(p.getX(), p.getY(), p.getI());
        return true;
    }

    public final void add(int index, float x, float y, int i) {
        this.values.add(index, this.convert(x, y, i));
    }

    public void add(float x, float y, int i) {
        this.add(this.size(), x, y, i);
    }

    public void add(float x, float y) {
        this.add(x, y, 0);
    }

    public final Point2D set(int index, Point2D p) {
        if (p == null) {
            return null;
        }
        Point2D old = this.get(index);
        if (old == null) {
            return null;
        }
        this.set(index, p.getX(), p.getY(), p.getI());
        return old;
    }

    public void remove(Point2D p) {
        this.remove(p.getX(), p.getY(), p.getI());
    }

    public void remove(float x, float y, int i) {
        for (int j = 0; j < this.size(); ++j) {
            Point2D p = this.get(j);
            if (p.getX() != x || p.getY() != y || p.getI() != i) continue;
            this.values.remove(j);
            return;
        }
    }

    public boolean contains(float x, float y) {
        int n = this.values.size();
        for (int i = 0; i < n; ++i) {
            long val = this.values.get(i);
            float xVal = Util.getX(val, this.xPrecision);
            float yVal = Util.getY(val, this.yPrecision);
            if (xVal != x || yVal != y) continue;
            return true;
        }
        return false;
    }

    public boolean contains(float x, float y, int i) {
        int n = this.values.size();
        for (int j = 0; j < n; ++j) {
            long val = this.values.get(j);
            float xVal = Util.getX(val, this.xPrecision);
            float yVal = Util.getY(val, this.yPrecision);
            float iVal = Util.getI(val);
            if (xVal != x || yVal != y || iVal != (float)i) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Point2D point) {
        if (point == null) {
            return false;
        }
        return this.contains(point.getX(), point.getY(), point.getI());
    }

    public void ensureCapacity(int newElementsCount) {
        int newSize = this.size() + newElementsCount;
        this.values.ensureCapacity(newSize);
    }

    public void applyXFactor(float xFactor) {
        this.xPrecision /= xFactor;
    }

    public void applyYFactor(float yFactor) {
        this.yPrecision /= yFactor;
    }

    public AbstractListPoint2D copy() {
        ArrayListPackedPoint2D result = new ArrayListPackedPoint2D(this.xPrecision, this.yPrecision);
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Point2D p = this.get(i);
            result.add(p);
        }
        return result;
    }

    public boolean intersect(AbstractListPoint2D listPoints) {
        if (listPoints == null) {
            return false;
        }
        if (!(listPoints instanceof ArrayListPackedPoint2D)) {
            return super.intersect(listPoints);
        }
        ArrayListPackedPoint2D list = (ArrayListPackedPoint2D)listPoints;
        ArrayList<Long> l1 = this.values;
        ArrayList<Long> l2 = list.values;
        int n1 = l1.size();
        int n2 = l2.size();
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (Util.valueWithoutI(l1.get(i)) != Util.valueWithoutI(l2.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    private final long convert(float x, float y, int i) {
        long val = 0L;
        val = Util.setX(val, x, this.xPrecision);
        val = Util.setY(val, y, this.yPrecision);
        val = Util.setI(val, i);
        return val;
    }

    public void clear() {
        this.values.clear();
    }

    ArrayListPackedPoint2D() {
        this(100.0f, 100.0f);
    }

    ArrayListPackedPoint2D(float xPrecision, float yPrecision) {
        this.xPrecision = xPrecision;
        this.yPrecision = yPrecision;
    }

    private static final class InnerPoint2DImpl
    extends Point2D {
        private ArrayListPackedPoint2D listPoints;
        private int index;

        public final float getX() {
            long val = (Long)this.listPoints.values.get(this.index);
            return Util.getX(val, this.listPoints.xPrecision);
        }

        public final float getY() {
            long val = (Long)this.listPoints.values.get(this.index);
            return Util.getY(val, this.listPoints.yPrecision);
        }

        public final int getI() {
            long val = (Long)this.listPoints.values.get(this.index);
            return Util.getI(val);
        }

        public final void setX(float x) {
            long val = (Long)this.listPoints.values.get(this.index);
            val = Util.setX(val, x, this.listPoints.xPrecision);
            this.listPoints.values.set(this.index, val);
        }

        public final void setY(float y) {
            long val = (Long)this.listPoints.values.get(this.index);
            val = Util.setY(val, y, this.listPoints.yPrecision);
            this.listPoints.values.set(this.index, val);
        }

        public final void setI(int i) {
            long val = (Long)this.listPoints.values.get(this.index);
            val = Util.setI(val, i);
            this.listPoints.values.set(this.index, val);
        }

        public InnerPoint2DImpl(ArrayListPackedPoint2D listPoints, int index) {
            this.listPoints = listPoints;
            this.index = index;
        }
    }
}

