/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.model;

import fr.ens.transcriptome.corsen.model.AbstractListPoint3D;
import fr.ens.transcriptome.corsen.model.Point3D;
import fr.ens.transcriptome.corsen.model.SimplePoint3DImpl;
import fr.ens.transcriptome.corsen.util.Util;
import java.util.ArrayList;

final class ArrayListPackedPoint3D
extends AbstractListPoint3D {
    private ArrayList<Long> values = new ArrayList();
    private static final float X_PRECISION_DEFAULT = 100.0f;
    private static final float Y_PRECISION_DEFAULT = 100.0f;
    private static final float Z_PRECISION_DEFAULT = 100.0f;
    private float xPrecision;
    private float yPrecision;
    private float zPrecision;

    public final int size() {
        return this.values.size();
    }

    public final Point3D get(int index) {
        return new InnerPoint3DImpl(this, index);
    }

    public final void add(int index, Point3D p) {
        if (p == null) {
            return;
        }
        this.add(index, p.getX(), p.getY(), p.getZ(), p.getI());
    }

    public final void add(float x, float y, float z, int i) {
        this.add(this.size(), x, y, z, i);
    }

    public final void add(int index, float x, float y, float z, int i) {
        this.values.add(index, this.convert(x, y, z, i));
    }

    public final Point3D set(int index, Point3D p) {
        if (p == null) {
            return null;
        }
        Point3D old = this.get(index);
        if (old == null) {
            return null;
        }
        this.set(index, p.getX(), p.getY(), p.getZ(), p.getI());
        return old;
    }

    public final void set(int index, float x, float y, float z, int i) {
        this.values.set(index, this.convert(x, y, z, i));
    }

    public final void ensureCapacity(int newElementsCount) {
        int newSize = this.size() + newElementsCount;
        this.values.ensureCapacity(newSize);
    }

    public final void add(AbstractListPoint3D listPoints) {
        if (listPoints == null) {
            return;
        }
        for (Point3D p : listPoints) {
            this.add(p);
        }
    }

    public final void applyXFactor(float xFactor) {
        this.xPrecision /= xFactor;
    }

    public final void applyYFactor(float yFactor) {
        this.yPrecision /= yFactor;
    }

    public final void applyZFactor(float zFactor) {
        this.zPrecision /= zFactor;
    }

    public final Point3D remove(int index) {
        Long value = this.values.remove(index);
        if (value == null) {
            return null;
        }
        return new SimplePoint3DImpl(Util.getX(value, this.xPrecision), Util.getY(value, this.yPrecision), Util.getZ(value, this.zPrecision), Util.getI(value));
    }

    public final int getIAt(int index) {
        long val = this.values.get(index);
        return Util.getI(val);
    }

    public final float getXAt(int index) {
        long val = this.values.get(index);
        return Util.getX(val, this.xPrecision);
    }

    public final float getYAt(int index) {
        long val = this.values.get(index);
        return Util.getY(val, this.yPrecision);
    }

    public final float getZAt(int index) {
        long val = this.values.get(index);
        return Util.getZ(val, this.zPrecision);
    }

    public void trimToSize() {
        this.values.trimToSize();
    }

    public final boolean contains(Point3D p) {
        if (p == null) {
            return false;
        }
        return this.values.contains(this.convert(p.getX(), p.getY(), p.getZ(), p.getI()));
    }

    private final long convert(float x, float y, float z, int i) {
        long val = 0L;
        val = Util.setX(val, x, this.xPrecision);
        val = Util.setY(val, y, this.yPrecision);
        val = Util.setZ(val, z, this.zPrecision);
        val = Util.setI(val, i);
        return val;
    }

    ArrayListPackedPoint3D() {
        this(100.0f, 100.0f, 100.0f);
    }

    ArrayListPackedPoint3D(float xPrecision, float yPrecision, float zPrecision) {
        this.xPrecision = xPrecision;
        this.yPrecision = yPrecision;
        this.zPrecision = zPrecision;
        this.values = new ArrayList();
    }

    private static final class InnerPoint3DImpl
    extends Point3D {
        private ArrayListPackedPoint3D listPoints;
        private int index;

        public final float getX() {
            long val = (Long)this.listPoints.values.get(this.index);
            return Util.getX(val, this.listPoints.xPrecision);
        }

        public final float getY() {
            long val = (Long)this.listPoints.values.get(this.index);
            return Util.getY(val, this.listPoints.yPrecision);
        }

        public final float getZ() {
            long val = (Long)this.listPoints.values.get(this.index);
            return Util.getZ(val, this.listPoints.zPrecision);
        }

        public final int getI() {
            long val = (Long)this.listPoints.values.get(this.index);
            return Util.getI(val);
        }

        public final void setX(float x) {
            long val = (Long)this.listPoints.values.get(this.index);
            val = Util.setX(val, x, this.listPoints.xPrecision);
            this.listPoints.values.set(this.index, val);
        }

        public final void setY(float y) {
            long val = (Long)this.listPoints.values.get(this.index);
            val = Util.setY(val, y, this.listPoints.yPrecision);
            this.listPoints.values.set(this.index, val);
        }

        public final void setZ(float z) {
            long val = (Long)this.listPoints.values.get(this.index);
            val = Util.setZ(val, z, this.listPoints.zPrecision);
            this.listPoints.values.set(this.index, val);
        }

        public final void setI(int i) {
            long val = (Long)this.listPoints.values.get(this.index);
            val = Util.setI(val, i);
            this.listPoints.values.set(this.index, val);
        }

        public InnerPoint3DImpl(ArrayListPackedPoint3D listPoints, int index) {
            this.listPoints = listPoints;
            this.index = index;
        }
    }
}

