/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.model;

import fr.ens.transcriptome.corsen.model.AbstractListPoint2D;
import fr.ens.transcriptome.corsen.model.Point2D;
import java.util.ArrayList;

public class ArrayListPoint2D
extends AbstractListPoint2D {
    private final ArrayList<Float> xValues = new ArrayList();
    private final ArrayList<Float> yValues = new ArrayList();
    private final ArrayList<Integer> iValues = new ArrayList();

    public int size() {
        return this.xValues.size();
    }

    public Point2D get(int index) {
        return new InnerPoint2DImpl(this, index);
    }

    public final int getIAt(int index) {
        return this.iValues.get(index);
    }

    public final float getXAt(int index) {
        return this.xValues.get(index).floatValue();
    }

    public final float getYAt(int index) {
        return this.yValues.get(index).floatValue();
    }

    public final void set(int index, float x, float y, int i) {
        this.xValues.set(index, Float.valueOf(x));
        this.yValues.set(index, Float.valueOf(y));
        this.iValues.set(index, i);
    }

    public boolean add(Point2D p) {
        if (p == null) {
            return false;
        }
        this.add(p.getX(), p.getY(), p.getI());
        return true;
    }

    public final void add(int index, float x, float y, int i) {
        this.xValues.add(index, Float.valueOf(x));
        this.yValues.add(index, Float.valueOf(y));
        this.iValues.add(index, i);
    }

    public void add(float x, float y, int i) {
        this.add(this.size(), x, y, i);
    }

    public void add(float x, float y) {
        this.add(x, y, 0);
    }

    public Point2D set(int index, Point2D p) {
        if (p == null) {
            return null;
        }
        Point2D old = this.get(index);
        if (old == null) {
            return null;
        }
        this.set(index, p.getX(), p.getY(), p.getI());
        return old;
    }

    public void remove(Point2D p) {
        this.remove(p.getX(), p.getY(), p.getI());
    }

    public void remove(float x, float y, int i) {
        for (int j = 0; j < this.size(); ++j) {
            Point2D p = this.get(j);
            if (p.getX() != x || p.getY() != y || p.getI() != i) continue;
            this.xValues.remove(j);
            this.yValues.remove(j);
            this.iValues.remove(j);
            return;
        }
    }

    public boolean contains(float x, float y) {
        int n = this.xValues.size();
        for (int i = 0; i < n; ++i) {
            float xVal = this.xValues.get(i).floatValue();
            float yVal = this.yValues.get(i).floatValue();
            if (xVal != x || yVal != y) continue;
            return true;
        }
        return false;
    }

    public boolean contains(float x, float y, int i) {
        int n = this.xValues.size();
        for (int j = 0; j < n; ++j) {
            float xVal = this.xValues.get(j).floatValue();
            float yVal = this.yValues.get(j).floatValue();
            float iVal = this.iValues.get(j).intValue();
            if (xVal != x || yVal != y || iVal != (float)i) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Point2D point) {
        if (point == null) {
            return false;
        }
        return this.contains(point.getX(), point.getY(), point.getI());
    }

    public void ensureCapacity(int newElementsCount) {
        int newSize = this.size() + newElementsCount;
        this.xValues.ensureCapacity(newSize);
        this.xValues.ensureCapacity(newSize);
        this.iValues.ensureCapacity(newSize);
    }

    public void applyXFactor(float xFactor) {
    }

    public void applyYFactor(float yFactor) {
    }

    public AbstractListPoint2D copy() {
        ArrayListPoint2D result = new ArrayListPoint2D();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Point2D p = this.get(i);
            result.add(p);
        }
        return result;
    }

    public boolean intersect(AbstractListPoint2D listPoints) {
        if (listPoints == null) {
            return false;
        }
        if (!(listPoints instanceof ArrayListPoint2D)) {
            return super.intersect(listPoints);
        }
        ArrayListPoint2D list = (ArrayListPoint2D)listPoints;
        ArrayList<Float> lx1 = this.xValues;
        ArrayList<Float> ly1 = this.yValues;
        ArrayList<Float> lx2 = list.xValues;
        ArrayList<Float> ly2 = list.yValues;
        int n1 = lx1.size();
        int n2 = lx2.size();
        for (int i = 0; i < n1; ++i) {
            float x = lx1.get(i).floatValue();
            float y = ly1.get(i).floatValue();
            for (int j = 0; j < n2; ++j) {
                if (lx2.get(j).floatValue() != x || ly2.get(j).floatValue() != y) continue;
                return true;
            }
        }
        return false;
    }

    public void clear() {
        this.xValues.clear();
        this.yValues.clear();
        this.iValues.clear();
    }

    ArrayListPoint2D() {
    }

    private static final class InnerPoint2DImpl
    extends Point2D {
        private ArrayListPoint2D listPoints;
        private int index;

        public float getX() {
            return ((Float)this.listPoints.xValues.get(this.index)).floatValue();
        }

        public float getY() {
            return ((Float)this.listPoints.yValues.get(this.index)).floatValue();
        }

        public int getI() {
            return (Integer)this.listPoints.iValues.get(this.index);
        }

        public void setX(float x) {
            this.listPoints.xValues.set(this.index, Float.valueOf(x));
        }

        public void setY(float y) {
            this.listPoints.yValues.set(this.index, Float.valueOf(y));
        }

        public void setI(int i) {
            this.listPoints.iValues.set(this.index, i);
        }

        InnerPoint2DImpl(ArrayListPoint2D listPoints, int index) {
            this.listPoints = listPoints;
            this.index = index;
        }
    }
}

