/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.model;

import fr.ens.transcriptome.corsen.model.AbstractListPoint3D;
import fr.ens.transcriptome.corsen.model.Point3D;
import fr.ens.transcriptome.corsen.model.SimplePoint3DImpl;
import java.util.ArrayList;

public class ArrayListPoint3D
extends AbstractListPoint3D {
    private ArrayList<Float> xValues = new ArrayList();
    private ArrayList<Float> yValues = new ArrayList();
    private ArrayList<Float> zValues = new ArrayList();
    private ArrayList<Integer> iValues = new ArrayList();

    public final int size() {
        return this.xValues.size();
    }

    public final Point3D get(int index) {
        return new InnerPoint3DImpl(this, index);
    }

    public final void add(int index, Point3D p) {
        if (p == null) {
            return;
        }
        this.add(index, p.getX(), p.getY(), p.getZ(), p.getI());
    }

    public final void add(float x, float y, float z, int i) {
        this.add(this.size(), x, y, z, i);
    }

    public final void add(int index, float x, float y, float z, int i) {
        this.xValues.add(index, Float.valueOf(x));
        this.yValues.add(index, Float.valueOf(y));
        this.zValues.add(index, Float.valueOf(z));
        this.iValues.add(index, i);
    }

    public final Point3D set(int index, Point3D p) {
        if (p == null) {
            return null;
        }
        Point3D old = this.get(index);
        if (old == null) {
            return null;
        }
        this.set(index, p.getX(), p.getY(), p.getZ(), p.getI());
        return old;
    }

    public final void set(int index, float x, float y, float z, int i) {
        this.xValues.set(index, Float.valueOf(x));
        this.yValues.set(index, Float.valueOf(y));
        this.zValues.set(index, Float.valueOf(y));
        this.iValues.set(index, i);
    }

    public final void ensureCapacity(int newElementsCount) {
        int newSize = this.size() + newElementsCount;
        this.xValues.ensureCapacity(newSize);
        this.yValues.ensureCapacity(newSize);
        this.zValues.ensureCapacity(newSize);
        this.iValues.ensureCapacity(newSize);
    }

    public final void add(AbstractListPoint3D listPoints) {
        if (listPoints == null) {
            return;
        }
        for (Point3D p : listPoints) {
            this.add(p);
        }
    }

    public final void applyXFactor(float xFactor) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.xValues.set(i, Float.valueOf(this.xValues.get(i).floatValue() * xFactor));
        }
    }

    public final void applyYFactor(float yFactor) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.yValues.set(i, Float.valueOf(this.yValues.get(i).floatValue() * yFactor));
        }
    }

    public final void applyZFactor(float zFactor) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.zValues.set(i, Float.valueOf(this.zValues.get(i).floatValue() * zFactor));
        }
    }

    public final Point3D remove(int index) {
        Float x = this.xValues.remove(index);
        Float y = this.yValues.remove(index);
        Float z = this.zValues.remove(index);
        int i = this.iValues.remove(index);
        if (x == null) {
            return null;
        }
        return new SimplePoint3DImpl(x.floatValue(), y.floatValue(), z.floatValue(), i);
    }

    public final int getIAt(int index) {
        return this.iValues.get(index);
    }

    public final float getXAt(int index) {
        return this.xValues.get(index).floatValue();
    }

    public final float getYAt(int index) {
        return this.yValues.get(index).floatValue();
    }

    public final float getZAt(int index) {
        return this.zValues.get(index).floatValue();
    }

    public void trimToSize() {
        this.xValues.trimToSize();
        this.yValues.trimToSize();
        this.zValues.trimToSize();
        this.iValues.trimToSize();
    }

    public final boolean contains(Point3D p) {
        if (p == null) {
            return false;
        }
        float x = p.getX();
        float y = p.getY();
        float z = p.getZ();
        int i = p.getI();
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            if (x != this.xValues.get(j).floatValue() || y != this.yValues.get(j).floatValue() || z != this.zValues.get(j).floatValue() || i != this.iValues.get(j)) continue;
            return true;
        }
        return false;
    }

    ArrayListPoint3D() {
    }

    private static final class InnerPoint3DImpl
    extends Point3D {
        private ArrayListPoint3D listPoints;
        private int index;

        public final float getX() {
            return ((Float)this.listPoints.xValues.get(this.index)).floatValue();
        }

        public final float getY() {
            return ((Float)this.listPoints.yValues.get(this.index)).floatValue();
        }

        public final float getZ() {
            return ((Float)this.listPoints.zValues.get(this.index)).floatValue();
        }

        public final int getI() {
            return (Integer)this.listPoints.iValues.get(this.index);
        }

        public final void setX(float x) {
            this.listPoints.xValues.set(this.index, Float.valueOf(x));
        }

        public final void setY(float y) {
            this.listPoints.yValues.set(this.index, Float.valueOf(y));
        }

        public final void setZ(float z) {
            this.listPoints.zValues.set(this.index, Float.valueOf(z));
        }

        public final void setI(int i) {
            this.listPoints.iValues.set(this.index, i);
        }

        public InnerPoint3DImpl(ArrayListPoint3D listPoints, int index) {
            this.listPoints = listPoints;
            this.index = index;
        }
    }
}

