/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.model;

import fr.ens.transcriptome.corsen.model.AbstractListPoint3D;
import fr.ens.transcriptome.corsen.model.ArrayListPoint3D;
import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.model.Point3D;
import fr.ens.transcriptome.corsen.model.SimplePoint3DImpl;
import fr.ens.transcriptome.corsen.util.MathUtil;
import fr.ens.transcriptome.corsen.util.Stats;
import java.util.ArrayList;

public final class BitMapParticle3D {
    private static final byte NO_POINT = 0;
    private static final byte INNER_POINT = 1;
    private static final byte SURFACE_POINT = 2;
    private static final byte DISCOVERED_SURFACE_POINT = 3;
    private float x0;
    private float y0;
    private float z0;
    private float pixelWidth;
    private float pixelHeight;
    private float pixelDepth;
    private int xLen;
    private int yLen;
    private int zLen;
    private byte[][][] array;
    private int[][][] intensities;
    private Particle3D particle;

    public float getX0() {
        return this.x0;
    }

    public float getY0() {
        return this.y0;
    }

    public float getZ0() {
        return this.z0;
    }

    public float getPixelWidth() {
        return this.pixelWidth;
    }

    public float getPixelHeight() {
        return this.pixelHeight;
    }

    public float getPixelDepth() {
        return this.pixelDepth;
    }

    public int getXLen() {
        return this.xLen;
    }

    public int getYLen() {
        return this.yLen;
    }

    public int getZLen() {
        return this.zLen;
    }

    public int getXBitmapCoordinate(float x) {
        return (int)Math.floor(MathUtil.roundValue(x / this.pixelWidth - this.x0));
    }

    public int getYBitmapCoordinate(float y) {
        return (int)Math.floor(MathUtil.roundValue(y / this.pixelHeight - this.y0));
    }

    public int getZBitmapCoordinate(float z) {
        return (int)Math.floor(MathUtil.roundValue(z / this.pixelDepth - this.z0));
    }

    private void setBitMapIntensity(float x, float y, float z, int intensity) {
        int dx = this.getXBitmapCoordinate(x);
        int dy = this.getYBitmapCoordinate(y);
        int dz = this.getZBitmapCoordinate(z);
        if (dx < 0 || dx >= this.xLen || dy < 0 || dy >= this.yLen || dz < 0 || dz >= this.zLen) {
            return;
        }
        int[] nArray = this.intensities[dz][dy];
        int n = dx;
        nArray[n] = nArray[n] + intensity;
    }

    private void setBitMapValue(float x, float y, float z, byte value) {
        int dx = this.getXBitmapCoordinate(x);
        int dy = this.getYBitmapCoordinate(y);
        int dz = this.getZBitmapCoordinate(z);
        if (dx < 0 || dx >= this.xLen || dy < 0 || dy >= this.yLen || dz < 0 || dz >= this.zLen) {
            return;
        }
        this.array[dz][dy][dx] = value;
    }

    private byte getBitMapValue(float x, float y, float z) {
        int dx = this.getXBitmapCoordinate(x);
        int dy = this.getYBitmapCoordinate(y);
        int dz = this.getZBitmapCoordinate(z);
        return this.getBitMapValue(dx, dy, dz);
    }

    private byte getBitMapValue(int x, int y, int z) {
        if (x < 0 || x >= this.xLen || y < 0 || y >= this.yLen || z < 0 || z >= this.zLen) {
            return 0;
        }
        return this.array[z][y][x];
    }

    public int getBitMapIntensity(float x, float y, float z) {
        int dx = this.getXBitmapCoordinate(x);
        int dy = this.getYBitmapCoordinate(y);
        int dz = this.getZBitmapCoordinate(z);
        return this.getBitMapIntensity(dx, dy, dz);
    }

    public int getBitMapIntensity(int x, int y, int z) {
        if (x < 0 || x >= this.xLen || y < 0 || y >= this.yLen || z < 0 || z >= this.zLen) {
            return 0;
        }
        return this.intensities[z][y][x];
    }

    private void initArray(AbstractListPoint3D lp) {
        int j;
        int i;
        float xMin = lp.getXMin();
        float yMin = lp.getYMin();
        float zMin = lp.getZMin();
        float xMax = lp.getXMax();
        float yMax = lp.getYMax();
        float zMax = lp.getZMax();
        this.x0 = (float)Math.floor(MathUtil.roundValue((xMin - 2.0f * this.pixelWidth) / this.pixelWidth));
        this.y0 = (float)Math.floor(MathUtil.roundValue((yMin - 2.0f * this.pixelHeight) / this.pixelHeight));
        this.z0 = (float)Math.floor(MathUtil.roundValue((zMin - 2.0f * this.pixelDepth) / this.pixelDepth));
        int xLen = (int)MathUtil.roundValue((xMax - xMin) / this.pixelWidth) + 5;
        int yLen = (int)MathUtil.roundValue((yMax - yMin) / this.pixelHeight) + 5;
        int zLen = (int)MathUtil.roundValue((zMax - zMin) / this.pixelDepth) + 5;
        this.xLen = xLen;
        this.yLen = yLen;
        this.zLen = zLen;
        this.array = new byte[zLen][][];
        for (i = 0; i < this.array.length; ++i) {
            this.array[i] = new byte[yLen][];
            for (j = 0; j < yLen; ++j) {
                this.array[i][j] = new byte[xLen];
            }
        }
        this.intensities = new int[zLen][][];
        for (i = 0; i < this.intensities.length; ++i) {
            this.intensities[i] = new int[yLen][];
            for (j = 0; j < yLen; ++j) {
                this.intensities[i][j] = new int[xLen];
            }
        }
    }

    private void fillArray(AbstractListPoint3D lp, byte pointType) {
        for (Point3D p : lp) {
            this.setBitMapValue(p.getX(), p.getY(), p.getZ(), pointType);
        }
    }

    private byte getPixelPresent(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0 || x >= this.xLen || y >= this.yLen || z >= this.zLen) {
            return 0;
        }
        byte value = this.array[z][y][x];
        return value > 0 ? (byte)1 : 0;
    }

    private int[] countAxesSurfaces(int x, int y, int z) {
        int xCount = 2 - this.getPixelPresent(x - 1, y, z) - this.getPixelPresent(x + 1, y, z);
        int yCount = 2 - this.getPixelPresent(x, y - 1, z) - this.getPixelPresent(x, y + 1, z);
        int zCount = 2 - this.getPixelPresent(x, y, z - 1) - this.getPixelPresent(x, y, z + 1);
        return new int[]{xCount, yCount, zCount};
    }

    public double calcSurface() {
        int xLen = this.xLen;
        int yLen = this.yLen;
        int zLen = this.zLen;
        double xSurface = this.pixelHeight * this.pixelDepth;
        double ySurface = this.pixelWidth * this.pixelDepth;
        double zSurface = this.pixelWidth * this.pixelHeight;
        double surface = 0.0;
        for (int i = 0; i < xLen; ++i) {
            for (int j = 0; j < yLen; ++j) {
                for (int k = 0; k < zLen; ++k) {
                    int[] faces;
                    if (this.getBitMapValue(i, j, k) == 0 || (faces = this.countAxesSurfaces(i, j, k))[0] == 0 && faces[1] == 0 && faces[2] == 0) continue;
                    surface += (double)faces[0] * xSurface + (double)faces[1] * ySurface + (double)faces[2] * zSurface;
                }
            }
        }
        return surface;
    }

    public double calcMedianCircularity() {
        int xLen = this.xLen;
        int yLen = this.yLen;
        int zLen = this.zLen;
        double pixelWidth = this.pixelWidth;
        double pixelHeight = this.pixelHeight;
        double squareArea = pixelWidth * pixelHeight;
        ArrayList<Double> circularities = new ArrayList<Double>(zLen);
        for (int k = 0; k < zLen; ++k) {
            int count = 0;
            double perimeter = 0.0;
            for (int i = 0; i < xLen; ++i) {
                for (int j = 0; j < yLen; ++j) {
                    if (!this.isParticlePoint(i, j, k)) continue;
                    if (!this.isParticlePoint(i - 1, j, k)) {
                        perimeter += pixelHeight;
                    }
                    if (!this.isParticlePoint(i + 1, j, k)) {
                        perimeter += pixelHeight;
                    }
                    if (!this.isParticlePoint(i, j - 1, k)) {
                        perimeter += pixelWidth;
                    }
                    if (!this.isParticlePoint(i, j + 1, k)) {
                        perimeter += pixelWidth;
                    }
                    ++count;
                }
            }
            if (count <= 0) continue;
            double area = (double)count * squareArea;
            double c = perimeter == 0.0 ? 0.0 : Math.PI * 4 * (area / (perimeter * perimeter));
            circularities.add(c);
        }
        return Stats.median(circularities);
    }

    public boolean isParticlePoint(Point3D p) {
        if (p == null) {
            return false;
        }
        return this.getBitMapValue(p.getX(), p.getY(), p.getZ()) != 0;
    }

    public boolean isParticlePoint(int x, int y, int z) {
        return this.getBitMapValue(x, y, z) != 0;
    }

    public boolean isParticleSurfacePoint(Point3D p) {
        if (p == null) {
            return false;
        }
        return this.getBitMapValue(p.getX(), p.getY(), p.getZ()) == 2;
    }

    public boolean isParticleSurfacePoint(int x, int y, int z) {
        return this.getBitMapValue(x, y, z) == 2;
    }

    public boolean isParticleInnerPoint(Point3D p) {
        if (p == null) {
            return false;
        }
        return this.getBitMapValue(p.getX(), p.getY(), p.getZ()) == 1;
    }

    public boolean isParticleInnerPoint(int x, int y, int z) {
        return this.getBitMapValue(x, y, z) == 1;
    }

    public boolean isPointInParticle(Point3D point) {
        boolean in = this.isParticlePoint(point);
        if (!in) {
            return false;
        }
        if (this.isParticleInnerPoint(point)) {
            return true;
        }
        Point3D nearest = this.findNearestPoint(point);
        float x = nearest.getX();
        float y = nearest.getY();
        float z = nearest.getZ();
        boolean found = false;
        for (int i = -1; i <= 1; ++i) {
            block1: for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    Point3D middle;
                    SimplePoint3DImpl p;
                    if (i == 0 && j == 0 && k == 0 || !this.isParticlePoint(p = new SimplePoint3DImpl(x + (float)i * this.pixelWidth, y + (float)j * this.pixelHeight, z + (float)k * this.pixelDepth)) || !this.isPointInSphere(middle = this.getMiddle(nearest, p), point)) continue;
                    found = true;
                    continue block1;
                }
            }
        }
        boolean result = found;
        return result;
    }

    private Point3D findNearestPoint(Point3D point) {
        Point3D nearest = null;
        float minDistance = Float.MAX_VALUE;
        int n1 = this.particle.innerPointsCount();
        for (int j = 0; j < n1; ++j) {
            Point3D p2 = this.particle.getInnerPoint(j);
            if (nearest == null) {
                nearest = p2;
                minDistance = p2.distance(point);
                continue;
            }
            float d = p2.distance(point);
            if (!(d < minDistance) || !this.isParticleInnerPoint(p2)) continue;
            minDistance = d;
            nearest = p2;
        }
        int n2 = this.particle.surfacePointsCount();
        for (int j = 0; j < n2; ++j) {
            Point3D p2 = this.particle.getSurfacePoint(j);
            if (nearest == null) {
                nearest = p2;
                minDistance = p2.distance(point);
                continue;
            }
            float d = p2.distance(point);
            if (!(d < minDistance) || !this.isParticleSurfacePoint(p2)) continue;
            minDistance = d;
            nearest = p2;
        }
        return nearest;
    }

    private Point3D getMiddle(Point3D point1, Point3D point2) {
        ArrayListPoint3D lineSegment = new ArrayListPoint3D();
        lineSegment.add(point1);
        lineSegment.add(point2);
        return lineSegment.getCenter();
    }

    private boolean isPointInSphere(Point3D ref, Point3D point) {
        if (Math.abs(ref.getX() - point.getX()) > this.pixelWidth / 2.0f) {
            return false;
        }
        if (Math.abs(ref.getY() - point.getY()) > this.pixelHeight / 2.0f) {
            return false;
        }
        return !(Math.abs(ref.getZ() - point.getZ()) > this.pixelDepth / 2.0f);
    }

    private void testAdditionalSurfacePoint(int x, int y, int z) {
        byte value = this.getBitMapValue(x, y, z);
        if (value != 1) {
            return;
        }
        if (this.getBitMapValue(x - 1, y, z) == 0 || this.getBitMapValue(x + 1, y, z) == 0 || this.getBitMapValue(x, y - 1, z) == 0 || this.getBitMapValue(x, y + 1, z) == 0 || this.getBitMapValue(x, y, z - 1) == 0 || this.getBitMapValue(x, y, z + 1) == 0) {
            this.array[z][y][x] = 3;
            this.testAdditionalSurfacePoint(x - 1, y, z);
            this.testAdditionalSurfacePoint(x + 1, y, z);
            this.testAdditionalSurfacePoint(x, y + 1, z);
            this.testAdditionalSurfacePoint(x, y + 1, z);
            this.testAdditionalSurfacePoint(x, y, z + 1);
            this.testAdditionalSurfacePoint(x, y, z + 1);
        }
    }

    private void findSurfacePoints() {
        int k;
        int j;
        int i;
        for (i = 0; i < this.xLen; ++i) {
            for (j = 0; j < this.yLen; ++j) {
                for (k = 0; k < this.zLen; ++k) {
                    if (this.array[k][j][i] != 2) continue;
                    this.testAdditionalSurfacePoint(i - 1, j, k);
                    this.testAdditionalSurfacePoint(i + 1, j, k);
                    this.testAdditionalSurfacePoint(i, j + 1, k);
                    this.testAdditionalSurfacePoint(i, j + 1, k);
                    this.testAdditionalSurfacePoint(i, j, k + 1);
                    this.testAdditionalSurfacePoint(i, j, k + 1);
                }
            }
        }
        for (i = 0; i < this.xLen; ++i) {
            for (j = 0; j < this.yLen; ++j) {
                for (k = 0; k < this.zLen; ++k) {
                    if (this.array[k][j][i] != 3) continue;
                    this.array[k][j][i] = 2;
                }
            }
        }
    }

    public AbstractListPoint3D getSurfacePoints() {
        ArrayListPoint3D result = new ArrayListPoint3D();
        for (Point3D p : this.particle.getInnerPoints()) {
            if (!this.isParticleSurfacePoint(p)) continue;
            result.add(p);
        }
        return result;
    }

    BitMapParticle3D(Particle3D particle) {
        this(particle, particle.getPixelWidth(), particle.getPixelHeight(), particle.getPixelDepth());
    }

    BitMapParticle3D(Particle3D particle, float pixelWidth, float pixelHeight, float pixelDepth) {
        this.pixelWidth = pixelWidth;
        this.pixelHeight = pixelHeight;
        this.pixelDepth = pixelDepth;
        this.initArray(particle.getInnerPoints());
        this.fillArray(particle.getInnerPoints(), (byte)1);
        this.fillArray(particle.getSurfacePoints(), (byte)2);
        this.findSurfacePoints();
        for (Point3D p : particle.getInnerPoints()) {
            this.setBitMapIntensity(p.getX(), p.getY(), p.getZ(), p.getI());
        }
        this.particle = particle;
    }
}

