/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.model;

import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.model.Particles3DFilter;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class JavascriptParticles3DFilter
implements Particles3DFilter {
    private CompiledScript script;
    private Bindings bindings;

    public boolean accept(Particle3D particle) {
        if (this.script == null) {
            return true;
        }
        if (particle == null) {
            return false;
        }
        Bindings b = this.bindings;
        b.put("area", (Object)particle.getArea());
        b.put("density", (Object)particle.getDensity());
        b.put("intensity", (Object)particle.getIntensity());
        b.put("sphericity", (Object)particle.getSphericity());
        b.put("volume", (Object)particle.getVolume());
        try {
            Object o = this.script.eval();
            if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
                return true;
            }
        }
        catch (ScriptException scriptException) {
            // empty catch block
        }
        return false;
    }

    private boolean setExpression(String expression) {
        this.script = null;
        if (expression == null || "".equals(expression.trim())) {
            return true;
        }
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("js");
        Compilable compilable = (Compilable)((Object)engine);
        try {
            CompiledScript script;
            this.script = script = compilable.compile(expression);
            this.bindings = script.getEngine().getBindings(100);
        }
        catch (ScriptException e) {
            return false;
        }
        return true;
    }

    public static JavascriptParticles3DFilter createFilter(String expression) {
        JavascriptParticles3DFilter result = new JavascriptParticles3DFilter();
        if (result.setExpression(expression)) {
            return result;
        }
        return null;
    }

    private JavascriptParticles3DFilter() {
    }
}

