/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.model;

import fr.ens.transcriptome.corsen.model.AbstractListPoint2D;
import fr.ens.transcriptome.corsen.model.ListPoint2DFactory;
import fr.ens.transcriptome.corsen.model.Point2D;
import fr.ens.transcriptome.corsen.model.SimplePoint2DImpl;
import java.awt.Polygon;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class Particle2D {
    private static int count;
    private final int id = count++;
    private String name = "" + this.id;
    private AbstractListPoint2D surfacePoints;
    private AbstractListPoint2D innerPoints;
    private boolean edgeParticle;
    private float pixelWidth = 1.0f;
    private float pixelHeight = 1.0f;
    private long intensity;

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public long getIntensity() {
        return this.intensity;
    }

    public double getArea() {
        return (float)this.innerPointsCount() * this.pixelHeight * this.pixelWidth;
    }

    public float getPixelHeight() {
        return this.pixelHeight;
    }

    public float getPixelWidth() {
        return this.pixelWidth;
    }

    public boolean isEdgeParticle() {
        return this.edgeParticle;
    }

    public void setName(String name) {
        this.name = name;
    }

    void setEdgeParticle(boolean edgeParticle) {
        this.edgeParticle = edgeParticle;
    }

    public int surfacePointsCount() {
        return this.surfacePoints.size();
    }

    public int innerPointsCount() {
        return this.innerPoints.size();
    }

    public void addInnerPoint(Point2D p) {
        if (p != null) {
            this.addInnerPoint(p.getY(), p.getY(), p.getI());
        }
    }

    public void addInnerPoint(float x, float y, int i) {
        this.innerPoints.add(x, y, i);
        this.intensity += (long)i;
    }

    public void addSurfacePoint(Point2D p) {
        if (p != null) {
            this.addSurfacePoint(p.getY(), p.getY(), p.getI());
        }
    }

    public void addSurfacePoint(float x, float y, int i) {
        this.surfacePoints.add(x, y, i);
    }

    public void addSurfacePoint(float x, float y) {
        this.surfacePoints.add(x, y);
    }

    public Point2D getSurfacePoint(int index) {
        return (Point2D)this.surfacePoints.get(index);
    }

    public Point2D getInnerPoint(int index) {
        return (Point2D)this.innerPoints.get(index);
    }

    public Point2D getCenter() {
        double x = 0.0;
        double y = 0.0;
        int n = this.surfacePointsCount();
        for (int i = 0; i < n; ++i) {
            Point2D p = this.getSurfacePoint(i);
            x += (double)p.getX();
            y += (double)p.getY();
        }
        return new SimplePoint2DImpl((float)x / (float)n, (float)y / (float)n);
    }

    public boolean surfacePointIntersect(Particle2D particle) {
        if (particle == null) {
            return false;
        }
        int n = this.surfacePointsCount();
        Polygon p1 = new Polygon();
        for (int i = 0; i < n; ++i) {
            Point2D pt = this.getSurfacePoint(i);
            p1.addPoint((int)pt.getX(), (int)pt.getY());
        }
        n = particle.surfacePointsCount();
        Polygon p2 = new Polygon();
        for (int i = 0; i < n; ++i) {
            Point2D pt = particle.getSurfacePoint(i);
            p2.addPoint((int)pt.getX(), (int)pt.getY());
        }
        Area a1 = new Area(p1);
        Area a2 = new Area(p2);
        a1.intersect(a2);
        return !a1.isEmpty();
    }

    public boolean innerPointIntersect(Particle2D particle) {
        if (particle == null) {
            return false;
        }
        AbstractListPoint2D l1 = this.innerPoints;
        AbstractListPoint2D l2 = particle.innerPoints;
        return l1.intersect(l2);
    }

    public Point2D findNearestInnerPoint(Point2D p) {
        int n = this.innerPointsCount();
        if (p == null || n == 0) {
            return null;
        }
        float minDistance = Float.MAX_VALUE;
        Point2D nearestPoint = null;
        for (int i = 0; i < n; ++i) {
            Point2D ip = this.getInnerPoint(i);
            float distance = ip.distance(p);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            nearestPoint = ip;
        }
        return nearestPoint;
    }

    public Point2D findNearestSurfacePoint(Point2D p) {
        int n = this.surfacePointsCount();
        if (p == null || n == 0) {
            return null;
        }
        float minDistance = Float.MAX_VALUE;
        Point2D nearestPoint = null;
        for (int i = 0; i < n; ++i) {
            Point2D ip = this.getSurfacePoint(i);
            float distance = ip.distance(p);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            nearestPoint = ip;
        }
        return nearestPoint;
    }

    public Point2D[] findNearestsSurfacePoints(Point2D p, float maxDistance) {
        int n = this.surfacePointsCount();
        if (p == null || n == 0) {
            return null;
        }
        ArrayList<Point2D> al = new ArrayList<Point2D>();
        for (int i = 0; i < n; ++i) {
            Point2D ip = this.getSurfacePoint(i);
            float distance = ip.distance(p);
            if (!(distance < maxDistance)) continue;
            al.add(ip);
        }
        Point2D[] result = new Point2D[al.size()];
        al.toArray(result);
        return result;
    }

    public boolean isInnerPoint(float x, float y) {
        int n = this.innerPointsCount();
        for (int i = 0; i < n; ++i) {
            if (!this.innerPoints.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    public boolean isSurfacePoint(float x, float y) {
        int n = this.surfacePointsCount();
        for (int i = 0; i < n; ++i) {
            if (!this.surfacePoints.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(';');
        sb.append(this.getCenter());
        sb.append(';');
        int n = this.surfacePointsCount();
        for (i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append('(');
            sb.append(this.getSurfacePoint(i).toString());
            sb.append(')');
        }
        sb.append(';');
        n = this.innerPointsCount();
        for (i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append('(');
            sb.append(this.getInnerPoint(i).toString());
            sb.append(')');
        }
        return sb.toString();
    }

    public static Particle2D parse(String s) {
        Point2D p;
        String s2;
        boolean first;
        StringTokenizer st2;
        String points;
        if (s == null) {
            return null;
        }
        Particle2D par = new Particle2D();
        StringTokenizer st = new StringTokenizer(s, ";");
        if (st.hasMoreElements()) {
            par.setName(st.nextToken());
        }
        if (st.hasMoreElements()) {
            st.nextToken();
        }
        if (st.hasMoreElements()) {
            points = st.nextToken();
            st2 = new StringTokenizer(points, ")");
            first = true;
            while (st2.hasMoreTokens()) {
                s2 = st2.nextToken();
                if (first) {
                    s2 = s2.substring(1, s2.length());
                    first = false;
                } else {
                    s2 = s2.substring(2, s2.length());
                }
                p = Point2D.parse(s2);
                par.surfacePoints.add(p.getX(), p.getY());
            }
        }
        if (st.hasMoreElements()) {
            points = st.nextToken();
            st2 = new StringTokenizer(points, ")");
            first = true;
            while (st2.hasMoreTokens()) {
                s2 = st2.nextToken();
                if (first) {
                    s2 = s2.substring(1, s2.length());
                    first = false;
                } else {
                    s2 = s2.substring(2, s2.length());
                }
                p = Point2D.parse(s2);
                par.innerPoints.add(p.getX(), p.getY(), p.getI());
            }
        }
        return par;
    }

    public void applyXFactor(float xFactor) {
        this.surfacePoints.applyXFactor(xFactor);
        this.innerPoints.applyXFactor(xFactor);
    }

    public void applyYFactor(float yFactor) {
        this.surfacePoints.applyYFactor(yFactor);
        this.innerPoints.applyYFactor(yFactor);
    }

    private Particle2D() {
    }

    public Particle2D(float pixelWidth, float pixelHeight) {
        this();
        this.pixelHeight = pixelHeight;
        this.pixelWidth = pixelWidth;
        this.surfacePoints = ListPoint2DFactory.createListPoint2D(this.pixelWidth, this.pixelHeight);
        this.innerPoints = ListPoint2DFactory.createListPoint2D(this.pixelWidth, this.pixelHeight);
    }

    public Particle2D(float pixelWidth, float pixelHeight, String s) {
        this(pixelWidth, pixelHeight);
        Particle2D.parse(s);
    }
}

