/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.model;

import fr.ens.transcriptome.corsen.calc.Distance;
import fr.ens.transcriptome.corsen.calc.ParticleType;
import fr.ens.transcriptome.corsen.model.AbstractListPoint3D;
import fr.ens.transcriptome.corsen.model.BitMapParticle3D;
import fr.ens.transcriptome.corsen.model.ListPoint3DFactory;
import fr.ens.transcriptome.corsen.model.Particle2D;
import fr.ens.transcriptome.corsen.model.Point3D;
import fr.ens.transcriptome.corsen.model.UnmodifiableListPoint3D;
import fr.ens.transcriptome.corsen.util.MathUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Particle3D {
    private static int count;
    private final int id = count++;
    private String name = "" + this.id;
    private String comment = "";
    private final AbstractListPoint3D surfacePoints;
    private final AbstractListPoint3D innerPoints;
    private final AbstractListPoint3D unmodifiableSurfacePoints;
    private final AbstractListPoint3D unmodifiableInnerPoints;
    private BitMapParticle3D bitMapParticle;
    private float pixelWidth = 1.0f;
    private float pixelHeight = 1.0f;
    private float pixelDepth = 1.0f;
    private double volume;
    private long intensity;
    private double area;
    private double sphericity;
    private double density;
    private double medianCircularity;
    private boolean edgeParticle;
    private boolean pixelDimChange;
    private ParticleType type = ParticleType.ALLPOINTS;

    public double getVolume() {
        if (this.volume < 0.0) {
            this.calcVolume();
        }
        return this.volume;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public long getIntensity() {
        return this.intensity;
    }

    public float getPixelDepth() {
        return this.pixelDepth;
    }

    public float getPixelHeight() {
        return this.pixelHeight;
    }

    public float getPixelWidth() {
        return this.pixelWidth;
    }

    public ParticleType getType() {
        return this.type;
    }

    public double getArea() {
        if (this.area < 0.0) {
            this.calcArea();
        }
        return this.area;
    }

    public double getMedianCircularity() {
        if (this.medianCircularity < 0.0) {
            this.calcMedianCircularity();
        }
        return this.medianCircularity;
    }

    public double getSphericity() {
        if (this.sphericity < 0.0) {
            this.calcSphericity();
        }
        return this.sphericity;
    }

    public double getDensity() {
        if (this.density < 0.0) {
            this.calcDensity();
        }
        return this.density;
    }

    public boolean isEdgeParticle() {
        return this.edgeParticle;
    }

    public BitMapParticle3D getBitMapParticle() {
        if (this.bitMapParticle == null || this.pixelDimChange) {
            this.calcBitMap();
        }
        return this.bitMapParticle;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setComment(String comment) {
        if (comment == null) {
            return;
        }
        this.comment = comment;
    }

    public void setType(ParticleType type) {
        this.type = type;
    }

    void setVolume(double volume) {
        if (volume <= 0.0) {
            this.calcVolume();
        } else {
            this.volume = volume;
        }
    }

    void setIntensity(long intensity) {
        if (intensity <= 0L) {
            this.calcIntensity();
        } else {
            this.intensity = intensity;
        }
    }

    void setArea(double area) {
        if (area <= 0.0) {
            this.calcArea();
        } else {
            this.area = area;
        }
    }

    void setMedianCircularity(double medianCircularity) {
        if (medianCircularity <= 0.0) {
            this.calcMedianCircularity();
        } else {
            this.medianCircularity = medianCircularity;
        }
    }

    void setSphericity(double sphericity) {
        if (sphericity < 0.0) {
            this.calcSphericity();
        } else {
            this.sphericity = sphericity;
        }
    }

    void setDensity(double density) {
        if (density < 0.0) {
            this.calcDensity();
        } else {
            this.density = density;
        }
    }

    void setEdgeParticle(boolean edgeParticle) {
        this.edgeParticle = edgeParticle;
    }

    void setBitMapParticle(BitMapParticle3D bitmapParticle) {
        this.bitMapParticle = bitmapParticle;
    }

    public boolean containsInnerPoint(Point3D p) {
        if (p == null) {
            return false;
        }
        int n = this.innerPointsCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getInnerPoint(i).equals(p)) continue;
            return true;
        }
        return false;
    }

    public boolean containsSurfacePoint(Point3D p) {
        if (p == null) {
            return false;
        }
        int n = this.surfacePointsCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getSurfacePoint(i).equals(p)) continue;
            return true;
        }
        return false;
    }

    public int surfacePointsCount() {
        return this.surfacePoints.size();
    }

    public int innerPointsCount() {
        return this.innerPoints.size();
    }

    public Point3D getSurfacePoint(int index) {
        return (Point3D)this.surfacePoints.get(index);
    }

    public Point3D getInnerPoint(int index) {
        return (Point3D)this.innerPoints.get(index);
    }

    public double getSurfaceToSurfaceDistance(Particle3D p) {
        double min = Double.MAX_VALUE;
        if (p == null) {
            return min;
        }
        int n = this.surfacePointsCount();
        int pn = p.surfacePointsCount();
        for (int i = 0; i < n; ++i) {
            Point3D p1 = this.getSurfacePoint(i);
            for (int j = 0; j < pn; ++j) {
                Point3D p2 = p.getSurfacePoint(j);
                double d = p1.distance(p2);
                if (!(d < min)) continue;
                min = d;
            }
        }
        return min;
    }

    public double getBarycenterToSurfaceDistance(Particle3D p) {
        double min = Double.MAX_VALUE;
        if (p == null) {
            return min;
        }
        int pn = p.surfacePointsCount();
        Point3D p1 = this.getInnerPoints().getBarycenter();
        for (int i = 0; i < pn; ++i) {
            Point3D p2 = p.getSurfacePoint(i);
            double d = p1.distance(p2);
            if (!(d < min)) continue;
            min = d;
        }
        return min;
    }

    public double getMinDistanceToInnerPoint(Point3D p) {
        double min = Double.MAX_VALUE;
        if (p == null) {
            throw new NullPointerException("Point is null");
        }
        int n = this.innerPointsCount();
        for (int i = 0; i < n; ++i) {
            Point3D p2 = this.getInnerPoint(i);
            double d = p.distance(p2);
            if (!(d < min)) continue;
            min = d;
        }
        return min;
    }

    public double getMaxDistanceToInnerPoint(Point3D p) {
        double max = Double.MIN_VALUE;
        if (p == null) {
            throw new NullPointerException("Point is null");
        }
        int n = this.innerPointsCount();
        for (int i = 0; i < n; ++i) {
            Point3D p2 = this.getInnerPoint(i);
            double d = p.distance(p2);
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }

    public double getBarycenterToInnerDistance(Particle3D p) {
        if (p == null) {
            throw new NullPointerException("Particle is null");
        }
        return p.getMinDistanceToInnerPoint(this.getInnerPoints().getBarycenter());
    }

    public double getCenterToCenterDistance(Particle3D p) {
        double min = Double.MAX_VALUE;
        if (p == null) {
            return Double.MAX_VALUE;
        }
        Point3D p1 = this.getInnerPoints().getCenter();
        Point3D p2 = p.getInnerPoints().getCenter();
        return p1.distance(p2);
    }

    public static final Map<Float, Particle2D> getSurfacePointSlices(Particle3D particle) {
        HashMap<Float, Particle2D> slices = new HashMap<Float, Particle2D>();
        int nPoints = particle.surfacePointsCount();
        for (int i = 0; i < nPoints; ++i) {
            Point3D p = particle.getSurfacePoint(i);
            Float key = new Float(p.getZ());
            Particle2D par = (Particle2D)slices.get(key);
            if (par == null) {
                par = new Particle2D(particle.getPixelWidth(), particle.getPixelHeight());
                slices.put(key, par);
            }
            par.addSurfacePoint(p.getX(), p.getY());
        }
        return slices;
    }

    private static Map<String, Particle2D> getSurfaceAndInnerPointSlices(Particle3D particle) {
        HashMap<String, Particle2D> slices = new HashMap<String, Particle2D>();
        int nSurfacePoints = particle.surfacePointsCount();
        for (int i = 0; i < nSurfacePoints; ++i) {
            Point3D p = particle.getSurfacePoint(i);
            String key = "" + p.getZ();
            Particle2D par = (Particle2D)slices.get(key);
            if (par == null) {
                par = new Particle2D(particle.getPixelWidth(), particle.getPixelHeight());
                slices.put(key, par);
            }
            par.addSurfacePoint(p.getX(), p.getY());
        }
        int nInnerPoints = particle.innerPointsCount();
        for (int i = 0; i < nInnerPoints; ++i) {
            Point3D p = particle.getInnerPoint(i);
            String key = "" + p.getZ();
            Particle2D par = (Particle2D)slices.get(key);
            if (par == null) {
                par = new Particle2D(particle.getPixelWidth(), particle.getPixelHeight());
                slices.put(key, par);
            }
            par.addInnerPoint(p.getX(), p.getY(), p.getI());
        }
        return slices;
    }

    public float[] getMinInnerDistancesNotNull0() {
        int nInnerPoints = this.innerPointsCount();
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float minZ = Float.MAX_VALUE;
        for (int i = 0; i < nInnerPoints; ++i) {
            Point3D pt1 = this.getInnerPoint(i);
            for (int j = i + 1; j < nInnerPoints; ++j) {
                Point3D pt2 = this.getInnerPoint(j);
                float x = Math.abs(pt1.getX() - pt2.getX());
                float y = Math.abs(pt1.getY() - pt2.getY());
                float z = Math.abs(pt1.getZ() - pt2.getZ());
                if (x > 0.0f && x < minX) {
                    minX = x;
                }
                if (x > 0.0f && y < minY) {
                    minY = y;
                }
                if (!(x > 0.0f) || !(z < minZ)) continue;
                minZ = z;
            }
        }
        return new float[]{minX, minY, minZ};
    }

    private float getMinDiffNotNull(Set<Float> s) {
        if (s == null) {
            throw new NullPointerException("The set is null ");
        }
        if (s.size() == 1) {
            return 1.0f;
        }
        Float[] data = new Float[s.size()];
        s.toArray(data);
        float min = Float.MAX_VALUE;
        for (int i = 0; i < data.length; ++i) {
            float f1 = data[i].floatValue();
            for (int j = i + 1; j < data.length; ++j) {
                float d = Math.abs(data[j].floatValue() - f1);
                if (d == 0.0f || !(d < min)) continue;
                min = d;
            }
        }
        return min;
    }

    public float[] getMinInnerDistancesNotNull() {
        int nInnerPoints = this.innerPointsCount();
        HashSet<Float> setX = new HashSet<Float>();
        HashSet<Float> setY = new HashSet<Float>();
        HashSet<Float> setZ = new HashSet<Float>();
        for (int i = 0; i < nInnerPoints; ++i) {
            Point3D pt1 = this.getInnerPoint(i);
            setX.add(new Float(pt1.getX()));
            setY.add(new Float(pt1.getY()));
            setZ.add(new Float(pt1.getZ()));
        }
        return new float[]{this.getMinDiffNotNull(setX), this.getMinDiffNotNull(setY), this.getMinDiffNotNull(setZ)};
    }

    public Particle2D[] toParticles2D() {
        Map<String, Particle2D> slices = Particle3D.getSurfaceAndInnerPointSlices(this);
        if (slices == null || slices.size() == 0) {
            return null;
        }
        int n = slices.size();
        float[] keys = new float[n];
        int i = 0;
        for (String key : slices.keySet()) {
            keys[i] = Float.parseFloat(key);
            ++i;
        }
        Arrays.sort(keys);
        Particle2D[] result = new Particle2D[n];
        for (int j = 0; j < n; ++j) {
            result[j] = slices.get("" + keys[j]);
        }
        int innerCount = 0;
        int surfaceCount = 0;
        for (int j = 0; j < result.length; ++j) {
            innerCount += result[j].innerPointsCount();
            surfaceCount += result[j].surfacePointsCount();
        }
        if (surfaceCount != this.surfacePointsCount()) {
            System.out.println("### Invalid Surface point Particle3D: " + this.surfacePointsCount() + "/" + surfaceCount + " (Particle2D[])");
        }
        if (innerCount != this.innerPointsCount()) {
            System.out.println("### Inner point Particle3D: " + this.innerPointsCount() + "/" + innerCount + " (Particle2D[])");
        }
        return result;
    }

    public boolean intersect(Particle3D particle) {
        if (particle == null) {
            return false;
        }
        Map<Float, Particle2D> slices = Particle3D.getSurfacePointSlices(this);
        Map<Float, Particle2D> particlesSlices = Particle3D.getSurfacePointSlices(particle);
        for (Map.Entry<Float, Particle2D> e : slices.entrySet()) {
            Float z = e.getKey();
            Particle2D p1 = e.getValue();
            Particle2D p2 = particlesSlices.get(z);
            if (p1 == null || p2 == null || !p1.innerPointIntersect(p2)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append('\t');
        sb.append(this.getInnerPoints().getCenter());
        sb.append('\t');
        sb.append(this.getInnerPoints().getBarycenter());
        sb.append('\t');
        sb.append(this.getArea());
        sb.append('\t');
        sb.append(this.getVolume());
        sb.append('\t');
        sb.append(this.getSphericity());
        sb.append('\t');
        sb.append(this.getIntensity());
        sb.append('\t');
        sb.append(this.getDensity());
        sb.append('\t');
        sb.append(this.getMedianCircularity());
        sb.append('\t');
        int n = this.surfacePointsCount();
        for (i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append('(');
            sb.append(this.getSurfacePoint(i).toString());
            sb.append(')');
        }
        sb.append('\t');
        n = this.innerPointsCount();
        for (i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append('(');
            sb.append(this.getInnerPoint(i).toString());
            sb.append(')');
        }
        return sb.toString();
    }

    public AbstractListPoint3D getInnerPoints() {
        return this.unmodifiableInnerPoints;
    }

    public AbstractListPoint3D getSurfacePoints() {
        return this.unmodifiableSurfacePoints;
    }

    AbstractListPoint3D getModifiableInnerPoints() {
        return this.innerPoints;
    }

    AbstractListPoint3D getModifiableSurfacePoints() {
        return this.surfacePoints;
    }

    public float getMinDistance() {
        int n = this.innerPointsCount();
        if (n < 2) {
            return Float.MAX_VALUE;
        }
        float min = Float.MAX_VALUE;
        for (int i = 0; i < n - 1; ++i) {
            Point3D p1 = this.getInnerPoint(i);
            for (int j = i + 1; j < n; ++j) {
                Point3D p2 = this.getInnerPoint(j);
                float d = p1.distance(p2);
                if (!(d < min)) continue;
                min = d;
            }
        }
        return min;
    }

    public Point3D getNearestInnerPoint(Point3D p) {
        if (p == null) {
            return null;
        }
        Distance d = this.getNearestInnerPointDistance(p);
        return d.getPointA();
    }

    public Distance getNearestInnerPointDistance(Point3D p) {
        Point3D nearest = null;
        float minDistance = Float.MAX_VALUE;
        int n = this.innerPointsCount();
        for (int j = 0; j < n; ++j) {
            Point3D p2 = this.getInnerPoint(j);
            if (nearest == null) {
                nearest = p2;
                minDistance = p2.distance(p);
                continue;
            }
            float d = p2.distance(p);
            if (!(d < minDistance)) continue;
            minDistance = d;
            nearest = p2;
        }
        return new Distance(nearest, p, minDistance);
    }

    public Point3D getFurthestInnerPoint(Point3D p) {
        if (p == null) {
            return null;
        }
        Distance d = this.getFurthestInnerPointDistance(p);
        return d.getPointA();
    }

    public Distance getFurthestInnerPointDistance(Point3D p) {
        Point3D furthest = null;
        float maxDistance = Float.MIN_VALUE;
        int n = this.innerPointsCount();
        for (int j = 0; j < n; ++j) {
            Point3D p2 = this.getInnerPoint(j);
            if (furthest == null) {
                furthest = p2;
                maxDistance = p2.distance(p);
                continue;
            }
            float d = p2.distance(p);
            if (!(d > maxDistance)) continue;
            maxDistance = d;
            furthest = p2;
        }
        return new Distance(furthest, p, maxDistance);
    }

    public void applyXFactor(float xFactor) {
        this.surfacePoints.applyXFactor(xFactor);
        this.innerPoints.applyXFactor(xFactor);
        this.pixelWidth *= xFactor;
        this.pixelDimChange = true;
        this.clearMesurements();
    }

    public void applyYFactor(float yFactor) {
        this.surfacePoints.applyYFactor(yFactor);
        this.innerPoints.applyYFactor(yFactor);
        this.pixelHeight *= yFactor;
        this.pixelDimChange = true;
        this.clearMesurements();
    }

    public void applyZFactor(float zFactor) {
        this.surfacePoints.applyZFactor(zFactor);
        this.innerPoints.applyZFactor(zFactor);
        this.pixelDepth *= zFactor;
        this.pixelDimChange = true;
        this.clearMesurements();
    }

    public void calcIntensity() {
        long intensity = 0L;
        for (Point3D p : this.innerPoints) {
            intensity += (long)p.getI();
        }
        this.intensity = intensity;
    }

    public void calcVolume() {
        this.volume = (float)this.innerPointsCount() * this.getPixelWidth() * this.getPixelHeight() * this.getPixelDepth();
    }

    public void calcArea() {
        this.area = this.innerPoints.size() == 0 ? 0.0 : this.getBitMapParticle().calcSurface();
    }

    public void calcMedianCircularity() {
        this.medianCircularity = this.innerPoints.size() == 0 ? 0.0 : this.getBitMapParticle().calcMedianCircularity();
    }

    public void calcSphericity() {
        this.sphericity = MathUtil.sphericite2(this.getVolume(), this.getArea());
    }

    public void calcDensity() {
        this.density = (double)this.intensity / this.volume;
    }

    public void calcBitMap() {
        this.bitMapParticle = new BitMapParticle3D(this);
        this.pixelDimChange = false;
    }

    private void clearMesurements() {
        this.volume = -1.0;
        this.area = -1.0;
        this.sphericity = -1.0;
        this.density = -1.0;
        this.bitMapParticle = null;
    }

    public Particle3D(float pixelWidth, float pixelHeight, float pixelDepth) {
        this.pixelWidth = pixelWidth;
        this.pixelHeight = pixelHeight;
        this.pixelDepth = pixelDepth;
        this.surfacePoints = ListPoint3DFactory.createListPoint3D(this.pixelWidth, this.pixelHeight, this.pixelDepth);
        this.innerPoints = ListPoint3DFactory.createListPoint3D(this.pixelWidth, this.pixelHeight, this.pixelDepth);
        this.unmodifiableSurfacePoints = new UnmodifiableListPoint3D(this.surfacePoints);
        this.unmodifiableInnerPoints = new UnmodifiableListPoint3D(this.innerPoints);
    }
}

