/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.corsen.model;

import fr.ens.transcriptome.corsen.model.AbstractListPoint3D;
import fr.ens.transcriptome.corsen.model.BitMapParticle3D;
import fr.ens.transcriptome.corsen.model.Particle2D;
import fr.ens.transcriptome.corsen.model.Particle3D;
import fr.ens.transcriptome.corsen.model.Point2D;
import fr.ens.transcriptome.corsen.model.Point3D;
import fr.ens.transcriptome.corsen.util.Util;
import java.util.HashSet;
import java.util.StringTokenizer;

public class Particle3DBuilder {
    private float pixelWidth;
    private float pixelHeight;
    private float pixelDepth;
    private Particle3D particle;
    private boolean edgeParticle;
    private double volume = -1.0;
    private double area = -1.0;
    private double sphericity = -1.0;
    private long intensity = -1L;
    private double density = -1.0;
    private double medianCircularity = -1.0;

    public void add(Particle2D particle, int slice) {
        Point2D pt;
        int i;
        this.init();
        AbstractListPoint3D surfacePoints = this.particle.getModifiableSurfacePoints();
        AbstractListPoint3D innerPoints = this.particle.getModifiableInnerPoints();
        float pixelDepth = this.particle.getPixelDepth();
        int n = particle.surfacePointsCount();
        surfacePoints.ensureCapacity(n);
        for (i = 0; i < n; ++i) {
            pt = particle.getSurfacePoint(i);
            this.addSurfacePoint(pt.getX(), pt.getY(), (float)slice * pixelDepth, pt.getI());
        }
        n = particle.innerPointsCount();
        innerPoints.ensureCapacity(n);
        for (i = 0; i < n; ++i) {
            pt = particle.getInnerPoint(i);
            this.addInnerPoint(pt.getX(), pt.getY(), (float)slice * pixelDepth, pt.getI());
        }
        this.volume += particle.getArea() * (double)pixelDepth;
        this.intensity += particle.getIntensity();
        if (particle.isEdgeParticle()) {
            this.edgeParticle = true;
        }
    }

    public void add(Particle3DBuilder particle) {
        if (particle == null) {
            return;
        }
        if (particle.edgeParticle) {
            this.edgeParticle = true;
        }
        this.add(particle.getParticle());
    }

    public void add(Particle3D particle) {
        this.init();
        if (this.particle.getId() == particle.getId()) {
            throw new RuntimeException("add the same particle to particle !!!");
        }
        AbstractListPoint3D surfacePoints = this.particle.getModifiableSurfacePoints();
        AbstractListPoint3D innerPoints = this.particle.getModifiableInnerPoints();
        surfacePoints.ensureCapacity(particle.surfacePointsCount());
        innerPoints.ensureCapacity(particle.innerPointsCount());
        surfacePoints.addAll(particle.getSurfacePoints());
        innerPoints.addAll(particle.getInnerPoints());
        this.volume += particle.getVolume();
        this.intensity += particle.getIntensity();
        if (particle.isEdgeParticle()) {
            this.edgeParticle = true;
        }
    }

    public void addInnerPoint(float x, float y, float z, int i) {
        this.init();
        AbstractListPoint3D innerPoints = this.particle.getModifiableInnerPoints();
        innerPoints.add(x, y, z, i);
        this.intensity += (long)i;
    }

    public void addInnerPoint(Point3D p) {
        this.init();
        this.addInnerPoint(p, false);
    }

    public void addInnerPoint(Point3D p, boolean testIfExists) {
        if (p == null) {
            return;
        }
        this.init();
        AbstractListPoint3D innerPoints = this.particle.getModifiableInnerPoints();
        if (testIfExists && innerPoints.contains(p)) {
            return;
        }
        innerPoints.add(p);
        this.intensity += (long)p.getI();
    }

    public void addSurfacePoint(float x, float y, float z, int intensity) {
        this.init();
        AbstractListPoint3D surfacePoints = this.particle.getModifiableSurfacePoints();
        surfacePoints.add(x, y, z, intensity);
    }

    public void addSurfacePoint(Point3D p) {
        this.init();
        this.addSurfacePoint(p, false);
    }

    public void addSurfacePoint(Point3D p, boolean testIfExists) {
        if (p == null) {
            return;
        }
        this.init();
        AbstractListPoint3D surfacePoints = this.particle.getModifiableSurfacePoints();
        if (testIfExists && surfacePoints.contains(p)) {
            return;
        }
        surfacePoints.add(p);
    }

    private void parse(String s, int formatVersion) {
        Point3D p;
        String key;
        String s2;
        boolean first;
        StringTokenizer st2;
        int nbPoints;
        String points;
        if (s == null) {
            return;
        }
        this.init();
        StringTokenizer st = new StringTokenizer(s, "\t");
        if (st.hasMoreElements()) {
            this.particle.setName(st.nextToken());
        }
        if (st.hasMoreElements()) {
            st.nextToken();
        }
        if (st.hasMoreElements()) {
            st.nextToken();
        }
        if (st.hasMoreElements()) {
            this.area = Double.parseDouble(st.nextToken());
        }
        if (st.hasMoreElements()) {
            this.volume = Double.parseDouble(st.nextToken());
        }
        if (st.hasMoreElements()) {
            this.sphericity = Double.parseDouble(st.nextToken());
        }
        if (st.hasMoreElements()) {
            this.intensity = Long.parseLong(st.nextToken());
        }
        if (st.hasMoreElements()) {
            this.density = Double.parseDouble(st.nextToken());
        }
        if (formatVersion == 4 && st.hasMoreElements()) {
            this.medianCircularity = Double.parseDouble(st.nextToken());
        }
        this.area = -1.0;
        this.volume = -1.0;
        this.sphericity = -1.0;
        this.intensity = -1L;
        this.density = -1.0;
        this.medianCircularity = -1.0;
        HashSet<String> existingPoints = new HashSet<String>();
        if (st.hasMoreElements()) {
            points = st.nextToken();
            nbPoints = Util.charCount(points, '(');
            this.particle.getModifiableSurfacePoints().ensureCapacity(nbPoints);
            st2 = new StringTokenizer(points, ")");
            first = true;
            while (st2.hasMoreTokens()) {
                s2 = st2.nextToken();
                if (first) {
                    s2 = s2.substring(1, s2.length());
                    first = false;
                } else {
                    s2 = s2.substring(2, s2.length());
                }
                if (existingPoints.contains(key = (p = Point3D.parse(s2)).toStringWithoutIntensity())) continue;
                this.addSurfacePoint(p, false);
                existingPoints.add(key);
            }
        }
        existingPoints.clear();
        if (st.hasMoreElements()) {
            points = st.nextToken();
            nbPoints = Util.charCount(points, '(');
            this.particle.getModifiableInnerPoints().ensureCapacity(nbPoints);
            st2 = new StringTokenizer(points, ")");
            first = true;
            while (st2.hasMoreTokens()) {
                s2 = st2.nextToken();
                if (first) {
                    s2 = s2.substring(1, s2.length());
                    first = false;
                } else {
                    s2 = s2.substring(2, s2.length());
                }
                if (existingPoints.contains(key = (p = Point3D.parse(s2)).toStringWithoutIntensity())) continue;
                this.addInnerPoint(p, false);
                existingPoints.add(key);
            }
        }
    }

    public int innerPointsCount() {
        this.init();
        return this.particle.getModifiableInnerPoints().size();
    }

    public int surfacePointsCount() {
        this.init();
        return this.particle.getModifiableSurfacePoints().size();
    }

    public int getId() {
        this.init();
        return this.particle.getId();
    }

    public void setName(String name) {
        this.init();
        this.particle.setName(name);
    }

    public void setComment(String comment) {
        this.init();
        this.particle.setComment(comment);
    }

    private void init() {
        if (this.particle != null) {
            return;
        }
        this.particle = new Particle3D(this.pixelWidth, this.pixelHeight, this.pixelDepth);
        this.volume = 0.0;
        this.intensity = 0L;
    }

    public void setBitMapParticle(BitMapParticle3D bitmapParticle) {
        this.particle.setBitMapParticle(bitmapParticle);
    }

    public Particle3D getParticle() {
        if (this.particle == null) {
            return null;
        }
        Particle3D result = this.particle;
        result.getModifiableInnerPoints().trimToSize();
        result.getModifiableSurfacePoints().trimToSize();
        result.setVolume(this.volume);
        result.setIntensity(this.intensity);
        result.setArea(this.area);
        result.setSphericity(this.sphericity);
        result.setDensity(this.density);
        result.setMedianCircularity(this.medianCircularity);
        result.setEdgeParticle(this.edgeParticle);
        this.particle = null;
        return result;
    }

    public Particle3DBuilder(float pixelWidth, float pixelHeight, float pixelDepth) {
        this.pixelWidth = pixelWidth;
        this.pixelHeight = pixelHeight;
        this.pixelDepth = pixelDepth;
    }

    public Particle3DBuilder(Particle3D particle) {
        this(particle.getPixelWidth(), particle.getPixelHeight(), particle.getPixelDepth());
    }

    public Particle3DBuilder(float pixelWidth, float pixelHeight, float pixelDepth, String s, int formatVersion) {
        this(pixelWidth, pixelHeight, pixelDepth);
        this.parse(s, formatVersion);
    }
}

